/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.biz.event.process.BizType;
import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.AttackTypeEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZoneAttackTypeHandler
extends EventHandler<AttackTypeEvent, AttackTypeEvent> {
    private static final int COUNT = 12;
    private long previousTime;
    private Map<Type, AttackTypeEvent> attackTypeEventCache = new HashMap<Type, AttackTypeEvent>();

    public ZoneAttackTypeHandler() {
        super.setLogger(LogManager.getInstance().getHourTaskLog());
        this.refreshTime();
    }

    @Override
    public List<AttackTypeEvent> debugEvents(List<AttackTypeEvent> events) {
        return events;
    }

    private void refreshTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.previousTime = calendar.getTimeInMillis();
    }

    @Override
    protected List<AttackTypeEvent> handelEvents(List<AttackTypeEvent> events) {
        if (!events.isEmpty()) {
            try {
                this.sumEvents(events);
            }
            catch (OutOfMemoryError error) {
                this.attackTypeEventCache.clear();
                this.logger.error((Object)"out of memory ,then I clear the hour cache data", (Throwable)error);
            }
        }
        if (System.currentTimeMillis() - this.previousTime >= 3600000L) {
            this.doHourTask();
            this.refreshTime();
        }
        return new ArrayList<AttackTypeEvent>();
    }

    public void doHourTask() {
        ArrayList<AttackTypeEvent> list = new ArrayList<AttackTypeEvent>();
        if (!this.attackTypeEventCache.isEmpty()) {
            for (AttackTypeEvent each : this.attackTypeEventCache.values()) {
                each.setHourEvent(true);
                each.average(12);
                list.add(each);
            }
            this.attackTypeEventCache.clear();
            this.refreshLogTime(list);
            EventUtil.createEvents(list);
        }
    }

    private void refreshLogTime(List<AttackTypeEvent> eventsAfterMergeByIp) {
        for (AttackTypeEvent event : eventsAfterMergeByIp) {
            event.setLogTime(this.previousTime);
        }
    }

    private Map<Type, List<AttackTypeEvent>> groupEvents(List<AttackTypeEvent> events) {
        HashMap<Type, List<AttackTypeEvent>> map = new HashMap<Type, List<AttackTypeEvent>>();
        for (AttackTypeEvent e : events) {
            BizType type = new BizType(e.getAttackType(), e);
            if (map.containsKey(type)) {
                ((List)map.get(type)).add(e);
                continue;
            }
            ArrayList<AttackTypeEvent> array = new ArrayList<AttackTypeEvent>();
            array.add(e);
            map.put(type, array);
        }
        return map;
    }

    public void sumEvents(List<AttackTypeEvent> events) {
        Map<Type, List<AttackTypeEvent>> groupsByIp = this.groupEvents(events);
        for (Map.Entry<Type, List<AttackTypeEvent>> entry : groupsByIp.entrySet()) {
            List<AttackTypeEvent> sameTypeEvents = entry.getValue();
            if (sameTypeEvents.isEmpty()) continue;
            if (this.attackTypeEventCache.containsKey(entry.getKey())) {
                this.attackTypeEventCache.get(entry.getKey()).merge(sameTypeEvents);
                continue;
            }
            AttackTypeEvent first = sameTypeEvents.get(0);
            AttackTypeEvent event = new AttackTypeEvent(first.getIdentifierCopy(), first.getAttackType());
            event.merge(sameTypeEvents);
            this.attackTypeEventCache.put(entry.getKey(), event);
        }
    }
}

