/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.process;

import com.hs.atic.collector.db.event.ZoneBlacklistHistoryRepository;
import com.hs.atic.collector.entity.event.ZoneBlackListEvent;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class ZoneBlacklistHistoryRepositoryThread
extends Thread {
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final int SLEEP_TIME = 1000;
    private static ZoneBlacklistHistoryRepository repository = new ZoneBlacklistHistoryRepository();
    private List<ZoneBlackListEvent> blacklists = new ArrayList<ZoneBlackListEvent>();
    private ReentrantLock lock = new ReentrantLock();

    @Override
    public void run() {
        List<Object> tmpList = new ArrayList();
        while (true) {
            this.lock.lock();
            try {
                if (!this.blacklists.isEmpty()) {
                    tmpList = this.blacklists;
                    this.blacklists = new ArrayList<ZoneBlackListEvent>();
                }
            }
            finally {
                this.lock.unlock();
            }
            try {
                if (!tmpList.isEmpty()) {
                    repository.createObjects(tmpList);
                    tmpList.clear();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"creates blacklist history error:", (Throwable)e);
                this.addBlacklists(tmpList);
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)"sleep error.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void addBlacklists(List<ZoneBlackListEvent> blacklist1) {
        if (blacklist1 != null && !blacklist1.isEmpty()) {
            this.lock.lock();
            try {
                this.blacklists.addAll(blacklist1);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void addOneBlacklist(ZoneBlackListEvent event) {
        if (event != null) {
            this.lock.lock();
            try {
                this.blacklists.add(event);
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

