/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.protal;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.process.IpType;
import com.hs.atic.collector.biz.event.process.SumCycEvent;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.db.protal.ProtalAttackDbUtil;
import com.hs.atic.collector.entity.alarm.IpInfoKey;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.entity.protal.ProtalAttackFlowEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProtalAttackMinSumHandler
extends EventHandler<OriginalExceptionEvent, AttackTypeEvent> {
    private static final int CYC = 64;
    private long lastTime;
    private long lastCycTime;
    private Map<Type, SumCycEvent<AttackTypeEvent>> ipEventMaps = new HashMap<Type, SumCycEvent<AttackTypeEvent>>();

    public ProtalAttackMinSumHandler() {
        this.refreshLastTime();
        super.setLogger(LogManager.getInstance().getAttackLog());
        this.lastCycTime = System.currentTimeMillis() / 1000L;
    }

    @Override
    public void handel(List<OriginalExceptionEvent> events) {
        try {
            if (this.isTimeToSumOnCyc()) {
                this.lastCycTime = System.currentTimeMillis() / 1000L;
                this.sumOnOneCyc();
                ArrayList<AttackTypeEvent> list = new ArrayList<AttackTypeEvent>();
                ArrayList<Type> remove = new ArrayList<Type>();
                for (Map.Entry<Type, SumCycEvent<AttackTypeEvent>> entry : this.ipEventMaps.entrySet()) {
                    AttackTypeEvent t = entry.getValue().getInEvent();
                    if (null != t && t.isValid()) {
                        t.getIdentifier().setZoneIpType();
                        list.add(t);
                    }
                    entry.getValue().reset();
                    if (!entry.getValue().isCanDestroy()) continue;
                    remove.add(entry.getKey());
                }
                for (Type type : remove) {
                    this.ipEventMaps.remove(type);
                }
                this.refreshLogTime(list);
                this.refreshLastTime();
                this.createProtalAttackFlowEvents(list);
            }
            this.handelEvents(events);
        }
        catch (OutOfMemoryError error) {
            this.ipEventMaps.clear();
            this.logger.error((Object)"out of memory ,then I clear the  data", (Throwable)error);
        }
    }

    @Override
    protected List<AttackTypeEvent> handelEvents(List<OriginalExceptionEvent> events) {
        for (OriginalExceptionEvent event : events) {
            AttackTypeEvent e = new AttackTypeEvent(event.getIdentifierCopy(), event.getAttackType());
            e.setDropPackets(event.getDropPkgs());
            e.setDropBytes(event.getDropKbits());
            e.setAttackType(event.getAttackType());
            e.setDropPps(event.getAttackPeakPpsOrQps());
            e.setDropKbps(event.getAttackPeakKbps());
            e.setIpAttackPeakKbps(event.getIpAttackPeakKbps());
            e.setIpAttackPeakPps(event.getIpAttackPeakPps());
            e.setIpInPeakKbps(event.getIpInPeakKbps());
            e.setIpInPeakPps(event.getIpInPeakPps());
            e.setTcpCurConnNum(event.getTcpCurConnNum());
            e.setTcpNewConnNum(event.getTcpNewConnNum());
            e.setPortData(event.getPortData());
            e.setPorts(event.getPorts());
            IpType type = new IpType((Type)e.getAttackType(), e.getIdentifier(), false);
            if (this.ipEventMaps.containsKey(type)) {
                this.ipEventMaps.get(type).addEvent(e);
                continue;
            }
            this.ipEventMaps.put(type, new SumCycEvent<AttackTypeEvent>(e));
        }
        return new ArrayList<AttackTypeEvent>();
    }

    private void createProtalAttackFlowEvents(List<AttackTypeEvent> events) {
        if (!events.isEmpty()) {
            ArrayList<ProtalAttackFlowEvent> protalEvents = new ArrayList<ProtalAttackFlowEvent>();
            ProtalAttackFlowEvent protalEvent = null;
            for (AttackTypeEvent event : events) {
                protalEvent = new ProtalAttackFlowEvent(event.getIdentifierCopy());
                protalEvent.setAttackKbps(event.getDropKbps());
                protalEvent.setAttackPps(event.getDropPps());
                AttackType attackType = event.getAttackType();
                protalEvent.setAttackType(attackType.getTypeValue());
                protalEvent.setPort(attackType.getPort());
                protalEvent.setProtocol(attackType.getProtocol());
                IpInfoKey ipInfoKey = new IpInfoKey(event.getIdentifier());
                long eventId = ProtalAttackDbUtil.getInstance().getEventId(ipInfoKey);
                if (0L == eventId) continue;
                protalEvent.setEventId(eventId);
                protalEvents.add(protalEvent);
            }
            EventUtil.createEvents(protalEvents);
        }
    }

    protected boolean isTimeToSumOnCyc() {
        return System.currentTimeMillis() / 1000L - this.lastCycTime >= 64L;
    }

    protected void sumOnOneCyc() {
        for (Map.Entry<Type, SumCycEvent<AttackTypeEvent>> entry : this.ipEventMaps.entrySet()) {
            entry.getValue().sumOnOneCyc();
        }
    }

    private void refreshLastTime() {
        this.lastTime = EventUtil.getIntegralTime(64);
    }

    private void refreshLogTime(List<AttackTypeEvent> eventsAfterMergeByIp) {
        for (AttackTypeEvent event : eventsAfterMergeByIp) {
            event.setLogTime(this.lastTime);
        }
    }
}

