/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.protal;

import com.hs.atic.collector.db.monitor.DBSysConf;
import com.hs.atic.collector.db.protal.SftpImportTool;
import com.hs.atic.collector.entity.protal.ProtalServiceConfInfo;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.protal.ProtalConstants;
import com.hs.atic.collector.util.protal.ProtalUtil;
import com.hs.lego.core.sdk.base.dataprotect.util.AticDataProtector;
import java.io.File;
import org.apache.log4j.Logger;

public final class ProtalServiceFactory {
    private static ProtalServiceFactory instance = null;
    private static boolean startProtalProcess = false;
    private static ProtalServiceConfInfo serviceInfo = new ProtalServiceConfInfo();
    private static Thread sftpImprotThread = null;
    private static boolean hasProalFilePath = false;
    private Logger logger = LogManager.getInstance().getMssLogger();

    private ProtalServiceFactory() {
        try {
            this.queryServiceConfInfo();
            if (!CommonUtil.isNull(serviceInfo.getSftpServerIp()) && !"0".equals(serviceInfo.getSftpServerIp())) {
                this.setStartProtalProcess(true);
            }
        }
        catch (Exception e) {
            ProtalServiceFactory.setServiceInfo(new ProtalServiceConfInfo());
            this.logger.error((Object)"init ProtalServiceFactory error:", (Throwable)e);
        }
    }

    public static ProtalServiceFactory getInstance() {
        if (null == instance) {
            ProtalServiceFactory.setInstance(new ProtalServiceFactory());
        }
        return instance;
    }

    private void queryServiceConfInfo() {
        DBSysConf conf = new DBSysConf();
        String protalSftpServer = conf.querySysValue("protal_sftp_server");
        if (!CommonUtil.isNull(protalSftpServer) && !"0".equals(protalSftpServer)) {
            serviceInfo.setSftpServerIp(protalSftpServer);
            this.quereyServiceConfFromDB(conf);
        } else {
            ProtalServiceFactory.setServiceInfo(ProtalUtil.getInstance().getMssConfFromManger());
            ProtalUtil.getInstance().updateSftpConf(serviceInfo);
        }
    }

    private void quereyServiceConfFromDB(DBSysConf conf) {
        String protalSftpPort = conf.querySysValue("protal_sftp_port");
        serviceInfo.setSftpPort(Integer.parseInt(protalSftpPort));
        String protalSftpUser = conf.querySysValue("protal_sftp_username");
        serviceInfo.setSftpUser(protalSftpUser);
        String protalSftpPwd = conf.querySysValue("protal_sftp_pwd");
        if (protalSftpPwd != null && !protalSftpPwd.isEmpty()) {
            protalSftpPwd = AticDataProtector.sdpDecrypt(0L, protalSftpPwd).toString();
            serviceInfo.setSftpPwd(protalSftpPwd);
        }
        this.logger.info((Object)("the proatl sftp server is: " + serviceInfo.toString()));
    }

    public boolean isStartProtalProcess() {
        return startProtalProcess;
    }

    public void setStartProtalProcess(boolean newProcess) {
        if (!startProtalProcess && newProcess) {
            if (!hasProalFilePath) {
                File file = new File(ProtalConstants.PROTAL_EVENT_FILE_DIRECTORY);
                if (!file.exists() && !file.mkdirs()) {
                    this.logger.error((Object)"mkdirs in error");
                }
                ProtalServiceFactory.setHasProalFilePath(true);
            }
            if (null == sftpImprotThread) {
                ProtalServiceFactory.setSftpImprotThread(new Thread(SftpImportTool.getInstance()));
                sftpImprotThread.setName("Protal SFTP Thread" + System.currentTimeMillis());
                sftpImprotThread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
                sftpImprotThread.start();
                this.logger.info((Object)("strat sftp improt thread. " + System.currentTimeMillis()));
            } else if (!sftpImprotThread.isAlive()) {
                sftpImprotThread.start();
            }
        }
        ProtalServiceFactory.setSProtalProcess(newProcess);
    }

    public static ProtalServiceConfInfo getServiceInfo() {
        return serviceInfo;
    }

    public static void setServiceInfo(ProtalServiceConfInfo serviceInfo1) {
        serviceInfo = serviceInfo1;
    }

    public static boolean isHasProalFilePath() {
        return hasProalFilePath;
    }

    public static void setHasProalFilePath(boolean hasProalFilePath) {
        ProtalServiceFactory.hasProalFilePath = hasProalFilePath;
    }

    public static void setSProtalProcess(boolean startProtal) {
        startProtalProcess = startProtal;
    }

    public static Thread getSftpImprotThread() {
        return sftpImprotThread;
    }

    public static void setSftpImprotThread(Thread sftpImprotThread) {
        ProtalServiceFactory.sftpImprotThread = sftpImprotThread;
    }

    public static void setInstance(ProtalServiceFactory instance) {
        ProtalServiceFactory.instance = instance;
    }
}

