/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.protal;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.protal.ProtalServiceFactory;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.entity.event.SumFlowEvent;
import com.hs.atic.collector.entity.protal.ProtalFlowEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.protal.IpLocationTransUtil;
import java.util.ArrayList;
import java.util.List;

public class ProtalSumHourFlowHandler<T extends Event>
extends EventHandler<T, T> {
    @Override
    protected List<T> debugEvents(List<T> events) {
        ArrayList<Event> result = new ArrayList<Event>();
        if (ProtalServiceFactory.getInstance().isStartProtalProcess()) {
            for (Event t : events) {
                if (!t.isZoneIp() && (!t.isZoneEvent() || t.isIsMaxEvent() || !t.isInboundEvent())) continue;
                result.add(t);
            }
        }
        return result;
    }

    @Override
    protected List<T> handelEvents(List<T> events) {
        ArrayList<ProtalFlowEvent> ipInEvents = new ArrayList<ProtalFlowEvent>();
        ArrayList<ProtalFlowEvent> ipDropEvents = new ArrayList<ProtalFlowEvent>();
        ArrayList<ProtalFlowEvent> zoneInEvents = new ArrayList<ProtalFlowEvent>();
        ArrayList<ProtalFlowEvent> zoneDropEvents = new ArrayList<ProtalFlowEvent>();
        for (Event t : events) {
            SumFlowEvent event = (SumFlowEvent)t;
            FlowEvent flowEvent = event.getAverageFlow();
            ProtalFlowEvent protalEvent = new ProtalFlowEvent(event.getIdentifierCopy());
            protalEvent.mergeFlowEvent(flowEvent);
            protalEvent.setHourEvent(true);
            if (flowEvent.isZoneIp()) {
                long ip = IpTransformer.string2LongFormat(event.getZoneIp());
                long locationId = IpLocationTransUtil.getLocationIdByIpAddr(ip, 2).getLocationId();
                protalEvent.getIdentifier().setIpLocationId(locationId);
                if (flowEvent.isIsDropFlow()) {
                    protalEvent.setDropFlow(true);
                    ipDropEvents.add(protalEvent);
                    continue;
                }
                ipInEvents.add(protalEvent);
                continue;
            }
            if (flowEvent.isIsDropFlow()) {
                protalEvent.setDropFlow(true);
                zoneDropEvents.add(protalEvent);
                continue;
            }
            zoneInEvents.add(protalEvent);
        }
        EventUtil.createEvents(ipInEvents);
        EventUtil.createEvents(ipDropEvents);
        EventUtil.createEvents(zoneInEvents);
        EventUtil.createEvents(zoneDropEvents);
        return new ArrayList();
    }
}

