/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.event.protal;

import com.hs.atic.collector.biz.event.process.EventHandler;
import com.hs.atic.collector.biz.event.protal.ProtalServiceFactory;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.entity.event.SumMinFlowEvent;
import com.hs.atic.collector.entity.protal.ProtalFlowEvent;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.List;

public class ProtalSumMinFlowHandler<T extends Event>
extends EventHandler<T, T> {
    @Override
    protected List<T> debugEvents(List<T> events) {
        ArrayList<Event> result = new ArrayList<Event>();
        if (ProtalServiceFactory.getInstance().isStartProtalProcess()) {
            for (Event t : events) {
                if (!t.isZoneIp() && !t.isZoneEvent() || t.isIsMaxEvent() || t.isIsForwardFlow() || !t.isInboundEvent()) continue;
                result.add(t);
            }
        }
        return result;
    }

    @Override
    protected List<T> handelEvents(List<T> events) {
        ArrayList<ProtalFlowEvent> ipInEvents = new ArrayList<ProtalFlowEvent>();
        ArrayList<ProtalFlowEvent> ipDropEvents = new ArrayList<ProtalFlowEvent>();
        ArrayList<ProtalFlowEvent> zoneInEvents = new ArrayList<ProtalFlowEvent>();
        ArrayList<ProtalFlowEvent> zoneDropEvents = new ArrayList<ProtalFlowEvent>();
        for (Event t : events) {
            FlowEvent dropFlowEvent;
            SumMinFlowEvent event = (SumMinFlowEvent)t;
            FlowEvent inFlowEvent = event.getInFlowEvent();
            if (inFlowEvent != null) {
                ProtalFlowEvent protalInEvent = new ProtalFlowEvent(event.getIdentifierCopy());
                protalInEvent.mergeFlowEvent(inFlowEvent);
                protalInEvent.setDnsUdpFlow();
                if (event.isZoneIp()) {
                    protalInEvent.setLocaionId();
                    ipInEvents.add(protalInEvent);
                } else if (event.isZoneEvent()) {
                    zoneInEvents.add(protalInEvent);
                }
            }
            if ((dropFlowEvent = event.getDropFlowEvent()) == null || 0L == dropFlowEvent.getAllKbps() && 0L == dropFlowEvent.getAckPps()) continue;
            ProtalFlowEvent protalDropEvent = new ProtalFlowEvent(event.getIdentifierCopy());
            protalDropEvent.mergeFlowEvent(dropFlowEvent);
            protalDropEvent.setDropFlow(true);
            protalDropEvent.setDnsUdpFlow();
            if (event.isZoneIp()) {
                protalDropEvent.setLocaionId();
                ipDropEvents.add(protalDropEvent);
                continue;
            }
            if (!event.isZoneEvent()) continue;
            zoneDropEvents.add(protalDropEvent);
        }
        EventUtil.createEvents(ipInEvents);
        EventUtil.createEvents(ipDropEvents);
        EventUtil.createEvents(zoneInEvents);
        EventUtil.createEvents(zoneDropEvents);
        return new ArrayList();
    }
}

