/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.monitor;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.biz.monitor.ISystemTool;
import com.hs.atic.collector.biz.monitor.SystemToolFactory;
import com.hs.atic.collector.db.monitor.DBCollectorDisk;
import com.hs.atic.collector.db.monitor.DBCollectorPerf;
import com.hs.atic.collector.db.monitor.DBSysConf;
import com.hs.atic.collector.entity.alarm.DiskSpaceAlarmEntity;
import com.hs.atic.collector.entity.monitor.CollectorDiskObj;
import com.hs.atic.collector.entity.monitor.CollectorPerfObj;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class MonitorCollector {
    private static final int DISK_ALARM_RANGE = 5012;
    private static final Logger LOGGER = LogManager.getInstance().getSystemLog();
    private static AtomicBoolean diskOk = new AtomicBoolean(true);
    private static AtomicBoolean diskEnough = new AtomicBoolean(false);
    private int diskThreshold = 5012;
    private int diskEnoughThreshold = this.diskThreshold + 5012;
    private String diskName = "D";

    public MonitorCollector() {
        String currPath = AticInstallUtil.getInstance().getCollectorInstallPath();
        this.diskName = currPath.substring(0, 1);
        LOGGER.info((Object)("diskName=" + this.diskName));
    }

    public void monitor() {
        ISystemTool systemTool = SystemToolFactory.getSystemTool();
        long monitorTime = System.currentTimeMillis() / 1000L;
        try {
            List<CollectorDiskObj> diskInfoList = systemTool.getDisk(monitorTime);
            this.saveDiskInfo2DB(diskInfoList);
            int freeSpace = 0;
            for (CollectorDiskObj disk : diskInfoList) {
                if (!disk.getDiskName().equalsIgnoreCase(this.diskName)) continue;
                int diskSize = disk.getDiskSize();
                int diskUseRatio = disk.getDiskUseRatio();
                freeSpace = diskSize - diskSize * diskUseRatio / 100;
                break;
            }
            try {
                DBSysConf db = new DBSysConf();
                String threshold = db.querySysValue("disk_threshold");
                this.diskThreshold = Integer.parseInt(threshold);
                this.diskEnoughThreshold = this.diskThreshold + 5012;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Get disk_threshold error.", (Throwable)e);
            }
            DiskSpaceAlarmEntity diskEntity = null;
            if (freeSpace < this.diskThreshold) {
                if (diskOk.get()) {
                    diskEntity = this.initDiskAlarmEntity(this.diskThreshold, freeSpace, 4, true);
                    LOGGER.error((Object)("set diskOk = false: the collector can not receive packge, send alarm. freeSpace:" + freeSpace + ", diskThreshold:" + this.diskThreshold + "."));
                    diskOk.set(false);
                }
            } else if (freeSpace >= this.diskThreshold && freeSpace < this.diskEnoughThreshold) {
                if (!diskOk.get()) {
                    LOGGER.info((Object)("set diskOk = true: the collector can receive packge, freeSpace:" + freeSpace + ", diskThreshold:" + this.diskThreshold + "."));
                    diskOk.set(true);
                }
                if (diskEnough.get()) {
                    diskEntity = this.initDiskAlarmEntity(this.diskThreshold, freeSpace, 3, true);
                    LOGGER.info((Object)("set diskEnough = false, send alarm. freeSpace:" + freeSpace + " < diskEnoughThreshold:" + this.diskEnoughThreshold + "."));
                    diskEnough.set(false);
                }
            } else if (freeSpace >= this.diskEnoughThreshold) {
                if (!diskOk.get()) {
                    LOGGER.info((Object)("set diskOk = true: the collector can receive packge, freeSpace:" + freeSpace + ", diskThreshold:" + this.diskThreshold + "."));
                    diskOk.set(true);
                }
                if (!diskEnough.get()) {
                    diskEntity = this.initDiskAlarmEntity(this.diskThreshold, freeSpace, 3, false);
                    LOGGER.info((Object)("set diskEnough = true, send alarm clean.  freeSpace:" + freeSpace + " >= diskEnoughThreshold:" + this.diskEnoughThreshold + "."));
                    diskEnough.set(true);
                }
            }
            if (diskEntity != null) {
                AlarmThread.getInstance().addDiskSpaceAlarm(diskEntity);
            }
            CollectorPerfObj collectorPerfObj = new CollectorPerfObj();
            collectorPerfObj.setCpuUseRatio(systemTool.getCpuInfo());
            collectorPerfObj.setMemUseRatio(systemTool.getPercentMemInfo());
            collectorPerfObj.setMonitorTime(monitorTime);
            this.saveCollectorPerf2DB(collectorPerfObj);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"When monitor collector, some errors happened : ", (Throwable)e);
        }
    }

    private DiskSpaceAlarmEntity initDiskAlarmEntity(int threshold, int freeSpace, int severity, boolean isAlarm) {
        DiskSpaceAlarmEntity diskEntity = new DiskSpaceAlarmEntity();
        diskEntity.setAlarm(isAlarm);
        diskEntity.setThreshold(String.valueOf(threshold));
        diskEntity.setCrrentPercent(String.valueOf(freeSpace));
        diskEntity.setSeverity(severity);
        diskEntity.setDiskName(this.diskName);
        return diskEntity;
    }

    private void saveDiskInfo2DB(List<CollectorDiskObj> collectorDiskList) {
        if (collectorDiskList != null && !collectorDiskList.isEmpty()) {
            DBCollectorDisk cddb = new DBCollectorDisk();
            cddb.add(collectorDiskList);
        }
    }

    private void saveCollectorPerf2DB(CollectorPerfObj collectorPerfObj) {
        if (collectorPerfObj.getMonitorTime() != 0L) {
            DBCollectorPerf cpdb = new DBCollectorPerf();
            cpdb.add(collectorPerfObj);
        }
    }

    public static boolean isDiskOk() {
        return diskOk.get();
    }
}

