/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.monitor;

import com.hs.atic.collector.biz.monitor.ISystemTool;
import com.hs.atic.collector.entity.monitor.CollectorDiskObj;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WindowsSystemTool
implements ISystemTool {
    private static final String CPU_USE_PERCENT = "CPU";
    private static final String MEM_TOTALMEM = "TOTALMEM";
    private static final String MEM_AVAILMEM = "AVAILMEM";
    private static final long MB = 0x100000L;
    private static final double DBHUNDRED = 100.0;
    private static final double LHUNDRED = 100.0;
    private static final int MAX_COUNT = 0x100000;
    private static final Logger LOGGER = LogManager.getInstance().getMonitorLog();
    private String cmd = "";

    public WindowsSystemTool() {
        String currentPath = AticInstallUtil.getInstance().getCollectorInstallPath();
        this.cmd = currentPath + File.separator + "tools" + File.separator + "Resource.exe ";
    }

    @Override
    public int getCpuInfo() {
        long percent = 0L;
        try {
            percent = this.getCPUAndMenInfo(CPU_USE_PERCENT);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
        return (int)percent;
    }

    @Override
    public int getPercentMemInfo() {
        long total = this.getTotalMemInfo();
        long avail = this.getAvailMemInfo();
        long use = total - avail;
        double percent = (double)use * 100.0 / (double)total;
        return (int)percent;
    }

    @Override
    public long getAvailMemInfo() {
        return this.getCPUAndMenInfo(MEM_AVAILMEM);
    }

    @Override
    public long getTotalMemInfo() {
        return this.getCPUAndMenInfo(MEM_TOTALMEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long getCPUAndMenInfo(String para) {
        para = this.cmd + para;
        Process pp = null;
        long returnVaule = 1L;
        LineNumberReader input = null;
        LineNumberReader inputError = null;
        try {
            pp = Runtime.getRuntime().exec(para);
            input = new LineNumberReader(new InputStreamReader(pp.getInputStream(), "utf-8"));
            String nextStr = input.readLine();
            if (nextStr != null) {
                returnVaule = Long.parseLong(nextStr);
            }
            inputError = new LineNumberReader(new InputStreamReader(pp.getErrorStream(), "utf-8"));
            StringBuffer errorBuffer = new StringBuffer();
            while (inputError.read() != -1 && errorBuffer.length() <= 0x100000) {
                String line = inputError.readLine();
                errorBuffer.append(line);
            }
            if (errorBuffer.length() > 0) {
                LOGGER.error((Object)("errorBuffer content is:" + errorBuffer.toString()));
            }
            this.closeStream(input);
            this.closeStream(inputError);
            if (null != pp) {
                pp.destroy();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage());
        }
        finally {
            this.closeStream(input);
            this.closeStream(inputError);
            if (null != pp) {
                pp.destroy();
            }
        }
        return returnVaule;
    }

    private void closeStream(LineNumberReader input) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage());
            }
        }
    }

    @Override
    public synchronized List<CollectorDiskObj> getDisk(long monitorTime) {
        File[] roots = File.listRoots();
        ArrayList<CollectorDiskObj> list = new ArrayList<CollectorDiskObj>();
        if (roots == null) {
            return list;
        }
        for (File file : roots) {
            CollectorDiskObj disktemp = new CollectorDiskObj();
            disktemp.setDiskName(file.getPath().substring(0, 1));
            disktemp.setMonitorTime(monitorTime);
            double totalSpace = file.getTotalSpace();
            double usableSpace = file.getUsableSpace();
            if (!(totalSpace > 0.0) || !file.canWrite() || !(usableSpace >= 0.0)) continue;
            double total = this.getDoubleValue(totalSpace / 1048576.0);
            disktemp.setDiskSize((int)total);
            double useableGB = this.getDoubleValue(usableSpace / 1048576.0);
            double percent = this.getDoubleValue((total - useableGB) / total) * 100.0;
            disktemp.setDiskUseRatio((int)percent);
            list.add(disktemp);
        }
        return list;
    }

    private double getDoubleValue(double value) {
        BigDecimal capacity = new BigDecimal(value);
        double temp = capacity.setScale(2, 4).doubleValue();
        return temp;
    }
}

