/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.pcap;

import com.hs.atic.collector.biz.pcap.EncrypAES;
import com.hs.atic.collector.entity.Collector;
import com.hs.atic.collector.entity.monitor.DeviceObj;
import com.hs.atic.collector.util.LogManager;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.NoSuchPaddingException;
import org.apache.log4j.Logger;

public final class AESDecryptorFactory {
    private static AESDecryptorFactory instance = null;
    private static final Logger LOGGER = LogManager.getInstance().getPcapLogger();
    private static final ThreadLocal<Map<String, EncrypAES>> DEV_DECRYPTOR_MAP = new ThreadLocal();
    private static final ThreadLocal<Map<String, Long>> UPDATE_TIME_MAP = new ThreadLocal();
    private Map<String, Long> devAseModifyTimeMap = new ConcurrentHashMap<String, Long>();

    private AESDecryptorFactory() {
    }

    private static Map<String, EncrypAES> getDevDncryptorMap() {
        Map<String, EncrypAES> map = null;
        try {
            map = DEV_DECRYPTOR_MAP.get();
            if (map == null) {
                map = new HashMap<String, EncrypAES>();
                DEV_DECRYPTOR_MAP.set(map);
            }
        }
        catch (Exception e) {
            map = null;
            LOGGER.error((Object)"getThreadLocalMap error:", (Throwable)e);
        }
        return map;
    }

    private static Map<String, Long> getAseDeviceUpdateTimeMap() {
        Map<String, Long> map = UPDATE_TIME_MAP.get();
        if (map == null) {
            try {
                map = new HashMap<String, Long>();
                UPDATE_TIME_MAP.set(map);
            }
            catch (Exception e) {
                map = null;
                LOGGER.error((Object)"getThreadLocalMap error:", (Throwable)e);
            }
        }
        return map;
    }

    private EncrypAES getDecryptByIp(String logIp) {
        EncrypAES decryptor = null;
        DeviceObj device = Collector.getInstance().getDeviceByIp(logIp);
        if (device != null) {
            StringBuffer key = new StringBuffer();
            key.append(device.getLogPwd());
            if (key.length() < 32) {
                LOGGER.error((Object)("the logPwd is error of device log IP:" + logIp));
                return null;
            }
            try {
                StringBuffer decryptKey = new StringBuffer();
                decryptKey.append(key.substring(0, 32));
                decryptor = new EncrypAES(decryptKey);
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.error((Object)"modifyDevDecryptor NoSuchAlgorithmException error. ", (Throwable)e);
            }
            catch (NoSuchPaddingException e) {
                LOGGER.error((Object)"modifyDevDecryptor NoSuchPaddingException error. ", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error((Object)"modifyDevDecryptor Exception error. ", (Throwable)e);
            }
        }
        return decryptor;
    }

    public void checkRemoveDecryptMap(String logIp) {
        Long mapModifyTime = this.devAseModifyTimeMap.get(logIp);
        if (mapModifyTime != null) {
            long updateTime = 0L;
            long modifyTime = mapModifyTime;
            Map<String, Long> mapUpdateTimeMap = AESDecryptorFactory.getAseDeviceUpdateTimeMap();
            Long mapUpdateTime = mapUpdateTimeMap.get(logIp);
            if (mapUpdateTime != null) {
                updateTime = mapUpdateTime;
            }
            if (modifyTime > updateTime) {
                Map<String, EncrypAES> devDecMap = AESDecryptorFactory.getDevDncryptorMap();
                devDecMap.remove(logIp);
                mapUpdateTimeMap.put(logIp, System.currentTimeMillis());
            }
        }
    }

    public static synchronized AESDecryptorFactory getInstance() {
        if (instance == null) {
            instance = new AESDecryptorFactory();
        }
        return instance;
    }

    public byte[] decrypt(byte[] data, String logIp) {
        Map<String, EncrypAES> devDecMap = AESDecryptorFactory.getDevDncryptorMap();
        EncrypAES decryptor = devDecMap.get(logIp);
        if (decryptor == null) {
            decryptor = this.getDecryptByIp(logIp);
            devDecMap.put(logIp, decryptor);
        }
        if (null != decryptor) {
            try {
                return decryptor.decryptor(data);
            }
            catch (Exception e) {
                LOGGER.error((Object)"decrypt Exception error. ", (Throwable)e);
            }
        } else {
            LOGGER.error((Object)("getDecryptByIp error logIp :" + logIp));
        }
        return new byte[0];
    }

    public byte[] decrypt(byte[] data, byte[] iv, String logIp) {
        Map<String, EncrypAES> devDecMap = AESDecryptorFactory.getDevDncryptorMap();
        EncrypAES decryptor = devDecMap.get(logIp);
        if (decryptor == null) {
            decryptor = this.getDecryptByIp(logIp);
            if (decryptor != null) {
                devDecMap.put(logIp, decryptor);
            } else {
                LOGGER.error((Object)("getDecryptByIp error logIp : " + logIp));
                return new byte[0];
            }
        }
        try {
            return decryptor.decryptor(data, iv);
        }
        catch (Exception e) {
            LOGGER.error((Object)"decrypt error. ", (Throwable)e);
            return new byte[0];
        }
    }

    public void modifyDevDecryptor(DeviceObj device) {
        if (null == device) {
            LOGGER.error((Object)"input device is null");
            return;
        }
        String logIp = device.getLogIp();
        int encryptType = device.getEncryptType();
        if (1 == encryptType || 0 == encryptType) {
            this.devAseModifyTimeMap.put(logIp, System.currentTimeMillis());
        }
    }
}

