/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.pcap;

import com.hs.atic.collector.util.LogManager;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class EncrypAES {
    private static final Logger LOGGER = LogManager.getInstance().getPcapLogger();
    IvParameterSpec iv;
    SecretKeySpec key;
    private Cipher cipher;

    public EncrypAES() throws NoSuchAlgorithmException, NoSuchPaddingException {
        byte[] enCodeFormat = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.key = new SecretKeySpec(enCodeFormat, "AES");
        byte[] ivBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
        this.iv = new IvParameterSpec(ivBytes);
    }

    public EncrypAES(StringBuffer keyStr) throws NoSuchAlgorithmException, NoSuchPaddingException {
        byte[] keyByte = null;
        try {
            keyByte = keyStr.toString().getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("EncrypAES is error:" + e));
        }
        byte[] enCodeFormat = new byte[32];
        if (keyByte != null && keyByte.length < 32) {
            System.arraycopy(keyByte, 0, enCodeFormat, 0, keyByte.length);
        } else {
            System.arraycopy(keyByte, 0, enCodeFormat, 0, 32);
        }
        this.key = new SecretKeySpec(enCodeFormat, "AES");
        byte[] ivBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
        this.iv = new IvParameterSpec(ivBytes);
    }

    public byte[] decryptor(byte[] buff) {
        return this.decryptor(buff, null);
    }

    public byte[] decryptor(byte[] buff, byte[] ivByte) {
        if (null != ivByte && 0 != ivByte.length) {
            this.iv = new IvParameterSpec(ivByte);
        }
        try {
            this.cipher.init(2, (Key)this.key, this.iv);
        }
        catch (InvalidKeyException e) {
            LOGGER.error((Object)("cipher.init is error" + e));
        }
        catch (InvalidAlgorithmParameterException e) {
            LOGGER.error((Object)("cipher.init is error" + e));
        }
        byte[] cipherByte = null;
        try {
            cipherByte = this.cipher.doFinal(buff);
            if (LOGGER.isInfoEnabled() && cipherByte[32] == 15 && cipherByte[48] == 14) {
                Thread curThread = Thread.currentThread();
                String threadName = curThread.getName();
                LOGGER.info((Object)("threadName : " + threadName + " decryptor buff       = " + EncrypAES.getByteArrayStrNoOx(buff)));
                LOGGER.info((Object)("threadName : " + threadName + " decryptor cipherByte = " + EncrypAES.getByteArrayStrNoOx(cipherByte)));
            }
        }
        catch (IllegalBlockSizeException e) {
            LOGGER.error((Object)"cipher.doFinal is error", (Throwable)e);
        }
        catch (BadPaddingException e) {
            LOGGER.error((Object)"cipher.doFinal is error", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"cipher.doFinal is error", (Throwable)e);
        }
        return cipherByte;
    }

    public static String getByteArrayStrNoOx(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            Formatter formatter = new Formatter();
            Locale defloc = Locale.getDefault();
            if (data[i] < 16 && data[i] >= 0) {
                buffer.append('0');
            }
            buffer.append(formatter.format("%x", data[i]).toString().toUpperCase(defloc));
        }
        return buffer.toString();
    }
}

