/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.pcap.task;

import com.hs.atic.collector.biz.pcap.PcapBuilder;
import com.hs.atic.collector.entity.pcap.CaptureTask;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.PcapUtil;
import org.apache.log4j.Logger;

public final class CheckFileWriterTask
extends Thread {
    private static CheckFileWriterTask instance = new CheckFileWriterTask();
    private static final long DEFAULT_CHECK_PCAP_PEROID = 60000L;
    private static final Logger LOGGER = LogManager.getInstance().getPcapLogger();
    private PcapBuilder builder;
    private boolean isStop;
    private long period = 60000L;

    private CheckFileWriterTask() {
        this.initCheckPcapPeriod();
    }

    public static CheckFileWriterTask getInstance() {
        return instance;
    }

    @Override
    public void run() {
        while (!this.isStop) {
            try {
                this.check();
                Thread.sleep(this.period);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(this.period);
                }
                catch (InterruptedException e1) {
                    LOGGER.warn((Object)"when sleep ,interupted", (Throwable)e1);
                }
                LOGGER.warn((Object)"when sleep ,interupted", (Throwable)e);
            }
        }
    }

    public void setBuilder(PcapBuilder builder) {
        this.builder = builder;
    }

    public void stopIt() {
        this.isStop = true;
    }

    private void check() {
        if (null != this.builder) {
            for (CaptureTask task : this.builder.getCaptureTasks()) {
                task.check();
            }
        }
    }

    private void initCheckPcapPeriod() {
        try {
            this.period = Long.parseLong(PcapUtil.getPcapConfigProperty("CheckPcapThreadPeriod"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error,key is CheckPcapThreadPeriod");
        }
    }
}

