/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.pcap.task;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.db.condition.AllCondition;
import com.hs.atic.collector.entity.monitor.CollectorDiskObj;
import com.hs.atic.collector.entity.pcap.PcapFileInfo;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.PcapUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public final class CleanPcapFileThread
extends Thread {
    private static final Logger LOGGER = LogManager.getInstance().getPcapLogger();
    private static final int LIMIT = 80;
    private static CleanPcapFileThread instance = new CleanPcapFileThread();
    List<String> totalFilesName = new ArrayList<String>();
    private Repository pcapRepository = RepositoryFactory.getInstance().getRepository(PcapFileInfo.class.getName());
    private Map<String, PcapFileInfo> pcapFilesMap = new HashMap<String, PcapFileInfo>();
    private boolean shouldDo = false;
    private int diskUseLimit;
    private int time = 3600;
    private ScheduledExecutorService scheduler;

    private CleanPcapFileThread() {
        try {
            this.diskUseLimit = Integer.parseInt(PcapUtil.getPcapConfigProperty("DiskUseLimitRatio"));
            LOGGER.info((Object)("Disk Use Limit Ratio is : " + this.diskUseLimit + "."));
        }
        catch (RuntimeException e) {
            this.diskUseLimit = 80;
            LOGGER.info((Object)("Read file pcap.conf wrong, and Disk Use Limit Ratio is : " + this.diskUseLimit + "."));
        }
        this.init();
    }

    public static CleanPcapFileThread getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: while (true) {
            try {
                while (true) {
                    List<String> files;
                    CleanPcapFileThread cleanPcapFileThread = this;
                    synchronized (cleanPcapFileThread) {
                        while (!this.shouldDo) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                LOGGER.warn((Object)"when sleep ,interupted", (Throwable)e);
                            }
                        }
                        files = this.totalFilesName;
                        this.totalFilesName = new ArrayList<String>();
                        this.shouldDo = false;
                    }
                    if (null != files && !files.isEmpty()) {
                        this.deleteDiskFiles(files);
                    }
                    try {
                        Thread.sleep(10000L);
                        continue block9;
                    }
                    catch (InterruptedException e) {
                        LOGGER.warn((Object)"when sleep ,interupted", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)"some unknow error happend,to keep the thread alive ,i catch it", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void deleteDiskFiles(List<String> files) {
        if (null == files || files.isEmpty()) {
            return;
        }
        String pcapFileDirectory = PcapUtil.getPcapFileDirectory();
        for (String fileName : files) {
            String filePath = pcapFileDirectory + File.separator + fileName + ".pcap";
            File tempFile = new File(filePath);
            if (!tempFile.exists() || tempFile.delete()) continue;
            LOGGER.error((Object)"delete tempFile in error");
        }
        CollectorDiskObj disk = PcapUtil.getDiskInfo();
        if (null != disk) {
            AlarmThread.getInstance().addCleanPcapAlarmEntity(disk.getDiskName(), String.valueOf(this.diskUseLimit), files.size());
        }
    }

    private void init() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                List pcapFiles = CleanPcapFileThread.this.pcapRepository.queryObject(new AllCondition());
                CleanPcapFileThread.this.pcapFilesMap = new HashMap();
                if (pcapFiles.size() > 0) {
                    String key = "";
                    for (PcapFileInfo pcap : pcapFiles) {
                        key = pcap.getFileName() + ".pcap";
                        CleanPcapFileThread.this.pcapFilesMap.put(key, pcap);
                    }
                }
                String path = AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "pcap";
                CleanPcapFileThread.this.deleteFile(path);
            }
        }, 0L, this.time, TimeUnit.SECONDS);
    }

    private void deleteFile(String path) {
        File filedir = new File(path);
        File[] farray = filedir.listFiles();
        if (null != farray && farray.length > 0) {
            for (File f : farray) {
                if (f.isDirectory()) {
                    this.deleteFile(f.getPath());
                    continue;
                }
                if (!f.getName().contains(".pcap") || this.pcapFilesMap.get(f.getName()) != null || f.delete()) continue;
                LOGGER.error((Object)"delete pcapFile is error");
            }
        }
    }

    public synchronized void addDelFileNameToList(List<String> delFilesName) {
        this.totalFilesName.addAll(delFilesName);
        this.shouldDo = true;
        this.notifyAll();
    }
}

