/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.biz.report.CommomSqlUtil;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.log.AttackTypeDistributing;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.entity.log.TimeDurationForm;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AttackDistributeUtil {
    protected static final Logger LOG = LogManager.getInstance().getReportLogger();
    private Map<Integer, Object> condition = null;

    public List<TimeDurationForm> processTimeByType(long startTime, long endTime) {
        long startTimeAfter = 0L;
        long endTimeBefore = 0L;
        endTime = this.getRealEndTime(endTime);
        String tableType = this.getQueryTableType(startTime, endTime);
        ArrayList<TimeDurationForm> durationFormList = new ArrayList<TimeDurationForm>();
        if ("HOUR".equalsIgnoreCase(tableType)) {
            long startGra = startTime % CollectorConstants.ONE_HOUR;
            long endGra = endTime % CollectorConstants.ONE_HOUR;
            startTimeAfter = startGra == 0L ? startTime : startTime + CollectorConstants.ONE_HOUR - startGra;
            endTimeBefore = endTime - endGra;
            if (startTime != startTimeAfter) {
                TimeDurationForm minuteStartForm = new TimeDurationForm();
                minuteStartForm.setStartTime(this.processStartFiveMinute(startTime));
                minuteStartForm.setEndTime(startTimeAfter - 1L);
                minuteStartForm.setTimeType("MINUTE");
                durationFormList.add(minuteStartForm);
            }
            if (startTimeAfter != endTimeBefore) {
                TimeDurationForm hourForm = new TimeDurationForm();
                hourForm.setStartTime(startTimeAfter);
                hourForm.setEndTime(endTimeBefore - 1L);
                hourForm.setTimeType("HOUR");
                durationFormList.add(hourForm);
            }
            if (endTimeBefore != endTime) {
                TimeDurationForm minuteEndForm = new TimeDurationForm();
                minuteEndForm.setStartTime(endTimeBefore);
                minuteEndForm.setEndTime(endTime);
                minuteEndForm.setTimeType("MINUTE");
                durationFormList.add(minuteEndForm);
            }
        } else if ("DAY".equalsIgnoreCase(tableType)) {
            startTimeAfter = this.getDayStartTime(startTime);
            endTimeBefore = this.getDayStartTime(endTime);
            if (startTime != startTimeAfter) {
                TimeDurationForm minuteStartForm = new TimeDurationForm();
                minuteStartForm.setStartTime(this.processStartFiveMinute(startTime));
                minuteStartForm.setEndTime((startTimeAfter += CollectorConstants.ONE_DAY.longValue()) - 1L);
                minuteStartForm.setTimeType("MINUTE");
                durationFormList.add(minuteStartForm);
            }
            if (startTimeAfter != endTimeBefore) {
                TimeDurationForm dayForm = new TimeDurationForm();
                dayForm.setStartTime(startTimeAfter);
                dayForm.setEndTime(endTimeBefore - 1L);
                dayForm.setTimeType("DAY");
                durationFormList.add(dayForm);
            }
            if (endTimeBefore != endTime) {
                TimeDurationForm minuteEndForm = new TimeDurationForm();
                minuteEndForm.setStartTime(endTimeBefore);
                minuteEndForm.setEndTime(endTime);
                minuteEndForm.setTimeType("MINUTE");
                durationFormList.add(minuteEndForm);
            }
        } else {
            TimeDurationForm minuteForm = new TimeDurationForm();
            minuteForm.setStartTime(this.processStartFiveMinute(startTime));
            minuteForm.setEndTime(endTime);
            minuteForm.setTimeType("MINUTE");
            durationFormList.add(minuteForm);
        }
        return durationFormList;
    }

    private long processStartFiveMinute(long startTime) {
        return startTime - startTime % CollectorConstants.FIVE_MIN;
    }

    public long getDayStartTime(long startTime) {
        if (Long.valueOf(startTime) == null) {
            return 0L;
        }
        long timeLong = 0L;
        try {
            SimpleDateFormat fromate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date(startTime * 1000L);
            String timeString = fromate.format(date);
            StringBuffer bufferTime = new StringBuffer(timeString.split(" ")[0]);
            bufferTime.append(" 00:00:00");
            Date startDate = fromate.parse(bufferTime.toString().trim());
            timeLong = startDate.getTime() / 1000L;
        }
        catch (ParseException ex) {
            LOG.error((Object)"Parse time exception to start time !", (Throwable)ex);
        }
        return timeLong;
    }

    private String getQueryTableType(Long startTime, Long endTime) {
        String tableType = "";
        long span = endTime - startTime;
        if (span < CollectorConstants.ONE_DAY && span >= 0L) {
            tableType = "MINUTE";
        } else if (span < CollectorConstants.ONE_WEEK && span >= CollectorConstants.ONE_DAY) {
            tableType = "HOUR";
        } else if (span < CollectorConstants.ONE_YEAR && span >= CollectorConstants.ONE_WEEK) {
            tableType = "DAY";
        }
        return tableType;
    }

    private Long getRealEndTime(Long endTime) {
        Date date = new Date();
        Long now = date.getTime();
        if (endTime > now / 1000L) {
            endTime = now / 1000L;
        }
        return endTime;
    }

    public Map<String, List<AttackTypeDistributing>> getAttackCountDis(DataStatCondition cds) {
        String tableName = "atic_ip_attack_exact_log";
        this.condition = new HashMap<Integer, Object>();
        String sql = this.queryCountSql(cds, tableName);
        LOG.info((Object)("AttackTypeDistributing getAttackCounts sql: " + sql));
        Map<String, List<AttackTypeDistributing>> flowList = this.findAttackTypeDistributing(sql, false);
        return flowList;
    }

    public List<AttackTypeDistributing> getAttackDurationAndTrafficPeakCountDis(DataStatCondition cds) {
        String tableName = "atic_ip_attack_exact_log";
        this.condition = new HashMap<Integer, Object>();
        String sql = this.getCountDurationCustomSql(cds, tableName);
        LOG.info((Object)("AttackTypeDistributing getAttackCounts sql: " + sql));
        List<AttackTypeDistributing> flowList = this.findAttackDurationDistributing(sql);
        return flowList;
    }

    public List<AttackTypeDistributing> getAttackVectorCountDis(DataStatCondition cds) {
        String tableName = "atic_ip_attack_log";
        this.condition = new HashMap<Integer, Object>();
        String sql = this.getCountVectorCustomSql(cds, tableName);
        LOG.info((Object)("AttackTypeDistributing getAttackCounts sql: " + sql));
        List<AttackTypeDistributing> flowList = this.findAttackVectorDistributing(sql);
        return flowList;
    }

    public Map<String, List<AttackTypeDistributing>> getAttackPacketDis(DataStatCondition cds, String timeType) {
        String tablePostfix = "";
        tablePostfix = "HOUR".equalsIgnoreCase(timeType) ? "_H" : ("DAY".equalsIgnoreCase(timeType) ? "_D" : "");
        StringBuffer tableName = new StringBuffer();
        if (null == cds.getZoneIp()) {
            tableName.append("ATIC_ZONE_ATTACK_FLOW");
        } else {
            tableName.append("ATIC_IP_ATTACK_FLOW");
        }
        tableName.append(tablePostfix);
        this.condition = new HashMap<Integer, Object>();
        String sql = this.queryPacketSql(cds, tableName.toString());
        LOG.info((Object)("AttackTypeDistributing getDropPackets sql: " + sql));
        Map<String, List<AttackTypeDistributing>> flowList = this.findAttackTypeDistributing(sql, true);
        return flowList;
    }

    private String queryPacketSql(DataStatCondition cds, String tableName) {
        StringBuffer sql = new StringBuffer();
        String customSql = this.getPacketCustomSql(cds, tableName);
        sql.append("select deviceIp,IF(attackType<10,0,attackType) attackType,dropBytes,dropPackets,protocol,port,zoneId from ( ");
        sql.append(customSql);
        sql.append(" ) as result order by ");
        if (cds.getUnit() == 1) {
            sql.append(" result.dropPackets desc");
        } else {
            sql.append(" result.dropBytes desc");
        }
        return sql.toString();
    }

    private String getPacketCustomSql(DataStatCondition cds, String tableName) {
        StringBuffer sql = new StringBuffer(" select device_ip as deviceIp,attack_type as attackType,sum(drop_bytes) as dropBytes,sum(drop_packets) as dropPackets");
        sql.append(",protocol,port,zone_id as zoneId from ");
        sql.append(tableName);
        sql.append(" where ");
        sql.append(this.getPacketCondition(cds, tableName));
        sql.append(" group by deviceIp,IF(attackType<10,0,attackType),zoneId,protocol,port");
        return sql.toString();
    }

    private String queryCountSql(DataStatCondition cds, String tableName) {
        StringBuffer sql = new StringBuffer();
        String customSql = this.getCountCustomSql(cds, tableName);
        sql.append("select deviceIp,IF(attackType<10,0,attackType) attackType,counts,protocol,port,zoneId from ( ");
        sql.append(customSql);
        sql.append(" ) as result order by ");
        sql.append(" result.counts desc");
        return sql.toString();
    }

    private String getCountCustomSql(DataStatCondition cds, String tableName) {
        StringBuffer sql = new StringBuffer(" select device_ip as deviceIp,attack_type as attackType,count(attack_type) as counts");
        sql.append(",protocol,port,zone_id as zoneId from ");
        sql.append(tableName);
        sql.append(" where ");
        sql.append(this.getCountCondition(cds, tableName));
        sql.append(" group by deviceIp,IF(attackType<10,0,attackType),zoneId,protocol,port");
        return sql.toString();
    }

    private String getCountDurationCustomSql(DataStatCondition cds, String tableName) {
        StringBuffer sql = new StringBuffer(" select device_ip as deviceIp,duration,attack_type as attackType");
        sql.append(",protocol,port,zone_id as zoneId,max_drop_kbps,start_time_attack,start_time_alert from ");
        sql.append(tableName);
        sql.append(" where ");
        sql.append(this.getCountCondition(cds, tableName));
        return sql.toString();
    }

    private String getCountVectorCustomSql(DataStatCondition cds, String tableName) {
        StringBuffer sql = new StringBuffer(" select device_ip as deviceIp,duration");
        sql.append(",zone_id as zoneId,exact_log_id from ");
        sql.append(tableName);
        sql.append(" where ");
        sql.append(this.getCountVectorCondition(cds, tableName));
        return sql.toString();
    }

    private String getCountVectorCondition(DataStatCondition cds, String tableName) {
        int index = 1;
        StringBuffer sql = new StringBuffer();
        StringBuffer deviceCondition = new StringBuffer();
        if (-1L == cds.getDeviceId() || -2L == cds.getDeviceId()) {
            if (null != cds.getDeviceIpList()) {
                deviceCondition.append(" device_ip in (");
                for (int i = 0; i < cds.getDeviceIpList().size(); ++i) {
                    String deviceIpStr = IpTransformer.formatIpAddress(cds.getDeviceIpList().get(i));
                    deviceCondition.append('?');
                    this.condition.put(index++, deviceIpStr);
                    if (i == cds.getDeviceIpList().size() - 1) continue;
                    deviceCondition.append(',');
                }
                deviceCondition.append(')');
            }
        } else {
            deviceCondition.append(" device_ip = ? ");
            this.condition.put(index++, cds.getDeviceIp());
        }
        deviceCondition.append(" and device_type = ? ");
        this.condition.put(index++, cds.getDevSerType());
        deviceCondition.append(" and direction = ? ");
        this.condition.put(index++, cds.getDirection());
        sql.append(deviceCondition);
        if (!CommonUtil.isNull(cds.getZoneIp())) {
            sql.append(" and zone_ip= ? ");
            this.condition.put(index++, cds.getZoneIp());
            if ("0".equals(cds.getZoneIp())) {
                sql.append(" and biz_id <> 0 ");
            }
        }
        if (null != cds.getZoneId()) {
            sql.append(" and zone_id = ? ");
            this.condition.put(index++, cds.getZoneId());
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            sql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            this.condition.put(index++, cds.getSessionId());
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, sql);
        for (Object object : list) {
            this.condition.put(index++, object);
        }
        StringBuffer timeCondition = new StringBuffer();
        if (0 == cds.getDevSerType()) {
            if (cds.getAbnormalType() == 2) {
                timeCondition.append(" and ( start_time_attack <> 0 ");
                timeCondition.append(" and start_time_attack <= ? ");
                timeCondition.append(" and end_time >= ? ");
                timeCondition.append(" )");
                this.condition.put(index++, cds.getEndTime());
                this.condition.put(index++, cds.getStartTime());
            } else if (cds.getAbnormalType() == 1) {
                timeCondition.append(" and ( START_TIME_ALERT <> 0 ");
                timeCondition.append(" and START_TIME_ALERT <= ? ");
                timeCondition.append(" and end_time >= ? ");
                timeCondition.append(" )");
                this.condition.put(index++, cds.getEndTime());
                this.condition.put(index++, cds.getStartTime());
            } else {
                timeCondition.append(" and ( start_time_attack <> 0 ");
                timeCondition.append(" and start_time_attack <= ? ");
                timeCondition.append(" and end_time >= ? ");
                timeCondition.append(" )");
                this.condition.put(index++, cds.getEndTime());
                this.condition.put(index++, cds.getStartTime());
            }
        } else {
            timeCondition.append(" and ( START_TIME_ALERT <> 0 ");
            timeCondition.append(" and START_TIME_ALERT <= ? ");
            timeCondition.append(" and end_time >= ? ");
            timeCondition.append(" )");
            this.condition.put(index++, cds.getEndTime());
            this.condition.put(index++, cds.getStartTime());
        }
        sql.append(timeCondition);
        return sql.toString();
    }

    private String getCountCondition(DataStatCondition cds, String tableName) {
        int index = 1;
        int devSerType = cds.getDevSerType();
        StringBuffer comSql = new StringBuffer();
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, comSql);
        for (Object object : temList) {
            this.condition.put(index++, object);
        }
        comSql.append(" and direction= ? ");
        this.condition.put(index++, cds.getDirection());
        comSql.append(" and device_type= ? ");
        this.condition.put(index++, cds.getDevSerType());
        if (devSerType == 0) {
            if (cds.getAbnormalType() == 2) {
                comSql.append(" and ( start_time_attack > 0 and start_time_attack <= ? ");
                this.condition.put(index++, cds.getEndTime());
            } else if (cds.getAbnormalType() == 1) {
                comSql.append(" and (start_time_alert > 0 and start_time_alert <= ? ");
                this.condition.put(index++, cds.getEndTime());
            } else {
                comSql.append(" and ( start_time_attack > 0 and start_time_attack <= ? ");
                this.condition.put(index++, cds.getEndTime());
            }
        } else {
            comSql.append(" and (start_time_alert > 0 and  start_time_alert <= ? ");
            this.condition.put(index++, cds.getEndTime());
        }
        comSql.append(" and end_time >= ? ");
        this.condition.put(index++, cds.getStartTime());
        comSql.append(" )");
        if (devSerType == 0) {
            comSql.append(" AND START_TIME_ALERT < ?  AND START_TIME_ALERT >= ? ");
            this.condition.put(index++, cds.getEndTime());
            this.condition.put(index++, cds.getStartTime() - 1728000L);
        }
        if (null != cds.getZoneId()) {
            comSql.append(" and zone_id= ? ");
            this.condition.put(index++, cds.getZoneId());
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            comSql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            this.condition.put(index++, cds.getSessionId());
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, comSql);
        for (Object object : list) {
            this.condition.put(index++, object);
        }
        if (!CommonUtil.isNull(cds.getZoneIp())) {
            comSql.append(" and zone_ip= ? ");
            this.condition.put(index++, cds.getZoneIp());
            if ("0".equals(cds.getZoneIp())) {
                comSql.append(" and biz_id <> 0");
            }
        }
        return comSql.toString();
    }

    private String getPacketCondition(DataStatCondition cds, String tableName) {
        int index = 1;
        this.condition = new HashMap<Integer, Object>();
        StringBuffer comSql = new StringBuffer();
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, comSql);
        for (Object object : temList) {
            this.condition.put(index++, object);
        }
        comSql.append(" and device_type= ? ");
        this.condition.put(index++, cds.getDevSerType());
        comSql.append(" and direction= ? ");
        this.condition.put(index++, cds.getDirection());
        comSql.append(" and log_time between ? and  ? ");
        this.condition.put(index++, cds.getStartTime());
        this.condition.put(index++, cds.getEndTime());
        if (null != cds.getZoneId()) {
            comSql.append(" and zone_id= ? ");
            this.condition.put(index++, cds.getZoneId());
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            comSql.append(" and ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            this.condition.put(index++, cds.getSessionId());
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, comSql);
        for (Object object : list) {
            this.condition.put(index++, object);
        }
        if (!CommonUtil.isNull(cds.getZoneIp())) {
            comSql.append(" and zone_ip= ? ");
            this.condition.put(index++, cds.getZoneIp());
            if ("0".equals(cds.getZoneIp())) {
                comSql.append(" and biz_id <> 0");
            }
        }
        return comSql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<AttackTypeDistributing>> findAttackTypeDistributing(String sql, boolean isDrop) {
        HashMap<String, List<AttackTypeDistributing>> fsd = new HashMap<String, List<AttackTypeDistributing>>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                if (null == this.condition) {
                    this.condition = new HashMap<Integer, Object>();
                }
                for (Map.Entry<Integer, Object> entry : this.condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackTypeDistributing each = new AttackTypeDistributing();
                    each.setDeviceIp(rs.getString("deviceIp"));
                    each.setAttackType(rs.getLong("attackType"));
                    each.setProtocol(rs.getInt("protocol"));
                    each.setPort(rs.getInt("port"));
                    each.setZoneId(rs.getLong("zoneId"));
                    if (isDrop) {
                        if (sql.contains("result.dropPackets desc")) {
                            each.setCount(rs.getLong("dropPackets"));
                        } else {
                            each.setCount(rs.getLong("dropBytes"));
                        }
                    } else {
                        each.setCount(rs.getLong("counts"));
                    }
                    if (fsd.containsKey(each.getDeviceIp())) {
                        ((List)fsd.get(each.getDeviceIp())).add(each);
                        continue;
                    }
                    ArrayList<AttackTypeDistributing> fdsList = new ArrayList<AttackTypeDistributing>();
                    fdsList.add(each);
                    fsd.put(each.getDeviceIp(), fdsList);
                }
                AttackDistributeUtil.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException e) {
                LOG.error((Object)"findAttackType error");
            }
            finally {
                AttackDistributeUtil.freeDbResource(conn, stmt, rs);
            }
        }
        return fsd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackTypeDistributing> findAttackDurationDistributing(String sql) {
        ArrayList<AttackTypeDistributing> fsd = new ArrayList<AttackTypeDistributing>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                if (null == this.condition) {
                    this.condition = new HashMap<Integer, Object>();
                }
                for (Map.Entry<Integer, Object> entry : this.condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackTypeDistributing each = new AttackTypeDistributing();
                    each.setDeviceIp(rs.getString("deviceIp"));
                    each.setAttackType(rs.getLong("attackType"));
                    each.setProtocol(rs.getInt("protocol"));
                    each.setPort(rs.getInt("port"));
                    each.setZoneId(rs.getLong("zoneId"));
                    each.setDuration(rs.getInt("duration"));
                    long maxDropKbps = rs.getLong("max_drop_kbps");
                    each.setMaxDropKbps(maxDropKbps);
                    each.setStartTimeAttack(rs.getLong("start_time_attack"));
                    each.setStartTimeAlert(rs.getLong("start_time_alert"));
                    fsd.add(each);
                }
                AttackDistributeUtil.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException e) {
                LOG.error((Object)"findAttackType error");
            }
            finally {
                AttackDistributeUtil.freeDbResource(conn, stmt, rs);
            }
        }
        return fsd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttackTypeDistributing> findAttackVectorDistributing(String sql) {
        ArrayList<AttackTypeDistributing> fsd = new ArrayList<AttackTypeDistributing>();
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (conn != null) {
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                stmt = conn.prepareStatement(temSql.toString());
                if (null == this.condition) {
                    this.condition = new HashMap<Integer, Object>();
                }
                for (Map.Entry<Integer, Object> entry : this.condition.entrySet()) {
                    stmt.setObject(entry.getKey(), entry.getValue());
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    AttackTypeDistributing each = new AttackTypeDistributing();
                    each.setDeviceIp(rs.getString("deviceIp"));
                    each.setZoneId(rs.getLong("zoneId"));
                    each.setDuration(rs.getInt("duration"));
                    each.setExactLogId(rs.getString("exact_log_id"));
                    fsd.add(each);
                }
                AttackDistributeUtil.freeDbResource(conn, stmt, rs);
            }
            catch (SQLException e) {
                LOG.error((Object)"findAttackType error");
            }
            finally {
                AttackDistributeUtil.freeDbResource(conn, stmt, rs);
            }
        }
        return fsd;
    }

    public static void freeDbResource(Connection conn, PreparedStatement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ex2) {
            LOG.error((Object)"when close rs error");
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ex3) {
            LOG.error((Object)"when close stmt error");
        }
        try {
            conn.close();
        }
        catch (SQLException ex1) {
            LOG.error((Object)"when close conn error");
        }
    }
}

