/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.biz.report.CommomSqlUtil;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IPUtil;
import java.util.List;
import java.util.Map;

public class AttackTrendUtil {
    private String getTableName(DataStatCondition cds) {
        Long time = cds.getEndTime() - cds.getStartTime();
        StringBuffer tableName = new StringBuffer();
        if (null == cds.getZoneId() && CommonUtil.isNull(cds.getZoneIp())) {
            tableName.append("atic_zone_attack_flow");
        } else if (CommonUtil.isNull(cds.getZoneIp())) {
            tableName.append("atic_zone_attack_flow");
        } else {
            tableName.append("atic_ip_attack_flow");
        }
        if (this.isMoreThanDay(time, 1) && !this.isMoreThanDay(time, 7)) {
            tableName.append("_H");
        } else if (this.isMoreThanDay(time, 7)) {
            tableName.append("_D");
        }
        return tableName.toString();
    }

    private boolean isMoreThanDay(long span, int nums) {
        return span >= (long)nums * CollectorConstants.ONE_DAY;
    }

    public String getAttackTrendUtilNoAttackType(DataStatCondition cds, Map<Integer, Object> condition) {
        StringBuffer sql = new StringBuffer("SELECT DEVICE_IP,DEVICE_TYPE,LOG_TIME, DROP_PPS, DROP_KBPS,IF(attackType<10,0,attackType) attackType ");
        sql.append(" FROM (select DEVICE_IP,DEVICE_TYPE,LOG_TIME,MAX(DROP_PPS) DROP_PPS,MAX(DROP_KBPS) DROP_KBPS,attack_type attackType from ");
        sql.append(this.getTableName(cds)).append(this.getWherecondSqlNoAttackType(cds, this.getTableName(cds), condition));
        sql.append(" group by DEVICE_IP,LOG_TIME,IF(attackType<10,0,attackType)) a ");
        return sql.toString();
    }

    private String getWherecondSqlNoAttackType(DataStatCondition cds, String tableName, Map<Integer, Object> condition) {
        int index = 1;
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        Long minInFlowPeak = cds.getMinInFlow();
        Long minAttackFlwPeak = cds.getMinAttackFlowPeak();
        Integer attackType = cds.getAttackType();
        StringBuffer condSql = new StringBuffer();
        condSql.append(" where LOG_TIME between ? and ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        condSql.append(" and ");
        List<Object> temList = CommonUtil.getDeviceIpSql(cds, condSql);
        for (Object object : temList) {
            condition.put(index++, object);
        }
        condSql.append(" and DEVICE_TYPE =  ? ");
        condition.put(index++, cds.getDevSerType());
        condSql.append(" AND DIRECTION = ?");
        condition.put(index++, cds.getDirection());
        if (null != zoneId) {
            condSql.append(" AND  ZONE_ID= ? ");
            condition.put(index++, zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" AND ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            condition.put(index++, cds.getSessionId());
        }
        if (!CommonUtil.isNull(zoneIp)) {
            condSql.append(" AND ZONE_IP= ? ");
            if (IPUtil.isIpv6(zoneIp)) {
                zoneIp = IPUtil.convert2CompleteIpV6AllZero(IPUtil.convert2CompleteIpV6(zoneIp));
            }
            condition.put(index++, zoneIp);
        }
        if (null != attackType) {
            condSql.append(" AND ATTACK_TYPE= ? ");
            condition.put(index++, attackType);
        }
        if (null != minInFlowPeak && minInFlowPeak > 0L) {
            if (cds.getUnit() == 0) {
                condSql.append(" AND IP_MAX_IN_KBPS > ? ");
            } else {
                condSql.append(" AND IP_MAX_IN_PPS > ? ");
            }
            condition.put(index++, minInFlowPeak);
        }
        if (null != minAttackFlwPeak && minAttackFlwPeak > 0L) {
            if (cds.getUnit() == 0) {
                condSql.append(" AND IP_MAX_DROP_KBPS > ? ");
            } else {
                condSql.append(" AND IP_MAX_DROP_PPS > ? ");
            }
            condition.put(index++, minAttackFlwPeak);
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> list = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, condSql);
        for (Object object : list) {
            condition.put(index++, object);
        }
        return condSql.toString();
    }

    public String getAttackTypeAnalysis(DataStatCondition cds, Map<Integer, Object> condition) {
        StringBuffer sql = new StringBuffer("SELECT DEVICE_IP,DEVICE_TYPE,LOG_TIME, MAX(DROP_PPS) DROP_PPS, MAX(DROP_KBPS) DROP_KBPS FROM ");
        sql.append(this.getTableName(cds)).append(this.getWherecondSqlNoAttackType(cds, this.getTableName(cds), condition));
        sql.append(" GROUP BY LOG_TIME ");
        sql.append(" ORDER BY LOG_TIME DESC ");
        return sql.toString();
    }
}

