/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.biz.report.CommomSqlUtil;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DnsDefendUtil {
    protected static final Logger LOG = LogManager.getInstance().getReportLogger();

    public String getDnsDefendLogSql(DataStatCondition cds, String sortField, String sortType, Map<Integer, Object> condition) {
        int index = 1;
        Long deviceId = cds.getDeviceId();
        int deviceType = cds.getDevSerType();
        String domain = cds.getDomain();
        String sourceIp = cds.getSouceIp();
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        int startRow = cds.getStartRow();
        int limit = cds.getLimit();
        String tableName = "atic_dns_defend";
        StringBuffer sql = new StringBuffer();
        sql.append("select LOG_TIME,DEVICE_IP,DNS_NAME,REQUEST_TIME,SRC_IP from " + tableName);
        sql.append(" where LOG_TIME >= ? and LOG_TIME <= ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        if (0L < deviceId) {
            String deviceIp = cds.getDeviceIp();
            sql.append(" and DEVICE_IP = ? ");
            condition.put(index++, deviceIp);
        }
        if (cds.getDevSerType() != null) {
            sql.append(" and DEVICE_TYPE = ? ");
            condition.put(index++, deviceType);
        }
        if (!CommonUtil.isNull(sourceIp) && !"0".equals(sourceIp)) {
            String sourceIpStr = "%," + sourceIp + ",%";
            sql.append(" and CONCAT(',',SRC_IP,',') like ? ");
            condition.put(index++, sourceIpStr);
        }
        if (!CommonUtil.isNull(domain)) {
            domain = '%' + domain + '%';
            sql.append(" and DNS_NAME like ? ");
            condition.put(index++, domain);
        }
        if (null != sortField && !"".equals(sortField) && null != sortType && !"".equals(sortType)) {
            String dataBaseColumn = CollectorConstants.getAttackLog().get(sortField);
            if (this.checkParams(dataBaseColumn)) {
                sql.append(" order by ").append(dataBaseColumn).append("DESC".equalsIgnoreCase(sortType) ? " desc" : "");
            } else {
                sql.append(" order by LOG_TIME DESC ");
            }
        } else {
            sql.append(" order by LOG_TIME DESC ");
        }
        sql.append(" LIMIT ? , ? ");
        condition.put(index++, startRow);
        condition.put(index++, limit);
        return sql.toString();
    }

    private boolean checkParams(String name) {
        String regular;
        return null != name && !"".equals(name) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name);
    }

    public String getDnsDefendLogNumSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        Long deviceId = cds.getDeviceId();
        int deviceType = cds.getDevSerType();
        String domain = cds.getDomain();
        String sourceIp = cds.getSouceIp();
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        String tableName = "atic_dns_defend";
        StringBuffer sql = new StringBuffer();
        sql.append("select count(0) count from " + tableName);
        sql.append(" where LOG_TIME >= ? and LOG_TIME <= ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        if (0L < deviceId) {
            String deviceIp = cds.getDeviceIp();
            sql.append(" and DEVICE_IP = ? ");
            condition.put(index++, deviceIp);
        }
        if (cds.getDevSerType() != null) {
            sql.append(" and DEVICE_TYPE = ? ");
            condition.put(index++, deviceType);
        }
        if (!CommonUtil.isNull(sourceIp) && !"0".equals(sourceIp)) {
            String sourceIpStr = '%' + sourceIp + '%';
            sql.append(" and SRC_IP like ? ");
            condition.put(index++, sourceIpStr);
        }
        if (!CommonUtil.isNull(domain)) {
            domain = '%' + domain + '%';
            sql.append(" and DNS_NAME like ? ");
            condition.put(index++, domain);
        }
        return sql.toString();
    }

    public String getDnsDefendTopNSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        String deviceIp = cds.getDeviceIp();
        Long deviceId = cds.getDeviceId();
        int deviceType = cds.getDevSerType();
        int topn = cds.getTopn();
        Long start = cds.getStartTime();
        Long end = cds.getEndTime();
        String tableName = "atic_dns_defend";
        Long time = cds.getEndTime() - cds.getStartTime();
        if (this.isMoreThanDay(time, 1) && !this.isMoreThanDay(time, 7)) {
            tableName = tableName + "_H";
        } else if (this.isMoreThanDay(time, 7)) {
            tableName = tableName + "_D";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select LOG_TIME,DNS_NAME,SUM(REQUEST_TIME) REQUEST_TIME from " + tableName);
        sql.append(" a WHERE EXISTS (SELECT DNS_NAME FROM (SELECT DNS_NAME, SUM(REQUEST_TIME) allTime FROM atic_dns_defend ");
        sql.append(" where LOG_TIME >= ?  and LOG_TIME <= ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        sql.append(" and DEVICE_IP = ? ");
        condition.put(index++, deviceIp);
        if (cds.getDevSerType() != null) {
            sql.append(" and DEVICE_TYPE = ? ");
            condition.put(index++, deviceType);
        }
        sql.append(" GROUP BY DNS_NAME ORDER BY allTime DESC,DNS_NAME");
        if (0L < deviceId) {
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topn);
        } else {
            int topN = CommomSqlUtil.getTopNNum(topn);
            sql.append(" LIMIT 0, ? ");
            condition.put(index++, topN);
        }
        sql.append(") b WHERE a.DNS_NAME = b.DNS_NAME)");
        sql.append(" and LOG_TIME >= ?  and LOG_TIME <= ? ");
        condition.put(index++, start);
        condition.put(index++, end);
        sql.append(" and DEVICE_IP = ? ");
        condition.put(index++, deviceIp);
        if (cds.getDevSerType() != null) {
            sql.append(" and DEVICE_TYPE = ? ");
            condition.put(index++, deviceType);
        }
        sql.append(" GROUP BY LOG_TIME,DNS_NAME ");
        return sql.toString();
    }

    private boolean isMoreThanDay(long span, int nums) {
        return span >= (long)nums * CollectorConstants.ONE_DAY;
    }
}

