/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.biz.report.CommomSqlUtil;
import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RequestTrendUtil {
    private static final String TCP_TABLENAME = "TCPTableName";
    private static final String UDP_TABLENAME = "UDPTableName";
    private static final List<String> DNS_TYPENAME = new ArrayList<String>();

    private String getTablePreName(Long zoneId, String zoneIp, boolean userDefType) {
        if (null == zoneId && null == zoneIp) {
            if (userDefType) {
                return "atic_zone_userdef_dns_type";
            }
            return "ATIC_ZONE_BIZ_";
        }
        if (CommonUtil.isNull(zoneIp)) {
            if (userDefType) {
                return "atic_zone_userdef_dns_type";
            }
            return "ATIC_ZONE_BIZ_";
        }
        if (userDefType) {
            return "atic_ip_userdef_dns_type";
        }
        return "ATIC_IP_BIZ_";
    }

    private String getTableName(DataStatCondition cds, String requestType) {
        Long time = cds.getEndTime() - cds.getStartTime();
        StringBuffer tableName = new StringBuffer(this.getTablePreName(cds.getZoneId(), cds.getZoneIp(), false));
        if (requestType.equalsIgnoreCase("TCP")) {
            tableName.append("TCP_DNS");
        } else if (requestType.equalsIgnoreCase("UDP")) {
            tableName.append("UDP_DNS");
        } else if (UDP_TABLENAME.contains(requestType)) {
            tableName.append("UDP_DNS");
        } else {
            tableName = new StringBuffer(this.getTablePreName(cds.getZoneId(), cds.getZoneIp(), true));
        }
        if (this.isMoreThanDay(time, 1) && !this.isMoreThanDay(time, 7)) {
            tableName.append("_H");
        } else if (this.isMoreThanDay(time, 7)) {
            tableName.append("_D");
        }
        return tableName.toString();
    }

    private List<Object> getWherecondSql(DataStatCondition cds, String tableName, StringBuffer condSql) {
        ArrayList<Object> list = new ArrayList<Object>();
        long start = cds.getStartTime();
        long end = cds.getEndTime();
        Long zoneId = cds.getZoneId();
        String zoneIp = cds.getZoneIp();
        condSql.append(" where ").append(tableName).append(".LOG_TIME between ? and ? ");
        list.add(start);
        list.add(end);
        condSql.append(" and DEVICE_IP = ? ");
        list.add(cds.getDeviceIp());
        condSql.append(" and DEVICE_TYPE = ? ");
        list.add(cds.getDevSerType());
        if (null != zoneId) {
            condSql.append(" AND ").append(tableName).append(".ZONE_ID= ? ");
            list.add(zoneId);
        } else if (null != cds.getSessionId() && !cds.getZoneIdList().isEmpty()) {
            condSql.append(" AND ").append(tableName).append(".ZONE_ID in (SELECT ZONE_ID FROM atic_zone_security WHERE SESSION_ID = ? )");
            list.add(cds.getSessionId());
        }
        if (!CommonUtil.isNull(zoneIp)) {
            condSql.append(" AND ").append(tableName).append(".ZONE_IP= ? ");
            list.add(zoneIp);
        }
        CommomSqlUtil commomSqlUtil = new CommomSqlUtil();
        List<Object> tempList = commomSqlUtil.processServiceSqlWithNoType(cds, tableName, condSql);
        list.addAll(tempList);
        return list;
    }

    private boolean isMoreThanDay(long span, int nums) {
        return span >= (long)nums * CollectorConstants.ONE_DAY;
    }

    public String getRequestTrendEachType(DataStatCondition cds, String requestType, Map<Integer, Object> condition) {
        List<Object> list;
        int index = 1;
        StringBuffer selectSql = new StringBuffer("SELECT ");
        StringBuffer fromSql = new StringBuffer(" FROM ");
        String groupBySql = "";
        String tcpTableName = this.getTableName(cds, "TCP");
        String udpTableName = this.getTableName(cds, "UDP");
        if (requestType.equalsIgnoreCase("Total")) {
            StringBuffer selectTCP = new StringBuffer("SELECT ");
            StringBuffer fromTCP = new StringBuffer(" FROM ");
            String groupByTCP = "";
            selectTCP.append(TCP_TABLENAME).append(".LOG_TIME LOG_TIME, ");
            selectTCP.append("SUM(").append(TCP_TABLENAME).append(".TOTAL_PPS) total ");
            fromTCP.append(tcpTableName).append(' ').append(TCP_TABLENAME).append(' ');
            groupByTCP = this.getGroupByStr(TCP_TABLENAME);
            StringBuffer tcpSql = new StringBuffer();
            tcpSql = tcpSql.append(selectTCP).append(fromTCP);
            List<Object> tcpList = this.getWherecondSql(cds, TCP_TABLENAME, tcpSql);
            for (Object object : tcpList) {
                condition.put(index++, object);
            }
            tcpSql = tcpSql.append(groupByTCP);
            StringBuffer selectUDP = new StringBuffer("SELECT ");
            StringBuffer fromUDP = new StringBuffer(" FROM ");
            String groupByUDP = "";
            selectUDP.append(UDP_TABLENAME).append(".LOG_TIME LOG_TIME, ");
            selectUDP.append("SUM(").append(UDP_TABLENAME).append(".REQUEST_PPS) total ");
            fromUDP.append(udpTableName).append(' ').append(UDP_TABLENAME).append(' ');
            groupByUDP = this.getGroupByStr(UDP_TABLENAME);
            StringBuffer uDPsql = new StringBuffer();
            uDPsql = uDPsql.append(selectUDP).append(fromUDP);
            List<Object> udpList = this.getWherecondSql(cds, UDP_TABLENAME, uDPsql);
            for (Object object : udpList) {
                condition.put(index++, object);
            }
            uDPsql = uDPsql.append(groupByUDP);
            StringBuffer totalSql = new StringBuffer("SELECT t.LOG_TIME, SUM(t.total) Total FROM  (");
            totalSql.append(tcpSql).append(" UNION ALL ").append(uDPsql).append(") t GROUP BY t.LOG_TIME");
            return totalSql.toString();
        }
        if (requestType.equalsIgnoreCase("TCP")) {
            selectSql.append(TCP_TABLENAME).append(".LOG_TIME LOG_TIME, ");
            selectSql.append("SUM(").append(TCP_TABLENAME).append(".TOTAL_PPS) TCP ");
            fromSql.append(tcpTableName).append(' ').append(TCP_TABLENAME).append(' ');
            list = this.getWherecondSql(cds, TCP_TABLENAME, fromSql);
            for (Object object : list) {
                condition.put(index++, object);
            }
            groupBySql = this.getGroupByStr(TCP_TABLENAME);
        } else if (requestType.equalsIgnoreCase("UDP")) {
            selectSql.append(UDP_TABLENAME).append(".LOG_TIME LOG_TIME, ");
            selectSql.append("SUM(").append(UDP_TABLENAME).append(".REQUEST_PPS) UDP ");
            fromSql.append(udpTableName).append(' ').append(UDP_TABLENAME).append(' ');
            list = this.getWherecondSql(cds, UDP_TABLENAME, fromSql);
            for (Object object : list) {
                condition.put(index++, object);
            }
            groupBySql = this.getGroupByStr(UDP_TABLENAME);
        } else if (DNS_TYPENAME.contains(requestType)) {
            selectSql.append(UDP_TABLENAME).append(".LOG_TIME LOG_TIME, ");
            selectSql.append("SUM(").append(UDP_TABLENAME).append('.').append(requestType).append(") ").append(requestType).append(' ');
            fromSql.append(udpTableName).append(' ').append(UDP_TABLENAME).append(' ');
            list = this.getWherecondSql(cds, UDP_TABLENAME, fromSql);
            for (Object object : list) {
                condition.put(index++, object);
            }
            groupBySql = this.getGroupByStr(UDP_TABLENAME);
        } else {
            String userDefTableName = this.getTableName(cds, requestType);
            selectSql.append(UDP_TABLENAME).append(".LOG_TIME LOG_TIME, ");
            selectSql.append("SUM(").append(UDP_TABLENAME).append(".CODE_VALUE) '").append(requestType).append("' ");
            fromSql.append(userDefTableName).append(' ').append(UDP_TABLENAME).append(' ');
            List<Object> list2 = this.getWherecondSql(cds, UDP_TABLENAME, fromSql);
            for (Object object : list2) {
                condition.put(index++, object);
            }
            fromSql.append(" AND ").append(UDP_TABLENAME).append(".TYPE_CODE = ? ");
            condition.put(index++, requestType);
            groupBySql = this.getGroupByStr(UDP_TABLENAME);
            groupBySql = groupBySql + ",TYPE_CODE";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(selectSql).append(fromSql).append(groupBySql);
        return sql.toString();
    }

    private String getGroupByStr(String tableName) {
        StringBuffer groupBySql = new StringBuffer("  GROUP BY " + tableName + ".LOG_TIME");
        return groupBySql.toString();
    }

    static {
        DNS_TYPENAME.add("A_REQUEST_PPS");
        DNS_TYPENAME.add("PTR_REQUEST_PPS");
        DNS_TYPENAME.add("NS_REQUEST_PPS");
        DNS_TYPENAME.add("MX_REQUEST_PPS");
        DNS_TYPENAME.add("TXT_REQUEST_PPS");
        DNS_TYPENAME.add("CNNAME_REQUEST_PPS");
        DNS_TYPENAME.add("SOA_REQUEST_PPS");
        DNS_TYPENAME.add("AAAAA_REQUEST_PPS");
        DNS_TYPENAME.add("OTHER_REQUEST_PPS");
    }
}

