/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.report;

import com.hs.atic.collector.entity.log.DataStatCondition;
import com.hs.atic.collector.util.CollectorConstants;
import com.hs.atic.collector.util.LogManager;
import java.util.Map;
import org.apache.log4j.Logger;

public class SlotFlowUtil {
    protected static final Logger LOG = LogManager.getInstance().getReportLogger();

    private String getTableType(Long startTime, Long endTime) {
        String tablePostfix = "";
        long span = endTime - startTime;
        if (span < CollectorConstants.ONE_DAY && span >= 0L) {
            tablePostfix = "";
        } else if (span < CollectorConstants.ONE_WEEK && span >= CollectorConstants.ONE_DAY) {
            tablePostfix = "_H";
        } else if (span < CollectorConstants.ONE_YEAR && span >= CollectorConstants.ONE_WEEK) {
            tablePostfix = "_D";
        }
        return tablePostfix;
    }

    public String getCleanSlotSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        String column = this.getQueryColumn(cds.getProtocol(), cds.getUnit());
        StringBuffer inTableName = new StringBuffer("ATIC_SLOT_FLOW_SUM");
        StringBuffer dropTableName = new StringBuffer("ATIC_SLOT_FLOW_SUM_DROP");
        String postfixName = this.getTableType(cds.getStartTime(), cds.getEndTime());
        inTableName.append(postfixName);
        dropTableName.append(postfixName);
        StringBuffer onCondition = new StringBuffer();
        onCondition.append("on IN_T.LOG_TIME = DROP_T.LOG_TIME and IN_T.DEVICE_IP = DROP_T.DEVICE_IP and IN_T.DEVICE_TYPE = DROP_T.DEVICE_TYPE and IN_T.SLOT_ID = DROP_T.SLOT_ID");
        StringBuffer querySql = new StringBuffer();
        querySql.append("select IN_T.LOG_TIME as LOG_TIME, IN_T.SLOT_ID as SLOT_ID, ");
        querySql.append("IN_T.");
        querySql.append(column);
        querySql.append(" as IN_FLOW, DROP_T.");
        querySql.append(column);
        querySql.append(" as DROP_FLOW ");
        querySql.append("from ");
        querySql.append(inTableName);
        querySql.append(" IN_T left outer join ");
        querySql.append(dropTableName);
        querySql.append(" DROP_T ");
        querySql.append(onCondition);
        querySql.append(" where IN_T.DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        querySql.append(" and IN_T.DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        querySql.append(" and IN_T.DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        querySql.append(" and IN_T.LOG_TIME between ? and ? ");
        condition.put(index++, cds.getStartTime());
        condition.put(index++, cds.getEndTime());
        querySql.append(" group by LOG_TIME, SLOT_ID order by LOG_TIME, SLOT_ID");
        return querySql.toString();
    }

    public String getDetectSlotSql(DataStatCondition cds, Map<Integer, Object> condition) {
        int index = 1;
        String column = this.getQueryColumn(cds.getProtocol(), cds.getUnit());
        StringBuffer tableName = new StringBuffer("ATIC_SLOT_FLOW_SUM");
        tableName.append(this.getTableType(cds.getStartTime(), cds.getEndTime()));
        StringBuffer querySql = new StringBuffer();
        querySql.append("select LOG_TIME, SLOT_ID, ");
        querySql.append(column);
        querySql.append(" as IN_FLOW from ");
        querySql.append(tableName);
        querySql.append(" where DEVICE_IP = ? ");
        condition.put(index++, cds.getDeviceIp());
        querySql.append(" and DIRECTION = ? ");
        condition.put(index++, cds.getDirection());
        querySql.append(" and DEVICE_TYPE = ? ");
        condition.put(index++, cds.getDevSerType());
        querySql.append(" and LOG_TIME between ? and ? ");
        condition.put(index++, cds.getStartTime());
        condition.put(index++, cds.getEndTime());
        querySql.append(" group by LOG_TIME, SLOT_ID order by LOG_TIME, SLOT_ID");
        return querySql.toString();
    }

    private String getQueryColumn(Integer protocol, Integer unit) {
        StringBuffer column = new StringBuffer();
        if (1 == protocol) {
            column.append("TCP");
        } else if (2 == protocol) {
            column.append("UDP");
        } else if (3 == protocol) {
            column.append("ICMP");
        } else if (4 == protocol) {
            column.append("OTHER");
        } else {
            column.append("TOTAL");
        }
        if (1 == unit) {
            column.append("_PPS");
        } else {
            column.append("_KBPS");
        }
        return column.toString();
    }
}

