/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.biz.zonepacket;

import com.hs.atic.collector.db.zonepacket.DBZonePacketInfo;
import com.hs.atic.collector.entity.log.RmiTuple;
import com.hs.atic.collector.entity.pcap.PcapFileQueryObj;
import com.hs.atic.collector.entity.pcap.PcapObj;
import com.hs.atic.collector.entity.pcap.ZonePacket;
import com.hs.atic.collector.entity.zonepacket.ZonePacketInfoObj;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ZonePacketInfoBiz {
    protected static final Logger LOGGER = LogManager.getInstance().getReportLogger();
    private static final long serialVersionUID = 1L;
    DBZonePacketInfo dbZonePacketInfo = new DBZonePacketInfo();

    public List<ZonePacketInfoObj> findZonePacketList(PcapFileQueryObj pcapFileQueryObj) {
        return this.dbZonePacketInfo.findZonePacketList(pcapFileQueryObj);
    }

    public int findZonePacketSize(PcapFileQueryObj pcapFileQueryObj) {
        return this.dbZonePacketInfo.findZonePacketSize(pcapFileQueryObj);
    }

    public List<PcapObj> findZonePacketPcapList(long pcapId) {
        ArrayList<PcapObj> list = new ArrayList<PcapObj>();
        PcapObj obj = this.dbZonePacketInfo.findZonePacketPcapList(pcapId);
        list.add(obj);
        return list;
    }

    public RmiTuple<List<ZonePacketInfoObj>, Long> findAttackZonePacketList(ZonePacket zonePacket) {
        PcapFileQueryObj pcapFileQueryObj = new PcapFileQueryObj();
        pcapFileQueryObj.setQueryDeviceIp(zonePacket.getDeviceIp());
        pcapFileQueryObj.setDeviceType(zonePacket.getDeviceType());
        pcapFileQueryObj.setBeginTime(zonePacket.getBegintime());
        pcapFileQueryObj.setEndTime(zonePacket.getEndtime());
        pcapFileQueryObj.setZoneId(zonePacket.getZoneId().intValue());
        pcapFileQueryObj.setAttackType(zonePacket.getAttackType());
        pcapFileQueryObj.setZoneIp(zonePacket.getZoneIp());
        pcapFileQueryObj.setPort(zonePacket.getPort());
        pcapFileQueryObj.setProtocol(zonePacket.getProtocol());
        pcapFileQueryObj.setStartPage(zonePacket.getStart());
        pcapFileQueryObj.setPageSize(zonePacket.getLimit());
        return this.dbZonePacketInfo.findZonePacketPage(pcapFileQueryObj);
    }

    public RmiTuple<List<ZonePacketInfoObj>, Long> findAllZonePacketList(int pageIndex, int pageSize, String fileName) {
        PcapFileQueryObj pcapFileQueryObj = new PcapFileQueryObj();
        pcapFileQueryObj.setStartPage(pageIndex);
        pcapFileQueryObj.setPageSize(pageSize);
        pcapFileQueryObj.setFileName(fileName);
        return this.dbZonePacketInfo.findZonePacketPage(pcapFileQueryObj);
    }

    public ZonePacketInfoObj findZonePacketByFileName(String fileName) {
        return this.dbZonePacketInfo.findZonePacketByFileName(fileName);
    }
}

