/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import com.hs.atic.collector.util.LogManager;
import com.hs.lego.core.sdk.base.dataprotect.util.AticDataProtector;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.log4j.Logger;

public final class DBConnPool {
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final String DB_CONFIGFILE = "conf/db.conf";
    private static BasicDataSource uniqueDS = (BasicDataSource)DBConnPool.setupDataSource();
    private static int maxActive = 8;
    private static int maxIdle = 8;
    private static int maxOpenPreparedStatements = -1;
    private static long maxWait = -1L;
    private static long timeBetweenEvictionRunsMillis = -1L;

    private DBConnPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection() {
        Class<DBConnPool> clazz = DBConnPool.class;
        synchronized (DBConnPool.class) {
            try {
                // ** MonitorExit[var0] (shouldn't be in output)
                return uniqueDS != null ? uniqueDS.getConnection() : DBConnPool.setupDataSource().getConnection();
            }
            catch (Exception ex) {
                LOGGER.error((Object)"getConnection fail", (Throwable)ex);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownDataSource() {
        Class<DBConnPool> clazz = DBConnPool.class;
        synchronized (DBConnPool.class) {
            try {
                DBConnPool.shutdownDataSource((DataSource)uniqueDS);
            }
            catch (SQLException ex) {
                LOGGER.error((Object)"shutdownDataSource SQLException", (Throwable)ex);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataSource setupDataSource() {
        Class<DBConnPool> clazz = DBConnPool.class;
        synchronized (DBConnPool.class) {
            if (uniqueDS == null) {
                InputStream fis = null;
                try {
                    Properties dbConfig = new Properties();
                    fis = new FileInputStream(DB_CONFIGFILE);
                    dbConfig.load(fis);
                    String dbDriver = dbConfig.getProperty("DB_Driver");
                    String url = dbConfig.getProperty("DB_URL");
                    url = url + "&serverTimezone=" + DBConnPool.curTimeZone();
                    LOGGER.info((Object)("collector database url : " + url));
                    String userName = dbConfig.getProperty("DB_UserName");
                    StringBuffer password = AticDataProtector.sdpDecrypt(0L, dbConfig.getProperty("DB_PassWord"));
                    String strMaxActive = dbConfig.getProperty("DB_MaxAcitve");
                    String strMaxIdle = dbConfig.getProperty("DB_MaxIdle");
                    String strMaxOpenPreparedStatements = dbConfig.getProperty("DB_MOPS");
                    String strMaxWait = dbConfig.getProperty("DB_MaxWait");
                    String strTimeBetweenEvictionRunsMillis = dbConfig.getProperty("DB_MaxIdleTime");
                    try {
                        maxActive = Integer.parseInt(strMaxActive);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error((Object)DBConnPool.getcleanedMessage(e.getMessage()));
                    }
                    try {
                        maxIdle = Integer.parseInt(strMaxIdle);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error((Object)"str_maxIdle Integer.parseInt NumberFormatException");
                    }
                    try {
                        maxOpenPreparedStatements = Integer.parseInt(strMaxOpenPreparedStatements);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error((Object)"str_maxOpenPreparedStatements Integer.parseInt NumberFormatException");
                    }
                    try {
                        maxWait = Long.parseLong(strMaxWait);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error((Object)"str_maxWait Long.parseLong NumberFormatException");
                    }
                    try {
                        timeBetweenEvictionRunsMillis = Long.parseLong(strTimeBetweenEvictionRunsMillis);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error((Object)"strTimeBetweenEvictionRunsMillis Long.parseLong NumberFormatException");
                    }
                    uniqueDS = new BasicDataSource();
                    uniqueDS.setDriverClassName(dbDriver);
                    uniqueDS.setUsername(userName);
                    uniqueDS.setPassword(password.toString());
                    uniqueDS.setUrl(url);
                    uniqueDS.setMaxTotal(maxActive);
                    uniqueDS.setMaxIdle(maxIdle);
                    uniqueDS.setMaxOpenPreparedStatements(maxOpenPreparedStatements);
                    uniqueDS.setMaxWaitMillis(maxWait);
                    uniqueDS.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
                }
                catch (FileNotFoundException ex) {
                    uniqueDS = null;
                    LOGGER.error((Object)"FileNotFoundException");
                }
                catch (IOException e) {
                    uniqueDS = null;
                    LOGGER.error((Object)"Exception", (Throwable)e);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)"fis.close() Exception", (Throwable)e);
                        }
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return uniqueDS;
        }
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private static void shutdownDataSource(DataSource ds) throws SQLException {
        ((BasicDataSource)ds).close();
    }

    public static String curTimeZone() {
        TimeZone timeZone = TimeZone.getDefault();
        LOGGER.info((Object)("curTimeZone : " + timeZone.getID()));
        LOGGER.info((Object)timeZone.getDisplayName());
        try {
            return URLEncoder.encode(timeZone.getID(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "UTC";
        }
    }
}

