/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DbFileTask {
    private String tableName = "";
    private Set<String> filePaths = new HashSet<String>();

    public void addFile(String filePath) {
        this.filePaths.add(filePath);
    }

    public String getTableName() {
        return this.tableName;
    }

    public Set<String> getFilePaths() {
        return this.filePaths;
    }

    public List<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (String path : this.filePaths) {
            File file = new File(path);
            if (!file.exists()) continue;
            files.add(file);
        }
        Collections.sort(files, new ComparatorImpl());
        return files;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setFiles(Set<String> files) {
        this.filePaths = files;
    }

    public void merge(DbFileTask task) {
        this.filePaths.addAll(task.getFilePaths());
    }

    public boolean equals(Object o) {
        if (o instanceof DbFileTask) {
            return ((DbFileTask)o).getTableName().equals(this.tableName);
        }
        return false;
    }

    public int hashCode() {
        return this.tableName.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("tableName", (Object)this.tableName).append("files", this.filePaths).toString();
    }

    private static class ComparatorImpl<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 9193759313799587473L;

        private ComparatorImpl() {
        }

        @Override
        public int compare(T t1, T t2) {
            File o1 = null;
            File o2 = null;
            if (!(t1 instanceof File) || !(t2 instanceof File)) {
                return -2;
            }
            o1 = (File)t1;
            o2 = (File)t2;
            long thisVal = o1.lastModified();
            long anotherVal = o2.lastModified();
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }
}

