/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.util.LogManager;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DbImportTask
implements Runnable {
    public static final String SEPARATOR = ";";
    private static final Logger LOGGER = LogManager.getInstance().getSysLogLogger();
    private File file = new File("");
    private String tableName;
    private Connection con;
    private Set<String> files = new HashSet<String>();

    public DbImportTask(String tableName) {
        this.tableName = tableName;
        this.con = DBConnPool.getConnection();
    }

    public synchronized void addFiles(Set<String> paths) {
        this.files.addAll(paths);
        this.notifyAll();
    }

    private synchronized boolean hasFiles() {
        return this.files.isEmpty();
    }

    public String mySqlFormat(String absolutePath) {
        String directory = "'" + absolutePath.replace("\\", "\\\\") + "'";
        return directory;
    }

    @Override
    public void run() {
        while (true) {
            if (!this.hasFiles()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)"wait() InterruptedException", (Throwable)e);
                }
                continue;
            }
            if (!this.hasFiles()) continue;
            this.import2Db();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void import2Db() {
        long time = System.currentTimeMillis();
        String filePath = null;
        try {
            filePath = this.file.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error((Object)"getCanonicalPath() throws IOException", (Throwable)e);
        }
        if (null == filePath || "".equals(filePath)) {
            LOGGER.error((Object)"filePath is wrong");
            return;
        }
        String sql = "load data concurrent local infile " + this.mySqlFormat(filePath) + "  into table  " + this.tableName + " FIELDS  TERMINATED BY '" + SEPARATOR + "';";
        LOGGER.info((Object)("sql is : " + sql));
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(sql);
            stmt.execute();
            LOGGER.info((Object)(" write  db seccess " + this.tableName));
        }
        catch (Exception e) {
            LOGGER.error((Object)"when import file 2 db,error happend", (Throwable)e);
        }
        finally {
            boolean delete;
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"stmt.close() SQLException");
                }
            }
            if (null != this.con) {
                try {
                    this.con.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"con.close() SQLException");
                }
            }
            if (delete = this.file.delete()) {
                LOGGER.info((Object)("delete temp file ok ,file name is : " + this.file.getName()));
            } else {
                LOGGER.warn((Object)("delete temp file fail ,file name is : " + this.file.getName()));
            }
            LOGGER.warn((Object)("load file " + this.file.getName() + " takes " + (System.currentTimeMillis() - time) / 1000L + "s"));
        }
    }
}

