/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import com.hs.atic.collector.db.DbFileLoaderFactory;
import com.hs.atic.collector.db.DbFileTask;
import com.hs.atic.collector.db.DefaultDbFileLoaderFactory;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class DbImportTool
implements Runnable {
    private static final Logger LOGGER = LogManager.getInstance().getSysLogLogger();
    private static DbImportTool instance = new DbImportTool();
    private DbFileLoaderFactory factory = DefaultDbFileLoaderFactory.getInstance();

    private DbImportTool() {
    }

    public static DbImportTool getInstance() {
        return instance;
    }

    private Collection<DbFileTask> createTask(File[] files) {
        HashMap<String, DbFileTask> tasks = new HashMap<String, DbFileTask>();
        try {
            for (File file : files) {
                String tableName = this.getTableNameByFileName(file.getName());
                if (tasks.containsKey(tableName)) {
                    ((DbFileTask)tasks.get(tableName)).addFile(file.getCanonicalPath());
                    continue;
                }
                DbFileTask task = new DbFileTask();
                task.setTableName(tableName);
                task.addFile(file.getCanonicalPath());
                tasks.put(tableName, task);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"getCanonicalPath() throws IOException", (Throwable)e);
        }
        return tasks.values();
    }

    private String getTableNameByFileName(String fileName) {
        int beginIndex = fileName.indexOf(45);
        return fileName.substring(0, beginIndex);
    }

    @Override
    public void run() {
        while (true) {
            File[] files = this.scanFile();
            Collection<DbFileTask> tasks = this.createTask(files);
            for (DbFileTask task : tasks) {
                this.factory.getLoader(task.getTableName()).loadFile2Db(task);
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"unKnow", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private File[] scanFile() {
        File directory = new File(EventUtil.EVENT_FILE_DIRECTORY);
        File[] files = directory.listFiles(new FilenameFilterImpl());
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    private static class FilenameFilterImpl
    implements FilenameFilter {
        private FilenameFilterImpl() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".txt");
        }
    }
}

