/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.protal.ProtalConstants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import org.apache.log4j.Logger;

public final class DbWriteTool {
    private static DbWriteTool instance = new DbWriteTool();
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final int MAX_RANDOM = Integer.MAX_VALUE;
    private SecureRandom random = new SecureRandom();

    private DbWriteTool() {
    }

    public static DbWriteTool getInstance() {
        return instance;
    }

    public void writeToDb(String tableName, String[] lines) {
        String absolutePath = null;
        try {
            absolutePath = EventUtil.EVENT_FILE_DIRECTORY + File.separator + tableName + '-' + this.random.nextInt(Integer.MAX_VALUE);
            this.write2TempFile(absolutePath, lines);
        }
        catch (Exception e) {
            LOGGER.error((Object)("when write to file ,error happend . tableName is : " + tableName), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write2TempFile(String absolutePath, String[] values) {
        File file = new File(absolutePath + ".part");
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            for (int i = 0; i < values.length; ++i) {
                stream.write(values[i].getBytes("utf-8"));
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"stream.write");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"stream.write", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"stream.write", (Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"stream.close() IOException", (Throwable)e);
            }
        }
        if (!file.renameTo(new File(absolutePath + ".txt"))) {
            LOGGER.error((Object)"file rename in error");
        }
    }

    public void writeProtalEventToFile(String tableName, String[] lines) {
        String absolutePath = null;
        try {
            absolutePath = ProtalConstants.PROTAL_EVENT_FILE_DIRECTORY + File.separator + "temp_" + tableName + '-' + System.currentTimeMillis();
            this.write2TempFile(absolutePath, lines);
        }
        catch (Exception e) {
            LOGGER.error((Object)("error to write protalEvent to file.  file name is : " + absolutePath), (Throwable)e);
        }
    }
}

