/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultZoneMappingRepository {
    private static final Logger LOGGER = LogManager.getInstance().getRMILog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMap2Db(Map<String, Long> map) {
        block10: {
            String delSql = "delete from  ATIC_DEFAULT_ZONE_RELATION ";
            Connection conn = DBConnPool.getConnection();
            PreparedStatement stmt = null;
            if (conn == null) break block10;
            try {
                conn.setAutoCommit(false);
                stmt = conn.prepareStatement(delSql);
                stmt.execute();
            }
            catch (Exception e) {
                try {
                    LOGGER.error((Object)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.free(null, stmt);
                    throw throwable;
                }
                CommonUtil.free(null, stmt);
            }
            CommonUtil.free(null, stmt);
            try {
                stmt = conn.prepareStatement("insert into ATIC_DEFAULT_ZONE_RELATION values( ? , ? )");
                for (Map.Entry<String, Long> entry : map.entrySet()) {
                    String devIp = entry.getKey();
                    long zoneId = entry.getValue();
                    stmt.setString(1, devIp);
                    stmt.setLong(2, zoneId);
                    stmt.addBatch();
                }
                stmt.executeBatch();
                conn.commit();
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            finally {
                CommonUtil.free(conn, stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> initCache() {
        String sql = "select t.DEVICE_IP,t.ZONE_ID from ATIC_DEFAULT_ZONE_RELATION t";
        Connection conn = DBConnPool.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashMap<String, Long> devZoneCache = new HashMap<String, Long>();
        if (conn != null) {
            try {
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    devZoneCache.put(rs.getString(1), rs.getLong(2));
                }
            }
            catch (Exception e) {
                try {
                    LOGGER.error((Object)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.free(conn, stmt, rs);
                    throw throwable;
                }
                CommonUtil.free(conn, stmt, rs);
            }
            CommonUtil.free(conn, stmt, rs);
        }
        return devZoneCache;
    }
}

