/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.entity.DevFlagEntity;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class DeviceTimeRepository {
    private static final Logger LOGGER = LogManager.getInstance().getMonitorLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(DevFlagEntity devFlag) {
        LOGGER.info((Object)("add " + devFlag + "to DB"));
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        boolean flag = false;
        if (conn != null) {
            try {
                String str = "INSERT into ATIC_DEV_WORK_TIME(DEVICE_IP, DEVICE_TYPE, STOP_TIME, START_TIME) Values(?,?,?,?)";
                pstmt = conn.prepareStatement(str);
                pstmt.setString(1, devFlag.getDevIp());
                pstmt.setInt(2, devFlag.getDevType());
                pstmt.setLong(3, devFlag.getStopWorkTime());
                pstmt.setLong(4, devFlag.getStartWorkTime());
                pstmt.execute();
                flag = true;
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)("INSERT into ATIC_DEV_WORK_TIME error: " + devFlag), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DeviceTimeRepository.freeDb(conn, pstmt);
                    throw throwable;
                }
                DeviceTimeRepository.freeDb(conn, pstmt);
            }
            DeviceTimeRepository.freeDb(conn, pstmt);
        }
        return flag;
    }

    public void addInBatch(List<DevFlagEntity> entitys) {
        for (DevFlagEntity each : entitys) {
            this.add(each);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExist(String deviceIp, int deviceType) {
        LOGGER.info((Object)("Judge obj exist.deviceIp: " + deviceIp + "deviceType: " + deviceType));
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        ResultSet result = null;
        if (conn != null) {
            try {
                String str = "select * from  ATIC_DEV_WORK_TIME Where DEVICE_IP=? and DEVICE_TYPE=? and START_TIME=0 ";
                pstmt = conn.prepareStatement(str);
                pstmt.setString(1, deviceIp);
                pstmt.setInt(2, deviceType);
                result = pstmt.executeQuery();
                if (result.next()) {
                    boolean bl = true;
                    DeviceTimeRepository.freeDb(conn, pstmt, result);
                    return bl;
                }
                DeviceTimeRepository.freeDb(conn, pstmt, result);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"When excute sql,some errors happened. ", (Throwable)e);
            }
            finally {
                DeviceTimeRepository.freeDb(conn, pstmt, result);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(DevFlagEntity devFlag) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        if (conn != null) {
            try {
                String str = "UPDATE  ATIC_DEV_WORK_TIME SET START_TIME =? Where DEVICE_IP =? AND DEVICE_TYPE = ? AND START_TIME =0";
                pstmt = conn.prepareStatement(str);
                pstmt.setLong(1, devFlag.getStartWorkTime());
                pstmt.setString(2, devFlag.getDevIp());
                pstmt.setInt(3, devFlag.getDevType());
                pstmt.execute();
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"When excute sql,some errors happened", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DeviceTimeRepository.freeDb(conn, pstmt);
                    throw throwable;
                }
                DeviceTimeRepository.freeDb(conn, pstmt);
            }
            DeviceTimeRepository.freeDb(conn, pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initStartTime(long startTime) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        if (conn != null) {
            try {
                String str = "UPDATE  ATIC_DEV_WORK_TIME SET START_TIME =? Where  START_TIME =0";
                pstmt = conn.prepareStatement(str);
                pstmt.setLong(1, startTime);
                pstmt.execute();
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"When initStartTime,some errors happened", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DeviceTimeRepository.freeDb(conn, pstmt);
                    throw throwable;
                }
                DeviceTimeRepository.freeDb(conn, pstmt);
            }
            DeviceTimeRepository.freeDb(conn, pstmt);
        }
    }

    private static void freeDb(Connection conn, PreparedStatement pstmt) {
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close prepare statement,some errors happened");
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close DB connection,some errors happened");
        }
    }

    private static void freeDb(Connection conn, PreparedStatement pstmt, ResultSet result) {
        try {
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close result,some errors happened.");
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close prepare statement,some errors happened");
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close DB connection,some errors happened");
        }
    }
}

