/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.baseline;

import com.hs.atic.collector.biz.event.process.BaseLineTaskWrapper;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public final class BaseLineDBUtil {
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();

    private BaseLineDBUtil() {
    }

    public static void updateBaselineStudyId(List<BaseLineTaskWrapper> taskList) {
        BaseLineDBUtil.updateBaselineTask(taskList);
        BaseLineDBUtil.updateBaselineData(taskList);
        BaseLineDBUtil.updateBaselineDetail(taskList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void updateBaselineTask(List<BaseLineTaskWrapper> objs) {
        String updataBaselineTask = "UPDATE atic_baseline_task SET PKID = ? WHERE ZONE_ID = ?";
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DBConnPool.getConnection();
            ps = con.prepareStatement(updataBaselineTask);
            int paramIndex = 0;
            for (BaseLineTaskWrapper e : objs) {
                paramIndex = 1;
                ps.setLong(paramIndex++, e.getPkid());
                ps.setLong(paramIndex++, e.getZoneId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"updateBaselineTask error!!");
            BaseLineDBUtil.freeDbResource(con, ps);
        }
        catch (Exception e2) {
            LOGGER.error((Object)"updateBaselineTask error!!");
            {
                catch (Throwable throwable) {
                    BaseLineDBUtil.freeDbResource(con, ps);
                    throw throwable;
                }
            }
            BaseLineDBUtil.freeDbResource(con, ps);
        }
        BaseLineDBUtil.freeDbResource(con, ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void updateBaselineData(List<BaseLineTaskWrapper> objs) {
        String updataBaselineData = "UPDATE atic_baseline_data SET PKID = ? WHERE ZONE_ID = ?";
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DBConnPool.getConnection();
            ps = con.prepareStatement(updataBaselineData);
            int paramIndex = 0;
            for (BaseLineTaskWrapper e : objs) {
                paramIndex = 1;
                ps.setLong(paramIndex++, e.getPkid());
                ps.setLong(paramIndex++, e.getZoneId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"updateBaselineData error!!");
            BaseLineDBUtil.freeDbResource(con, ps);
        }
        catch (Exception e2) {
            LOGGER.error((Object)"updateBaselineData error!!");
            {
                catch (Throwable throwable) {
                    BaseLineDBUtil.freeDbResource(con, ps);
                    throw throwable;
                }
            }
            BaseLineDBUtil.freeDbResource(con, ps);
        }
        BaseLineDBUtil.freeDbResource(con, ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void updateBaselineDetail(List<BaseLineTaskWrapper> objs) {
        String ipdataBaselineDataDetail = "UPDATE atic_baseline_detail SET PKID = ? WHERE ZONE_ID = ?";
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DBConnPool.getConnection();
            ps = con.prepareStatement(ipdataBaselineDataDetail);
            int paramIndex = 0;
            for (BaseLineTaskWrapper e : objs) {
                paramIndex = 1;
                ps.setLong(paramIndex++, e.getPkid());
                ps.setLong(paramIndex++, e.getZoneId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"updateBaselineDetail error!!");
            BaseLineDBUtil.freeDbResource(con, ps);
        }
        catch (Exception e2) {
            LOGGER.error((Object)"updateBaselineDetail error!!");
            {
                catch (Throwable throwable) {
                    BaseLineDBUtil.freeDbResource(con, ps);
                    throw throwable;
                }
            }
            BaseLineDBUtil.freeDbResource(con, ps);
        }
        BaseLineDBUtil.freeDbResource(con, ps);
    }

    private static void freeDbResource(Connection con, PreparedStatement stmt) {
        try {
            if (null != stmt) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }
}

