/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.baseline;

import com.hs.atic.collector.biz.event.process.BaseLineTaskWrapper;
import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.util.TimeTransformer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BaseLineTaskRepository
extends RepositoryAdaptor<BaseLineTaskWrapper> {
    private static final String TASK_TABLE_NAME = "ATIC_BASELINE_TASK";
    private static final String INSERT_SQL = "INSERT INTO ATIC_BASELINE_TASK(PKID,ZONE_ID,START_CYC,START_TIME) VALUES (?,?,?,?)";
    private static final String QUERY_SQL = "SELECT PKID,ZONE_ID,START_CYC,START_TIME FROM ATIC_BASELINE_TASK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createObject(BaseLineTaskWrapper wrapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("now baseline task to db,task is :" + wrapper));
        }
        PreparedStatement insert = null;
        Connection con = null;
        try {
            con = this.getConnection();
            insert = con.prepareStatement(INSERT_SQL);
            insert.setLong(1, wrapper.getPkid());
            insert.setLong(2, wrapper.getZoneId());
            insert.setLong(3, wrapper.getCyc());
            insert.setLong(4, TimeTransformer.convertTimeString(wrapper.getStart()));
            insert.execute();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"create capture task file  to DB error", (Throwable)e);
            }
            catch (Throwable throwable) {
                BaseLineTaskRepository.freeDbResource(con, insert);
                throw throwable;
            }
            BaseLineTaskRepository.freeDbResource(con, insert);
        }
        BaseLineTaskRepository.freeDbResource(con, insert);
    }

    @Override
    public void deleteObject(Condition condition) {
        this.deleteObjectByJdbc(condition, TASK_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BaseLineTaskWrapper> queryObject(Condition condition) {
        PreparedStatement query = null;
        Connection con = null;
        ResultSet result = null;
        ArrayList<BaseLineTaskWrapper> wrapperList = new ArrayList<BaseLineTaskWrapper>();
        try {
            con = this.getConnection();
            query = con.prepareStatement("SELECT PKID,ZONE_ID,START_CYC,START_TIME FROM ATIC_BASELINE_TASK WHERE " + condition.toSql());
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> list = conditionClause.getValueList();
                for (int i = 0; i < list.size(); ++i) {
                    query.setObject(i + 1, list.get(i));
                }
            }
            result = query.executeQuery();
            while (result.next()) {
                BaseLineTaskWrapper wrapper = new BaseLineTaskWrapper(result.getLong(1), result.getLong(2), result.getLong(3), TimeTransformer.transferlong2String(result.getLong(4) * 1000L));
                wrapper.setStartup(true);
                wrapperList.add(wrapper);
            }
            BaseLineTaskRepository.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query serviceLearningTaskWrapper error", (Throwable)e);
        }
        finally {
            BaseLineTaskRepository.freeDbResource(con, query, result);
        }
        return wrapperList;
    }
}

