/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.daemon;

import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.entity.event.BaseLineEvent;
import com.hs.atic.collector.util.LogManager;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class BaseLineRecycleThread
implements Runnable {
    private static final int SLEEP_FOR_A_WHILE = 60000;
    private static final Logger LOGGER = LogManager.getInstance().getSystemLog();
    private int beforeDay = 0;
    private Repository<BaseLineEvent> resultRepository = RepositoryFactory.getInstance().getRepository(BaseLineEvent.class.getName());

    @Override
    public void run() {
        while (true) {
            if (this.isTime2Run(this.getCurrentDay()).booleanValue()) {
                try {
                    this.deleteBaseLineDetailData();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"deleteBaseLineDetailData", (Throwable)e);
                }
            }
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"baseLineRecycle thread InterruptedException happened", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void deleteBaseLineDetailData() {
        this.resultRepository.deleteDeailObject();
    }

    private int getCurrentDay() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(6);
        return day;
    }

    private Boolean isTime2Run(int currentDay) {
        int hour;
        Calendar cal = Calendar.getInstance();
        if (currentDay > this.beforeDay && (hour = cal.get(11)) >= 3) {
            this.beforeDay = currentDay;
            return true;
        }
        return false;
    }
}

