/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.daemon;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.daemon.RepairOrOptimizeDbTableThread;
import com.hs.atic.collector.entity.alarm.DbTableAlarmEntity;
import com.hs.atic.collector.util.CrashThreadHandler;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class CheckDbTableUtil {
    public static final Logger LOGGER = LogManager.getInstance().getCheckDbTableLog();
    private static final List<String> BIG_DATA_TABLES = new ArrayList<String>();

    private CheckDbTableUtil() {
    }

    public static void optimizeTable(String tableName) {
        String optimizeSql = "OPTIMIZE TABLE " + tableName;
        String repairSql = "REPAIR TABLE " + tableName;
        try {
            if (!CheckDbTableUtil.getExcuteResult(optimizeSql)) {
                LOGGER.error((Object)("db table can not optimize, table name:" + tableName));
                if (CheckDbTableUtil.getExcuteResult(repairSql)) {
                    AlarmThread.getInstance().addDbTableAlarm(new DbTableAlarmEntity(tableName, false));
                    LOGGER.info((Object)("db table repair ok, table name:" + tableName));
                } else {
                    LOGGER.error((Object)("db table can not repair, table name:" + tableName));
                    AlarmThread.getInstance().addDbTableAlarm(new DbTableAlarmEntity(tableName, true));
                }
            } else {
                CheckDbTableUtil.checkAndNotifyClaerAlarm(tableName);
                LOGGER.info((Object)("db table optimize ok, table name:" + tableName));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("db table optimize unknow error, table name:" + tableName + ", exception:" + e));
        }
    }

    private static void checkAndNotifyClaerAlarm(String tableName) {
        if (AlarmThread.getInstance().isTableAlarm(tableName)) {
            LOGGER.info((Object)("db table is ok to clear alarm, talbeName=" + tableName));
            AlarmThread.getInstance().addDbTableAlarm(new DbTableAlarmEntity(tableName, false));
        }
    }

    public static void checkDb() {
        try {
            List<String> allTableName = CheckDbTableUtil.getAllTableName();
            for (String tableName : allTableName) {
                String checkSql = "CHECK TABLE " + tableName;
                String repairSql = "REPAIR TABLE " + tableName;
                if (!CheckDbTableUtil.getExcuteResult(checkSql)) {
                    LOGGER.error((Object)("db table is damage, table name:" + tableName));
                    AlarmThread.getInstance().addDbTableAlarm(new DbTableAlarmEntity(tableName, true));
                    RepairOrOptimizeDbTableThread repairOrOptimizeDbTableThread = new RepairOrOptimizeDbTableThread(true, tableName);
                    repairOrOptimizeDbTableThread.setName(repairSql);
                    repairOrOptimizeDbTableThread.setUncaughtExceptionHandler(CrashThreadHandler.getInstance());
                    repairOrOptimizeDbTableThread.start();
                    continue;
                }
                CheckDbTableUtil.checkAndNotifyClaerAlarm(tableName);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("db table checkDb unknow error: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getExcuteResult(String sql) {
        ResultSet rs;
        PreparedStatement st;
        Connection conn;
        block5: {
            boolean bl;
            conn = null;
            st = null;
            rs = null;
            try {
                StringBuffer temSql = new StringBuffer(sql);
                temSql.append("");
                conn = DBConnPool.getConnection();
                st = conn.prepareStatement(temSql.toString());
                rs = st.executeQuery();
                String result = "";
                while (rs.next()) {
                    result = rs.getString("Msg_text");
                }
                if (!result.equalsIgnoreCase("OK") && !result.equalsIgnoreCase("Table is already up to date") && !result.contains("The partition engine")) break block5;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"SQLException", (Throwable)e);
                }
                catch (Throwable throwable) {
                    CheckDbTableUtil.freeDb(conn, st, rs);
                    throw throwable;
                }
                CheckDbTableUtil.freeDb(conn, st, rs);
            }
            CheckDbTableUtil.freeDb(conn, st, rs);
            return bl;
        }
        CheckDbTableUtil.freeDb(conn, st, rs);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllTableName() {
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        ArrayList<String> allTableName = new ArrayList<String>();
        String sql = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'collector'";
        try {
            conn = DBConnPool.getConnection();
            st = conn.prepareStatement(sql);
            rs = st.executeQuery();
            while (rs.next()) {
                allTableName.add(rs.getString("TABLE_NAME"));
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"SQLException", (Throwable)e);
            }
            catch (Throwable throwable) {
                CheckDbTableUtil.freeDb(conn, st, rs);
                throw throwable;
            }
            CheckDbTableUtil.freeDb(conn, st, rs);
        }
        CheckDbTableUtil.freeDb(conn, st, rs);
        return allTableName;
    }

    private static void freeDb(Connection conn, PreparedStatement st, ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"rs.close() error SQLException");
            }
        }
        try {
            if (null != st) {
                st.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"st.close() SQLException");
        }
        try {
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"conn.close() SQLException");
        }
    }

    static {
        BIG_DATA_TABLES.add("atic_ip_attack_exact_log");
        BIG_DATA_TABLES.add("atic_ip_attack_log");
    }
}

