/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.daemon;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.daemon.PartitionRule;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public final class PartitionRepository {
    public static final Logger LOGGER = LogManager.getInstance().getPartitionLog();

    private PartitionRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getMaxPartitonTime(String table) {
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        long maxPartitionTime = 0L;
        try {
            conn = DBConnPool.getConnection();
            st = conn.prepareStatement("SELECT MAX(P.PARTITION_DESCRIPTION) FROM INFORMATION_SCHEMA.PARTITIONS P WHERE P.TABLE_NAME =  ? ");
            st.setString(1, table);
            rs = st.executeQuery();
            while (rs.next()) {
                if (rs.getString(1) == null) continue;
                maxPartitionTime = rs.getLong(1);
            }
            PartitionRepository.freeDbResource(conn, st, rs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"SQLException", (Throwable)e);
        }
        finally {
            PartitionRepository.freeDbResource(conn, st, rs);
        }
        return maxPartitionTime;
    }

    public static void freeDbResource(Connection con, PreparedStatement delete, ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"rs.close()");
            }
        }
        try {
            if (null != delete) {
                delete.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"st.close()");
        }
        try {
            if (null != con) {
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"conn.close()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void excute(String sql) {
        Connection conn = null;
        PreparedStatement st = null;
        try {
            StringBuffer temSql = new StringBuffer(sql);
            temSql.append("");
            conn = DBConnPool.getConnection();
            st = conn.prepareStatement(temSql.toString());
            st.executeUpdate();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)("excute sql error." + sql));
                LOGGER.error((Object)"SQLException", (Throwable)e);
            }
            catch (Throwable throwable) {
                PartitionRepository.freeDbResource(conn, st, null);
                throw throwable;
            }
            PartitionRepository.freeDbResource(conn, st, null);
        }
        PartitionRepository.freeDbResource(conn, st, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> queryDropPartition(String table, long shouldDropPartitionDescription) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        ResultSet result = null;
        ArrayList<String> partitions = new ArrayList<String>();
        if (conn != null) {
            try {
                String str = "SELECT  P.PARTITION_NAME FROM INFORMATION_SCHEMA.PARTITIONS P WHERE P.TABLE_NAME  =? AND P.PARTITION_DESCRIPTION <= ?";
                pstmt = conn.prepareStatement(str);
                pstmt.setString(1, table);
                pstmt.setLong(2, shouldDropPartitionDescription);
                result = pstmt.executeQuery();
                while (result.next()) {
                    partitions.add(result.getString(1));
                }
                CommonUtil.free(conn, pstmt, result);
            }
            catch (SQLException e) {
                if (null != pstmt) {
                    LOGGER.error((Object)("When excute sql,some errors happened, pstmt.toString()=" + pstmt.toString()), (Throwable)e);
                }
            }
            finally {
                CommonUtil.free(conn, pstmt, result);
            }
        }
        return partitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PartitionRule> getAllPartitionRules() {
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        ArrayList<PartitionRule> result = new ArrayList<PartitionRule>();
        String sql = "SELECT RULE_ID,PARTITION_TIME,PARTITION_UNIT,PARTITION_HOLD_TIME,PARTITION_HOLD_UNIT,TABLES,PARTITION_EXPRESSION,REFRESH_MARK FROM ATIC_PARTITION_RULE";
        try {
            conn = DBConnPool.getConnection();
            st = conn.prepareStatement(sql);
            rs = st.executeQuery();
            while (rs.next()) {
                PartitionRule rule = new PartitionRule();
                rule.setRuleId(rs.getInt(1));
                rule.setPartitionTime(rs.getInt(2));
                rule.setPartitionUnit(rs.getString(3));
                rule.setPartitionHoldTime(rs.getInt(4));
                rule.setPartitionHoldUnit(rs.getString(5));
                rule.setPartitionExpression(rs.getString(7));
                rule.setRefreshMark(rs.getInt(8));
                ArrayList<String> tableList = new ArrayList<String>();
                String tables = rs.getString(6);
                if (null != tables) {
                    String[] tableArray;
                    for (String table : tableArray = tables.split(",")) {
                        if (null == table || "".equals(table)) continue;
                        tableList.add(table);
                    }
                }
                rule.setTableNames(tableList);
                result.add(rule);
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"SQLException", (Throwable)e);
            }
            catch (Throwable throwable) {
                CommonUtil.free(conn, st, rs);
                throw throwable;
            }
            CommonUtil.free(conn, st, rs);
        }
        CommonUtil.free(conn, st, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(List<String> sqlList) {
        if (!sqlList.isEmpty()) {
            Connection conn = null;
            PreparedStatement stmt = null;
            String sql = "";
            try {
                conn = DBConnPool.getConnection();
                conn.setAutoCommit(false);
                Iterator<String> iterator = sqlList.iterator();
                while (iterator.hasNext()) {
                    String excutesql;
                    sql = excutesql = iterator.next();
                    StringBuffer temSql = new StringBuffer(excutesql);
                    temSql.append("");
                    stmt = conn.prepareStatement(temSql.toString());
                    stmt.execute();
                    stmt.close();
                }
                conn.commit();
            }
            catch (SQLException e) {
                LOGGER.error((Object)("excute sql error" + sql));
            }
            finally {
                CommonUtil.free(conn, stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> queryPartitionAccord2NewRule(String tableName) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        ResultSet result = null;
        ArrayList<String> partitions = new ArrayList<String>();
        if (conn != null) {
            try {
                String str = "SELECT  P.PARTITION_NAME FROM INFORMATION_SCHEMA.PARTITIONS P WHERE P.TABLE_NAME  =  ?   AND  P.PARTITION_DESCRIPTION  > (SELECT  I.PARTITION_DESCRIPTION FROM INFORMATION_SCHEMA.PARTITIONS I WHERE I.TABLE_NAME  = ? AND  I.PARTITION_DESCRIPTION  > ? LIMIT 0 ,1 ) ";
                pstmt = conn.prepareStatement(str);
                pstmt.setString(1, tableName);
                pstmt.setString(2, tableName);
                pstmt.setLong(3, System.currentTimeMillis() / 1000L);
                result = pstmt.executeQuery();
                while (result.next()) {
                    partitions.add(result.getString(1));
                }
                CommonUtil.free(conn, pstmt, result);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"When excute sql,some errors happened", (Throwable)e);
            }
            finally {
                CommonUtil.free(conn, pstmt, result);
            }
        }
        return partitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshPartitionRuleMark(int ruleId) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        if (conn != null) {
            try {
                String str = "UPDATE ATIC_PARTITION_RULE SET REFRESH_MARK = ? WHERE RULE_ID  = ?";
                pstmt = conn.prepareStatement(str);
                pstmt.setInt(1, 0);
                pstmt.setInt(2, ruleId);
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"When excute sql,some errors happened", (Throwable)e);
                }
                catch (Throwable throwable) {
                    CommonUtil.free(conn, pstmt);
                    throw throwable;
                }
                CommonUtil.free(conn, pstmt);
            }
            CommonUtil.free(conn, pstmt);
        }
    }
}

