/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.daemon;

import com.hs.atic.collector.db.daemon.CheckDbTableUtil;
import com.hs.atic.collector.db.daemon.PartitionRule;
import com.hs.atic.collector.db.daemon.PartitionUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

public class PartitionThread
implements Runnable {
    private static final int SLEEP_FOR_A_WHILE = 60000;
    private static final Logger LOGGER = LogManager.getInstance().getPartitionLog();
    private static boolean checkDBTableSwitch = true;
    int oldHour = -1;
    private int beforeDay = 0;

    @Override
    public void run() {
        PartitionThread.initCheckDBTableSwitch();
        while (true) {
            int newHour;
            if (this.oldHour != (newHour = Calendar.getInstance().get(11))) {
                try {
                    List<PartitionRule> rules = PartitionUtil.getAllPartitionRules();
                    for (PartitionRule rule : rules) {
                        rule.doPartitionOperate();
                    }
                    this.oldHour = newHour;
                }
                catch (Exception e) {
                    LOGGER.error((Object)"When create table thread run,some errors happend", (Throwable)e);
                }
            }
            if (checkDBTableSwitch && this.isTime2Run(this.getCurrentDay()).booleanValue()) {
                try {
                    CheckDbTableUtil.checkDb();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"checkDb some errors happend", (Throwable)e);
                }
            }
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Monitor thread InterruptedException happened", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private int getCurrentDay() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(6);
        return day;
    }

    private Boolean isTime2Run(int currentDay) {
        int hour;
        Calendar cal = Calendar.getInstance();
        if (currentDay > this.beforeDay && (hour = cal.get(11)) >= 3) {
            this.beforeDay = currentDay;
            return true;
        }
        return false;
    }

    private static void initCheckDBTableSwitch() {
        try {
            checkDBTableSwitch = Boolean.valueOf(EventUtil.getEventConfigProperty("checkDbTableUtilSwitch"));
            LOGGER.error((Object)("initCheckDBTableSwitch checkDBTableSwitch = " + checkDBTableSwitch));
        }
        catch (Exception e) {
            checkDBTableSwitch = true;
            LOGGER.error((Object)"initCheckDBTableSwitch error set checkDBTableSwitch = true ", (Throwable)e);
        }
    }
}

