/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.daemon;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.daemon.CheckDbTableUtil;
import com.hs.atic.collector.db.daemon.PartitionRepository;
import com.hs.atic.collector.db.daemon.PartitionRule;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class PartitionUtil {
    public static final Logger LOGGER = LogManager.getInstance().getPartitionLog();

    private PartitionUtil() {
    }

    public static List<PartitionRule> getAllPartitionRules() {
        return PartitionRepository.getAllPartitionRules();
    }

    public static boolean isPassCreateTime(String mark) {
        Calendar calendar = Calendar.getInstance();
        if ("M".equals(mark) && calendar.get(2) + 1 < 12) {
            return false;
        }
        if ("M".equals(mark) || "D".equals(mark)) {
            if (calendar.get(7) > 5) {
                return true;
            }
            if (calendar.get(7) < 5) {
                return false;
            }
            if (calendar.get(11) >= 3) {
                return true;
            }
        }
        return "H".equals(mark) && calendar.get(11) >= 3;
    }

    public static long getMaxPartitonTime(String table) {
        return PartitionRepository.getMaxPartitonTime(table);
    }

    public static Map<String, Long> getPartitionModule(long startTime, long endTime, int partitonTime, String partitionUnit) {
        Calendar start = Calendar.getInstance();
        if (startTime == 0L || startTime < System.currentTimeMillis() / 1000L) {
            if (!"H".equals(partitionUnit)) {
                start.set(11, 0);
            }
            start.set(12, 0);
            start.set(13, 0);
        } else {
            start.setTimeInMillis(startTime * 1000L);
        }
        HashMap<String, Long> result = new HashMap<String, Long>();
        if (partitonTime == 0) {
            LOGGER.error((Object)("partition data error. partitionTime is " + partitonTime));
            return result;
        }
        String partitionName = partitionUnit;
        if ("M".equals(partitionUnit)) {
            start.set(5, 1);
            while (start.getTimeInMillis() / 1000L < endTime) {
                partitionName = partitionUnit + start.get(1) + "_" + (start.get(2) + 1);
                start.set(2, start.get(2) + partitonTime);
                result.put(partitionName, start.getTimeInMillis() / 1000L > endTime ? endTime : start.getTimeInMillis() / 1000L);
            }
        } else if ("D".equals(partitionUnit)) {
            while (start.getTimeInMillis() / 1000L < endTime) {
                partitionName = partitionUnit + start.get(1) + "_" + (start.get(2) + 1) + "_" + start.get(5);
                start.set(5, start.get(5) + partitonTime);
                result.put(partitionName, start.getTimeInMillis() / 1000L > endTime ? endTime : start.getTimeInMillis() / 1000L);
            }
        } else if ("H".equals(partitionUnit)) {
            while (start.getTimeInMillis() / 1000L < endTime) {
                partitionName = partitionUnit + start.get(1) + "_" + (start.get(2) + 1) + "_" + start.get(5) + "_" + start.get(11);
                start.set(11, start.get(11) + partitonTime);
                result.put(partitionName, start.getTimeInMillis() / 1000L > endTime ? endTime : start.getTimeInMillis() / 1000L);
            }
        } else {
            LOGGER.error((Object)("Error partitionUnit:" + partitionUnit));
        }
        return result;
    }

    private static List<Map.Entry<String, Long>> mapSortToList(Map<String, Long> modules) {
        ArrayList<Map.Entry<String, Long>> infoIds = new ArrayList<Map.Entry<String, Long>>(modules.entrySet());
        Collections.sort(infoIds, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                if (o2.getValue() > o1.getValue()) {
                    return -1;
                }
                if (o2.getValue() < o1.getValue()) {
                    return 1;
                }
                return 0;
            }
        });
        return infoIds;
    }

    public static void createPartition(Map<String, Long> modules, String tableName, String expression, boolean isCreate) {
        if (!modules.isEmpty()) {
            List<Map.Entry<String, Long>> sortList = PartitionUtil.mapSortToList(modules);
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("ALTER TABLE  `");
            sqlBuffer.append(tableName);
            if (isCreate) {
                sqlBuffer.append("` PARTITION BY RANGE (");
                sqlBuffer.append(expression);
                sqlBuffer.append(") ( ");
            } else {
                sqlBuffer.append("` ADD PARTITION ( ");
            }
            for (Map.Entry<String, Long> entry : sortList) {
                sqlBuffer.append("PARTITION ");
                sqlBuffer.append(entry.getKey());
                sqlBuffer.append(" VALUES LESS THAN(");
                sqlBuffer.append(entry.getValue());
                sqlBuffer.append("),");
            }
            sqlBuffer.replace(sqlBuffer.length() - 1, sqlBuffer.length(), ")");
            PartitionRepository.excute(sqlBuffer.toString());
        }
    }

    private static List<String> getDropPartitionName(String tableName, long shouldDropPartitionDescription) {
        return PartitionRepository.queryDropPartition(tableName, shouldDropPartitionDescription);
    }

    public static void dropPartition(String tableName, long shouldDropPartitionDescription) {
        List<String> partitions = PartitionUtil.getDropPartitionName(tableName, shouldDropPartitionDescription);
        for (String partitionName : partitions) {
            PartitionUtil.dropPartition(tableName, partitionName);
        }
        if (!partitions.isEmpty()) {
            CheckDbTableUtil.optimizeTable(tableName);
        }
    }

    public static void dropPartitionAccord2NewRule(String tableName) {
        List<String> partitions = PartitionRepository.queryPartitionAccord2NewRule(tableName);
        for (String partitionName : partitions) {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("ALTER TABLE  `");
            sqlBuffer.append(tableName);
            sqlBuffer.append("` DROP PARTITION  ");
            sqlBuffer.append(partitionName);
            PartitionRepository.excute(sqlBuffer.toString());
        }
        if (!partitions.isEmpty()) {
            CheckDbTableUtil.optimizeTable(tableName);
        }
    }

    public static void refreshPartitionRuleMark(int ruleId) {
        PartitionRepository.refreshPartitionRuleMark(ruleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setPartitionParameter(int holdOriginal, int holdHour, int holdDay) {
        block7: {
            LOGGER.info((Object)("holdOriginal:" + holdOriginal));
            LOGGER.info((Object)("holdHour:" + holdHour));
            LOGGER.info((Object)("holdDay:" + holdDay));
            if (holdOriginal == 0 || holdHour == 0 || holdDay == 0) {
                LOGGER.info((Object)"input Partition Parameter  is wrong;");
                return false;
            }
            Connection conn = DBConnPool.getConnection();
            PreparedStatement pstmtOriginal = null;
            PreparedStatement pstmtHour = null;
            PreparedStatement pstmtDay = null;
            if (conn == null) break block7;
            try {
                conn.setAutoCommit(false);
                pstmtOriginal = conn.prepareStatement("UPDATE ATIC_PARTITION_RULE SET PARTITION_HOLD_TIME = ? ,PARTITION_HOLD_UNIT = 'D' WHERE H0LD_TYPE= 'D'");
                pstmtOriginal.setInt(1, holdOriginal);
                pstmtOriginal.execute();
                pstmtHour = conn.prepareStatement("UPDATE ATIC_PARTITION_RULE SET PARTITION_HOLD_TIME = ? ,PARTITION_HOLD_UNIT = 'M' WHERE H0LD_TYPE= 'M'");
                pstmtHour.setInt(1, holdHour);
                pstmtHour.execute();
                pstmtDay = conn.prepareStatement("UPDATE ATIC_PARTITION_RULE SET PARTITION_HOLD_TIME = ? ,PARTITION_HOLD_UNIT = 'M' WHERE H0LD_TYPE= 'Y'");
                pstmtDay.setInt(1, holdDay * 12);
                pstmtDay.execute();
                conn.commit();
                LOGGER.info((Object)"update Partition Parameter OK!!");
            }
            catch (SQLException e) {
                boolean bl;
                try {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e1) {
                        LOGGER.error((Object)"rollback error");
                    }
                    LOGGER.error((Object)"update partition parameter error");
                    bl = false;
                }
                catch (Throwable throwable) {
                    CommonUtil.free(null, pstmtOriginal);
                    CommonUtil.free(null, pstmtHour);
                    CommonUtil.free(conn, pstmtDay);
                    throw throwable;
                }
                CommonUtil.free(null, pstmtOriginal);
                CommonUtil.free(null, pstmtHour);
                CommonUtil.free(conn, pstmtDay);
                return bl;
            }
            CommonUtil.free(null, pstmtOriginal);
            CommonUtil.free(null, pstmtHour);
            CommonUtil.free(conn, pstmtDay);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPartitionHasData(String table, long startTime, long endTime) {
        ResultSet rs;
        PreparedStatement st;
        Connection conn;
        block4: {
            boolean bl;
            conn = null;
            st = null;
            rs = null;
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("SELECT COUNT(*) FROM ").append(table);
            strBuf.append(" WHERE log_time>= ? ");
            strBuf.append(" AND log_time<= ? ");
            try {
                int count;
                conn = DBConnPool.getConnection();
                st = conn.prepareStatement(strBuf.toString());
                st.setLong(1, startTime);
                st.setLong(2, endTime);
                rs = st.executeQuery();
                if (!rs.next() || (count = rs.getInt(1)) < 0) break block4;
                bl = true;
            }
            catch (SQLException e) {
                boolean bl2;
                try {
                    LOGGER.error((Object)("SQLException of sql=" + strBuf.toString()), (Throwable)e);
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    PartitionUtil.freeDbResource(conn, st, rs);
                    throw throwable;
                }
                PartitionUtil.freeDbResource(conn, st, rs);
                return bl2;
            }
            PartitionUtil.freeDbResource(conn, st, rs);
            return bl;
        }
        PartitionUtil.freeDbResource(conn, st, rs);
        return false;
    }

    public static void freeDbResource(Connection con, PreparedStatement delete, ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"rs.close() error");
            }
        }
        try {
            if (null != delete) {
                delete.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"st.close() error ");
        }
        try {
            if (null != con) {
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"conn.close() error");
        }
    }

    public static void dropPartition(String tableName, String partitionName) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("ALTER TABLE  `");
        sqlBuffer.append(tableName);
        sqlBuffer.append("` DROP PARTITION  ");
        sqlBuffer.append(partitionName);
        LOGGER.debug((Object)("dropPartition: " + sqlBuffer.toString()));
        PartitionRepository.excute(sqlBuffer.toString());
    }
}

