/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.daemon;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.db.daemon.CheckDbTableUtil;
import com.hs.atic.collector.entity.alarm.DbTableAlarmEntity;
import com.hs.atic.collector.util.LogManager;
import org.apache.log4j.Logger;

public class RepairOrOptimizeDbTableThread
extends Thread {
    private static final Logger LOGGER = LogManager.getInstance().getCheckDbTableLog();
    private boolean isRepair;
    private String tableName;

    public RepairOrOptimizeDbTableThread(boolean isRepair, String tableName) {
        this.isRepair = isRepair;
        this.tableName = tableName;
    }

    @Override
    public void run() {
        String optimizeSql = "OPTIMIZE TABLE " + this.tableName;
        String repairSql = "REPAIR TABLE " + this.tableName;
        try {
            if (this.isRepair) {
                LOGGER.info((Object)("start repair db table, table name:" + this.tableName));
                if (CheckDbTableUtil.getExcuteResult(repairSql)) {
                    AlarmThread.getInstance().addDbTableAlarm(new DbTableAlarmEntity(this.tableName, false));
                    LOGGER.info((Object)("db table repair ok, table name:" + this.tableName));
                } else {
                    LOGGER.error((Object)("db table can not repair, table name:" + this.tableName));
                }
            } else {
                LOGGER.info((Object)("start optimize db table, table name:" + this.tableName));
                if (CheckDbTableUtil.getExcuteResult(optimizeSql)) {
                    LOGGER.info((Object)("db table optimize ok, table name:" + this.tableName));
                } else {
                    LOGGER.error((Object)("db table can not optimize, table name:" + this.tableName));
                    if (CheckDbTableUtil.getExcuteResult(repairSql)) {
                        RepairOrOptimizeDbTableThread.checkAndNotifyClaerAlarm(this.tableName);
                        LOGGER.info((Object)("db table repair ok, table name:" + this.tableName));
                    } else {
                        AlarmThread.getInstance().addDbTableAlarm(new DbTableAlarmEntity(this.tableName, true));
                        LOGGER.error((Object)("db table can not repair, table name:" + this.tableName));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("RepairOrOptimizeDbTableThread run error: " + e));
        }
    }

    private static void checkAndNotifyClaerAlarm(String tableName) {
        if (AlarmThread.getInstance().isTableAlarm(tableName)) {
            LOGGER.info((Object)("db table is ok to clear alarm, talbeName=" + tableName));
            AlarmThread.getInstance().addDbTableAlarm(new DbTableAlarmEntity(tableName, false));
        }
    }
}

