/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.daemon;

import com.hs.atic.collector.db.daemon.SummaryManager;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.protal.ProtalConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import org.apache.log4j.Logger;

public class SummaryThread
extends Thread {
    private static final Logger LOGGER = LogManager.getInstance().getDaySummLog();
    private static final int I_WANNA_SLEEP_FOR_A_WHILE = 30000;
    private static final String DAILY_SUMMARY_CONF_FILE_PATH = "conf//DailySummary.conf";
    private String dailySummaryConf = "-1";

    public SummaryThread() {
        this.setName("SummaryThread");
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.startDailySummary();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Starting daily summary failed.", (Throwable)e);
            }
            try {
                Thread.sleep(30000L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Interrupted Exception occurred when starting daily & monthly summary.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void startDailySummary() {
        if (!this.isDailySummaryConfValid()) {
            try {
                this.dailySummaryConf = this.readSummaryConfFile(DAILY_SUMMARY_CONF_FILE_PATH);
                if (CommonUtil.isNull(this.dailySummaryConf)) {
                    this.dailySummaryConf = "-1";
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Read config file error.", (Throwable)e);
            }
            if (!this.isDailySummaryConfValid()) {
                this.dailySummaryConf = this.summaryConfForToday();
                try {
                    this.writeSummaryConfFile(DAILY_SUMMARY_CONF_FILE_PATH, this.dailySummaryConf);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"write config files error,system will retry ", (Throwable)e);
                    return;
                }
            }
        }
        long dateTobeSummarized = this.getDateTobeSummarized(this.dailySummaryConf);
        long status = this.getStatus(this.dailySummaryConf);
        long today = CommonUtil.time4TodayBeginning();
        if (dateTobeSummarized >= today) {
            return;
        }
        if (today - dateTobeSummarized > 86400L) {
            LOGGER.info((Object)"Some data will be throw because of overtime ");
            try {
                SummaryManager.clearData(dateTobeSummarized);
                try {
                    SummaryManager.doDailySummary(dateTobeSummarized);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("summary data failure,Time is " + dateTobeSummarized), (Throwable)e);
                }
                dateTobeSummarized = today - 86400L;
                status = 0L;
                this.dailySummaryConf = dateTobeSummarized + "," + status;
                this.writeSummaryConfFile(DAILY_SUMMARY_CONF_FILE_PATH, today - 86400L + ",0");
            }
            catch (IOException e) {
                LOGGER.error((Object)"write config files error,system will retry ", (Throwable)e);
                return;
            }
        }
        LOGGER.info((Object)"Summary begin");
        int newHour = Calendar.getInstance().get(11);
        if (newHour == 0) {
            return;
        }
        this.deleteOldPartFileOfMss();
        if (status != 0L) {
            if (!SummaryManager.clearData(dateTobeSummarized)) {
                LOGGER.info((Object)"system will retry ");
                return;
            }
            LOGGER.info((Object)"Deleting trash data succeeded");
        }
        this.dailySummaryConf = dateTobeSummarized + ",1";
        try {
            this.writeSummaryConfFile(DAILY_SUMMARY_CONF_FILE_PATH, this.dailySummaryConf);
        }
        catch (IOException e1) {
            LOGGER.error((Object)"write config files error,system will retry ", (Throwable)e1);
            return;
        }
        boolean isSucess = true;
        try {
            isSucess = SummaryManager.doDailySummary(dateTobeSummarized);
        }
        catch (Exception e) {
            LOGGER.error((Object)"SummaryManager.doDailySummary", (Throwable)e);
            SummaryManager.clearData(dateTobeSummarized);
            return;
        }
        if (isSucess) {
            this.dailySummaryConf = this.summaryConfForToday();
            try {
                this.writeSummaryConfFile(DAILY_SUMMARY_CONF_FILE_PATH, this.dailySummaryConf);
            }
            catch (IOException e) {
                LOGGER.error((Object)"write config files error,system will retry ", (Throwable)e);
                return;
            }
            LOGGER.info((Object)"Summary sucessed!!!");
        }
    }

    private void deleteOldPartFileOfMss() {
        try {
            ArrayList partFiles = new ArrayList();
            File directory = new File(ProtalConstants.PROTAL_EVENT_FILE_DIRECTORY);
            File[] files = directory.listFiles(new FilenameFilterImpl());
            if (files != null) {
                Collections.addAll(partFiles, files);
                Calendar calendar = Calendar.getInstance();
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                long todayTime = calendar.getTimeInMillis();
                for (File file : partFiles) {
                    long lastModifyTime = file.lastModified();
                    if (lastModifyTime >= todayTime || file.delete()) continue;
                    LOGGER.error((Object)"delete file in error");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"deleteOldPartFileOfMss error:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSummaryConfFile(String filePath) throws IOException {
        String summaryConf = "-1";
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "utf-8"));){
            if (bufferedReader.ready()) {
                summaryConf = bufferedReader.readLine();
            }
        }
        return summaryConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSummaryConfFile(String filePath, String summaryConfForToday) throws IOException {
        try (BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));){
            fileWriter.write(summaryConfForToday);
        }
    }

    private boolean isDailySummaryConfValid() {
        return !this.dailySummaryConf.equals("-1");
    }

    private String summaryConfForToday() {
        return CommonUtil.time4TodayBeginning() + ",0";
    }

    private long getDateTobeSummarized(String summaryConf) {
        String[] temp = summaryConf.split(",");
        return Long.parseLong(temp[0]);
    }

    private long getStatus(String summaryConf) {
        String[] temp = summaryConf.split(",");
        return Long.parseLong(temp[1]);
    }

    private static class FilenameFilterImpl
    implements FilenameFilter {
        private FilenameFilterImpl() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".part");
        }
    }
}

