/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.event.EventFileRepository;
import com.hs.atic.collector.entity.event.AttackTypeEvent;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import org.apache.log4j.Logger;

public class AttackTypeEventRepository
extends EventFileRepository<AttackTypeEvent> {
    private static final String ZONE_PREFIX_HOUR = "ATIC_ZONE_ATTACK_FLOW_H";
    private static final String IP_PREFIX_HOUR = "ATIC_IP_ATTACK_FLOW_H";
    private static final String ZONE_PREFIX = "ATIC_ZONE_ATTACK_FLOW";
    private static final String IP_PREFIX = "ATIC_IP_ATTACK_FLOW";
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();

    @Override
    protected String getDbString(AttackTypeEvent event) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(event.getAttackType().getTypeValue());
        buffer.append(";");
        buffer.append(event.getAttackType().getProtocol());
        buffer.append(";");
        buffer.append(event.getAttackType().getPort());
        buffer.append(";");
        buffer.append(event.getDropBytes());
        buffer.append(";");
        buffer.append(event.getDropPackets());
        buffer.append(";");
        buffer.append(event.getDropKbps());
        buffer.append(";");
        buffer.append(event.getDropPps());
        buffer.append(";");
        buffer.append(event.getIpAttackPeakPps());
        buffer.append(";");
        buffer.append(event.getIpAttackPeakKbps());
        buffer.append(";");
        buffer.append(event.getIpInPeakPps());
        buffer.append(";");
        buffer.append(event.getIpInPeakKbps());
        buffer.append(";");
        buffer.append(event.getTcpNewConnNum());
        buffer.append(";");
        buffer.append(event.getTcpCurConnNum());
        buffer.append(";");
        buffer.append(CommonUtil.tansPortsSet2String(event.getPorts()));
        return buffer.toString();
    }

    @Override
    protected String getTableName(AttackTypeEvent event) {
        if (event.isFromCleanDevice()) {
            if (event.isZoneEvent()) {
                if (event.isIsHourEvent()) {
                    return ZONE_PREFIX_HOUR;
                }
                return ZONE_PREFIX;
            }
            if (event.isZoneIp()) {
                if (event.isIsHourEvent()) {
                    return IP_PREFIX_HOUR;
                }
                return IP_PREFIX;
            }
        }
        LOGGER.warn((Object)("it is illegal .should not go this " + event));
        return "";
    }
}

