/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.condition.BaseLineConditionField;
import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.condition.ConditionSeparator;
import com.hs.atic.collector.db.condition.ConditionSeparatorFactory;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.BaseLineEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class BaseLineEventRepository
extends RepositoryAdaptor<BaseLineEvent> {
    private static final String MAIN_TABLE_NAME = "ATIC_BASELINE_DATA";
    private static final long YEAR = 365L;
    private static final String DETAIL_TABLE_NAME = "ATIC_BASELINE_DETAIL";
    private static final String INSERT_MAIN_SQL = "INSERT INTO ATIC_BASELINE_DATA(PKID,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID,CPU_SIZE,SYN_PPS,SYNACK_PPS,ACK_PPS,FINRST_PPS,TCPFRAG_PPS,ICMP_PPS,OTHER_KBPS,TCP_INCREASE_CON,TCP_CUR_CON,UDP_KBPS,UDPFRAG_KBPS,HTTP_PPS,HTTP_GET_PPS,HTTPS_PPS,DNS_REQUSET_PPS,DNS_REPLY_PPS,SIP_INVITE_PPS,TCP_SRC_INCREASE_CON,TCP_SRC_CUR_CON,TCP_RATIO,TCP_L500_RATIO,SYN_PKT_NUM) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_MAIN_SQL = "UPDATE ATIC_BASELINE_DATA SET CPU_SIZE = ?,SYN_PPS = ?,SYNACK_PPS = ?,ACK_PPS = ?,FINRST_PPS = ?,TCPFRAG_PPS = ?,ICMP_PPS = ?,OTHER_KBPS = ?,TCP_INCREASE_CON = ?,TCP_CUR_CON = ?,UDP_KBPS = ?,UDPFRAG_KBPS = ?,HTTP_PPS = ?,HTTP_GET_PPS = ? ,HTTPS_PPS = ?,DNS_REQUSET_PPS = ?,DNS_REPLY_PPS = ?,SIP_INVITE_PPS = ?,TCP_SRC_INCREASE_CON = ?,TCP_SRC_CUR_CON = ?,TCP_RATIO = ?,TCP_L500_RATIO = ?,SYN_PKT_NUM = ? WHERE PKID = ? AND DEVICE_TYPE = ? AND DEVICE_IP = ? AND DIRECTION = ? AND ZONE_ID = ? AND BIZ_ID = ?";
    private static final String INSERT_DETAIL_SQL = "INSERT INTO ATIC_BASELINE_DETAIL(PKID,LOG_TIME,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID,SYN_PPS,SYNACK_PPS,ACK_PPS,FINRST_PPS,TCPFRAG_PPS,ICMP_PPS,OTHER_KBPS,TCP_INCREASE_CON,TCP_CUR_CON,UDP_KBPS,UDPFRAG_KBPS,HTTP_PPS,HTTP_GET_PPS,HTTPS_PPS,DNS_REQUSET_PPS,DNS_REPLY_PPS,SIP_INVITE_PPS,TCP_SRC_INCREASE_CON,TCP_SRC_CUR_CON,TCP_RATIO,TCP_L500_RATIO,SYN_PKT_NUM,IS_ALERT) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_DETAIL_SQL = "UPDATE ATIC_BASELINE_DETAIL SET SYN_PPS = ?,SYNACK_PPS = ?,ACK_PPS = ?,FINRST_PPS = ?,TCPFRAG_PPS = ?,ICMP_PPS = ?,OTHER_KBPS = ?,TCP_INCREASE_CON = ?,TCP_CUR_CON = ?,UDP_KBPS = ?,UDPFRAG_KBPS = ?,HTTP_PPS = ?,HTTP_GET_PPS = ? ,HTTPS_PPS = ?,DNS_REQUSET_PPS = ?,DNS_REPLY_PPS = ?,SIP_INVITE_PPS = ?,TCP_SRC_INCREASE_CON = ?,TCP_SRC_CUR_CON = ?,TCP_RATIO = ?,TCP_L500_RATIO = ?,SYN_PKT_NUM = ?,IS_ALERT = ? WHERE PKID = ? AND LOG_TIME = ? AND DEVICE_TYPE = ? AND DEVICE_IP = ? AND DIRECTION  = ? AND ZONE_ID  = ? AND BIZ_ID = ? ";

    @Override
    public void deleteObject(Condition condition) {
        if (condition != null) {
            this.deleteObjectByJdbc(condition, MAIN_TABLE_NAME);
        }
    }

    @Override
    public void deleteDeailObject() {
        Long currentTimeMillis = System.currentTimeMillis();
        Long yearTimeMillis = 31536000L;
        ConditionClause idCondition = new ConditionClause();
        idCondition.setField(new BaseLineConditionField("logTime"));
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().lessThan();
        idCondition.setSeparator(separator);
        idCondition.setValue(currentTimeMillis / 1000L - yearTimeMillis);
        idCondition.addValueList(idCondition.getValue());
        ConditionClause conditionCla = idCondition;
        this.deleteObjectByJdbc(conditionCla, DETAIL_TABLE_NAME);
    }

    @Override
    public void createObjects(List<BaseLineEvent> objs) {
        if (!objs.isEmpty()) {
            if (objs.get(0).isIsHourEvent()) {
                this.createDetailObjects(objs);
            } else {
                this.createMainObjects(objs);
            }
        }
    }

    @Override
    public void updateObjects(List<BaseLineEvent> objs) {
        if (!objs.isEmpty()) {
            if (objs.get(0).isIsHourEvent()) {
                this.updateDetailObjects(objs);
            } else {
                this.updateMainObjects(objs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMainObjects(List<BaseLineEvent> objs) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(INSERT_MAIN_SQL);
            int paramIndex = 0;
            for (BaseLineEvent e : objs) {
                paramIndex = 1;
                ps.setLong(paramIndex++, e.getBaseLinePkid());
                ps.setString(paramIndex++, e.getDeviceIp());
                ps.setLong(paramIndex++, e.getDirection());
                ps.setLong(paramIndex++, e.getDeviceType());
                ps.setLong(paramIndex++, e.getZoneId());
                ps.setLong(paramIndex++, e.getBizId());
                ps.setLong(paramIndex++, 0L);
                this.setProtocolFlow(e, ps, paramIndex);
                ps.addBatch();
            }
            ps.executeBatch();
            for (BaseLineEvent e : objs) {
                e.setSaved(true);
            }
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"createObjects error!!", (Throwable)e);
            }
            catch (Throwable throwable) {
                BaseLineEventRepository.freeDbResource(con, ps);
                throw throwable;
            }
            BaseLineEventRepository.freeDbResource(con, ps);
        }
        BaseLineEventRepository.freeDbResource(con, ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDetailObjects(List<BaseLineEvent> objs) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DBConnPool.getConnection();
            ps = con.prepareStatement(INSERT_DETAIL_SQL);
            int paramIndex = 0;
            for (BaseLineEvent e : objs) {
                paramIndex = 1;
                ps.setLong(paramIndex++, e.getBaseLinePkid());
                ps.setLong(paramIndex++, e.getLogTime() / 1000L);
                ps.setString(paramIndex++, e.getDeviceIp());
                ps.setLong(paramIndex++, e.getDirection());
                ps.setLong(paramIndex++, e.getDeviceType());
                ps.setLong(paramIndex++, e.getZoneId());
                ps.setLong(paramIndex++, e.getBizId());
                paramIndex = this.setProtocolFlow(e, ps, paramIndex);
                ps.setBoolean(paramIndex++, e.isAlert());
                ps.addBatch();
            }
            ps.executeBatch();
            for (BaseLineEvent e : objs) {
                e.setSaved(true);
            }
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"createObjects error!!", (Throwable)e);
            }
            catch (Throwable throwable) {
                BaseLineEventRepository.freeDbResource(con, ps);
                throw throwable;
            }
            BaseLineEventRepository.freeDbResource(con, ps);
        }
        BaseLineEventRepository.freeDbResource(con, ps);
    }

    private int setProtocolFlow(BaseLineEvent e, PreparedStatement ps, int paramIndex) throws SQLException {
        ps.setLong(paramIndex++, e.getSynPps());
        ps.setLong(paramIndex++, e.getSynAckPps());
        ps.setLong(paramIndex++, e.getAckPps());
        ps.setLong(paramIndex++, e.getFinstPps());
        ps.setLong(paramIndex++, e.getTcpFragPps());
        ps.setLong(paramIndex++, e.getIcmpPps());
        ps.setLong(paramIndex++, e.getOtherKbps());
        ps.setLong(paramIndex++, e.getTcpIncreaseCon());
        ps.setLong(paramIndex++, e.getTcpCurCon());
        ps.setLong(paramIndex++, e.getUdpKbps());
        ps.setLong(paramIndex++, e.getUdpFragKbps());
        ps.setLong(paramIndex++, e.getHttpPps());
        ps.setLong(paramIndex++, e.getHttpGetPps());
        ps.setLong(paramIndex++, e.getHttpsPps());
        ps.setLong(paramIndex++, e.getDnsRequestPps());
        ps.setLong(paramIndex++, e.getDnsReplyPps());
        ps.setLong(paramIndex++, e.getSipInvitePps());
        ps.setLong(paramIndex++, e.getTcpSrcIncreaseCon());
        ps.setLong(paramIndex++, e.getTcpSrcCurCon());
        ps.setLong(paramIndex++, e.getTcpRatio());
        ps.setLong(paramIndex++, e.getTcpL500Ratio());
        ps.setLong(paramIndex++, e.getSynPktNum());
        return paramIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMainObjects(List<BaseLineEvent> objs) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DBConnPool.getConnection();
            ps = con.prepareStatement(UPDATE_MAIN_SQL);
            int paramIndex = 0;
            for (BaseLineEvent e : objs) {
                paramIndex = 1;
                ps.setLong(paramIndex++, 0L);
                paramIndex = this.setProtocolFlow(e, ps, paramIndex);
                ps.setLong(paramIndex++, e.getBaseLinePkid());
                ps.setLong(paramIndex++, e.getDeviceType());
                ps.setString(paramIndex++, e.getDeviceIp());
                ps.setLong(paramIndex++, e.getDirection());
                ps.setLong(paramIndex++, e.getZoneId());
                ps.setLong(paramIndex++, e.getBizId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"updateObjects error!!", (Throwable)e);
            }
            catch (Throwable throwable) {
                BaseLineEventRepository.freeDbResource(con, ps);
                throw throwable;
            }
            BaseLineEventRepository.freeDbResource(con, ps);
        }
        BaseLineEventRepository.freeDbResource(con, ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDetailObjects(List<BaseLineEvent> objs) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DBConnPool.getConnection();
            ps = con.prepareStatement(UPDATE_DETAIL_SQL);
            int paramIndex = 0;
            for (BaseLineEvent e : objs) {
                paramIndex = 1;
                paramIndex = this.setProtocolFlow(e, ps, paramIndex);
                ps.setBoolean(paramIndex++, e.isAlert());
                ps.setLong(paramIndex++, e.getBaseLinePkid());
                ps.setLong(paramIndex++, e.getLogTime() / 1000L);
                ps.setLong(paramIndex++, e.getDeviceType());
                ps.setString(paramIndex++, e.getDeviceIp());
                ps.setLong(paramIndex++, e.getDirection());
                ps.setLong(paramIndex++, e.getZoneId());
                ps.setLong(paramIndex++, e.getBizId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"updateObjects error!!", (Throwable)e);
            }
            catch (Throwable throwable) {
                BaseLineEventRepository.freeDbResource(con, ps);
                throw throwable;
            }
            BaseLineEventRepository.freeDbResource(con, ps);
        }
        BaseLineEventRepository.freeDbResource(con, ps);
    }
}

