/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.db.condition.BaseLineConditionField;
import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.condition.ConditionSeparator;
import com.hs.atic.collector.db.condition.ConditionSeparatorFactory;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.BaseLineNfaEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class BaseLineNfaEventRepository
extends RepositoryAdaptor<BaseLineNfaEvent> {
    private static final long YEAR = 365L;
    private static final String NFA_MAIN_TABLE_NAME = "ATIC_BASELINE_NFA_DATA";
    private static final String NFA_DETAIL_TABLE_NAME = "ATIC_BASELINE_NFA_DETAIL";
    private static final String INSERT_MAIN_SQL = "INSERT INTO ATIC_BASELINE_NFA_DATA(PKID,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID,SYN_PPS,SYN_KBPS,ACK_PPS,ACK_KBPS,FINRST_PPS,FINRST_KBPS,TCPFRAG_PPS,TCPFRAG_KBPS,TCP_PPS,TCP_KBPS,UDP_PPS,UDP_KBPS,UDPFRAG_PPS,UDPFRAG_KBPS,ICMP_PPS,ICMP_KBPS,OTHER_PPS,OTHER_KBPS,HTTP_PPS,HTTP_KBPS,HTTPS_PPS,HTTPS_KBPS,DNS_REQUSET_PPS,DNS_REQUSET_KBPS,DNS_REPLY_PPS,DNS_REPLY_KBPS,SIP_INVITE_PPS,SIP_INVITE_KBPS,TOTAL_PPS,TOTAL_KBPS) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_MAIN_SQL = "UPDATE ATIC_BASELINE_NFA_DATA SET SYN_PPS = ?,SYN_KBPS = ?,ACK_PPS = ?,ACK_KBPS = ?,FINRST_PPS = ?,FINRST_KBPS = ?,TCPFRAG_PPS = ?,TCPFRAG_KBPS = ?,TCP_PPS = ?,TCP_KBPS = ?,UDP_PPS = ?,UDP_KBPS = ?,UDPFRAG_PPS = ?,UDPFRAG_KBPS = ?,ICMP_PPS = ?,ICMP_KBPS = ?,OTHER_PPS = ?,OTHER_KBPS = ?,HTTP_PPS = ?,HTTP_KBPS = ?,HTTPS_PPS = ?,HTTPS_KBPS = ?,DNS_REQUSET_PPS = ?,DNS_REQUSET_KBPS = ?,DNS_REPLY_PPS = ?,DNS_REPLY_KBPS = ?,SIP_INVITE_PPS = ?,SIP_INVITE_KBPS = ?,TOTAL_PPS = ?,TOTAL_KBPS = ? WHERE PKID = ? AND DEVICE_TYPE = ? AND DEVICE_IP = ? AND DIRECTION = ? AND ZONE_ID  = ? AND BIZ_ID = ?";
    private static final String INSERT_DETAIL_SQL = "INSERT INTO ATIC_BASELINE_NFA_DETAIL(PKID,LOG_TIME,DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID,SYN_PPS,SYN_KBPS,ACK_PPS,ACK_KBPS,FINRST_PPS,FINRST_KBPS,TCPFRAG_PPS,TCPFRAG_KBPS,TCP_PPS,TCP_KBPS,UDP_PPS,UDP_KBPS,UDPFRAG_PPS,UDPFRAG_KBPS,ICMP_PPS,ICMP_KBPS,OTHER_PPS,OTHER_KBPS,HTTP_PPS,HTTP_KBPS,HTTPS_PPS,HTTPS_KBPS,DNS_REQUSET_PPS,DNS_REQUSET_KBPS,DNS_REPLY_PPS,DNS_REPLY_KBPS,SIP_INVITE_PPS,SIP_INVITE_KBPS,TOTAL_PPS,TOTAL_KBPS,IS_ALERT) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_DETAIL_SQL = "UPDATE ATIC_BASELINE_NFA_DETAIL SET SYN_PPS = ?,SYN_KBPS = ?,ACK_PPS = ?,ACK_KBPS = ?,FINRST_PPS = ?,FINRST_KBPS = ?,TCPFRAG_PPS = ?,TCPFRAG_KBPS = ?,TCP_PPS = ?,TCP_KBPS = ?,UDP_PPS = ?,UDP_KBPS = ?,UDPFRAG_PPS = ?,UDPFRAG_KBPS = ?,ICMP_PPS = ?,ICMP_KBPS = ?,OTHER_PPS = ?,OTHER_KBPS = ?,HTTP_PPS = ?,HTTP_KBPS = ?,HTTPS_PPS = ?,HTTPS_KBPS = ?,DNS_REQUSET_PPS = ?,DNS_REQUSET_KBPS = ?,DNS_REPLY_PPS = ?,DNS_REPLY_KBPS = ?,SIP_INVITE_PPS = ?,SIP_INVITE_KBPS = ?,TOTAL_PPS = ?,TOTAL_KBPS = ?,IS_ALERT = ? WHERE PKID = ? AND LOG_TIME = ? AND DEVICE_TYPE = ? AND DEVICE_IP = ? AND DIRECTION = ? AND ZONE_ID  = ? AND BIZ_ID = ?";

    @Override
    public void deleteObject(Condition condition) {
        this.deleteObjectByJdbc(condition, NFA_MAIN_TABLE_NAME);
        Long currentTimeMillis = System.currentTimeMillis();
        Long yearTimeMillis = 31536000L;
        ConditionClause idCondition = new ConditionClause();
        idCondition.setField(new BaseLineConditionField("logTime"));
        ConditionSeparator separator = ConditionSeparatorFactory.getInstance().lessThan();
        idCondition.setSeparator(separator);
        idCondition.setValue(currentTimeMillis / 1000L - yearTimeMillis);
        idCondition.addValueList(idCondition.getValue());
        ConditionClause conditionCla = idCondition;
        this.deleteObjectByJdbc(conditionCla, NFA_DETAIL_TABLE_NAME);
    }

    @Override
    public void createObjects(List<BaseLineNfaEvent> objs) {
        if (!objs.isEmpty()) {
            if (objs.get(0).isIsHourEvent()) {
                this.createDetailObjects(objs);
            } else {
                this.createMainObjects(objs);
            }
        }
    }

    @Override
    public void updateObjects(List<BaseLineNfaEvent> objs) {
        if (!objs.isEmpty()) {
            if (objs.get(0).isIsHourEvent()) {
                this.updateDetailObjects(objs);
            } else {
                this.updateMainObjects(objs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMainObjects(List<BaseLineNfaEvent> objs) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(INSERT_MAIN_SQL);
            int paramIndex = 1;
            for (BaseLineNfaEvent e : objs) {
                paramIndex = 1;
                ps.setLong(paramIndex++, e.getPkid());
                ps.setString(paramIndex++, e.getDeviceIp());
                ps.setLong(paramIndex++, e.getDirection());
                ps.setLong(paramIndex++, e.getDeviceType());
                ps.setLong(paramIndex++, e.getZoneId());
                ps.setLong(paramIndex++, e.getBizId());
                this.setProtocolFlow(e, ps, paramIndex);
                ps.addBatch();
            }
            ps.executeBatch();
            for (BaseLineNfaEvent e : objs) {
                e.setSaved(true);
            }
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"createObjects error!!", (Throwable)e);
            }
            catch (Throwable throwable) {
                BaseLineNfaEventRepository.freeDbResource(con, ps);
                throw throwable;
            }
            BaseLineNfaEventRepository.freeDbResource(con, ps);
        }
        BaseLineNfaEventRepository.freeDbResource(con, ps);
    }

    private int setProtocolFlow(BaseLineNfaEvent e, PreparedStatement ps, int paramIndex) throws SQLException {
        ps.setLong(paramIndex++, e.getSynPps());
        ps.setLong(paramIndex++, e.getSynKbps());
        ps.setLong(paramIndex++, e.getAckPps());
        ps.setLong(paramIndex++, e.getAckKbps());
        ps.setLong(paramIndex++, e.getFinRstPps());
        ps.setLong(paramIndex++, e.getFinRstKbps());
        ps.setLong(paramIndex++, e.getTcpFragPps());
        ps.setLong(paramIndex++, e.getTcpFragKbps());
        ps.setLong(paramIndex++, e.getTcpPps());
        ps.setLong(paramIndex++, e.getTcpKbps());
        ps.setLong(paramIndex++, e.getUdpPps());
        ps.setLong(paramIndex++, e.getUdpKbps());
        ps.setLong(paramIndex++, e.getUdpFragPps());
        ps.setLong(paramIndex++, e.getUdpFragKbps());
        ps.setLong(paramIndex++, e.getIcmpPps());
        ps.setLong(paramIndex++, e.getIcmpKbps());
        ps.setLong(paramIndex++, e.getOtherPps());
        ps.setLong(paramIndex++, e.getOtherKbps());
        ps.setLong(paramIndex++, e.getHttpPps());
        ps.setLong(paramIndex++, e.getHttpKbps());
        ps.setLong(paramIndex++, e.getHttpsPps());
        ps.setLong(paramIndex++, e.getHttpsKbps());
        ps.setLong(paramIndex++, e.getDnsRequestPps());
        ps.setLong(paramIndex++, e.getDnsRequestKbps());
        ps.setLong(paramIndex++, e.getDnsReplyPps());
        ps.setLong(paramIndex++, e.getDnsReplyKbps());
        ps.setLong(paramIndex++, e.getSipInvitePps());
        ps.setLong(paramIndex++, e.getSipInviteKbps());
        ps.setLong(paramIndex++, e.getTotalPps());
        ps.setLong(paramIndex++, e.getTotalKbps());
        return paramIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDetailObjects(List<BaseLineNfaEvent> objs) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DBConnPool.getConnection();
            ps = con.prepareStatement(INSERT_DETAIL_SQL);
            int paramIndex = 1;
            for (BaseLineNfaEvent e : objs) {
                paramIndex = 1;
                ps.setLong(paramIndex++, e.getPkid());
                ps.setLong(paramIndex++, e.getLogTime() / 1000L);
                ps.setString(paramIndex++, e.getDeviceIp());
                ps.setLong(paramIndex++, e.getDirection());
                ps.setLong(paramIndex++, e.getDeviceType());
                ps.setLong(paramIndex++, e.getZoneId());
                ps.setLong(paramIndex++, e.getBizId());
                paramIndex = this.setProtocolFlow(e, ps, paramIndex);
                ps.setBoolean(paramIndex++, e.isAlert());
                ps.addBatch();
            }
            ps.executeBatch();
            for (BaseLineNfaEvent e : objs) {
                e.setSaved(true);
            }
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"createObjects error!!", (Throwable)e);
            }
            catch (Throwable throwable) {
                BaseLineNfaEventRepository.freeDbResource(con, ps);
                throw throwable;
            }
            BaseLineNfaEventRepository.freeDbResource(con, ps);
        }
        BaseLineNfaEventRepository.freeDbResource(con, ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMainObjects(List<BaseLineNfaEvent> objs) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DBConnPool.getConnection();
            ps = con.prepareStatement(UPDATE_MAIN_SQL);
            int paramIndex = 1;
            for (BaseLineNfaEvent e : objs) {
                paramIndex = 1;
                paramIndex = this.setProtocolFlow(e, ps, paramIndex);
                ps.setLong(paramIndex++, e.getPkid());
                ps.setLong(paramIndex++, e.getDeviceType());
                ps.setString(paramIndex++, e.getDeviceIp());
                ps.setLong(paramIndex++, e.getDirection());
                ps.setLong(paramIndex++, e.getZoneId());
                ps.setLong(paramIndex++, e.getBizId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"updateObjects error!!", (Throwable)e);
            }
            catch (Throwable throwable) {
                BaseLineNfaEventRepository.freeDbResource(con, ps);
                throw throwable;
            }
            BaseLineNfaEventRepository.freeDbResource(con, ps);
        }
        BaseLineNfaEventRepository.freeDbResource(con, ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDetailObjects(List<BaseLineNfaEvent> objs) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DBConnPool.getConnection();
            ps = con.prepareStatement(UPDATE_DETAIL_SQL);
            int paramIndex = 1;
            for (BaseLineNfaEvent e : objs) {
                paramIndex = 1;
                paramIndex = this.setProtocolFlow(e, ps, paramIndex);
                ps.setBoolean(paramIndex++, e.isAlert());
                ps.setLong(paramIndex++, e.getPkid());
                ps.setLong(paramIndex++, e.getLogTime() / 1000L);
                ps.setLong(paramIndex++, e.getDeviceType());
                ps.setString(paramIndex++, e.getDeviceIp());
                ps.setLong(paramIndex++, e.getDirection());
                ps.setLong(paramIndex++, e.getZoneId());
                ps.setLong(paramIndex++, e.getBizId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"updateObjects error!!", (Throwable)e);
            }
            catch (Throwable throwable) {
                BaseLineNfaEventRepository.freeDbResource(con, ps);
                throw throwable;
            }
            BaseLineNfaEventRepository.freeDbResource(con, ps);
        }
        BaseLineNfaEventRepository.freeDbResource(con, ps);
    }
}

