/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.event.EventFileRepository;
import com.hs.atic.collector.entity.event.DevTotalFlowEvent;

public class DevTotalFlowRepository
extends EventFileRepository<DevTotalFlowEvent> {
    private static final String MIN_DEV_SUM_TABLE = "ATIC_MIN_DEV_FLOW_SUM";
    private static final String MIN_DEV_SUM_DROP_TABLE = "ATIC_MIN_DEV_FLOW_SUM_DROP";
    private static final String MIN_DEV_SUM_MAX_TABLE = "ATIC_MIN_DEV_FLOW_SUM_MAX";
    private static final String MIN_DEV_SUM_DROP_MAX_TABLE = "ATIC_MIN_DEV_FLOW_SUM_DROP_MAX";
    private static final String DEV_SUM_TABLE = "ATIC_DEV_FLOW_SUM";
    private static final String DEV_SUM_H_TABLE = "ATIC_DEV_FLOW_SUM_H ";
    private static final String DEV_SUM_MAX_H_TABLE = "ATIC_DEV_FLOW_SUM_MAX_H ";
    private static final String DEV_DROP_SUM_TABLE = "ATIC_DEV_FLOW_SUM_DROP";
    private static final String DEV_DROP_SUM_H_TABLE = "ATIC_DEV_FLOW_SUM_DROP_H ";
    private static final String DEV_DROP_SUM_MAX_H_TABLE = "ATIC_DEV_FLOW_SUM_DROP_MAX_H ";
    private static final String DEV_SUM_TABLE_MAX = "ATIC_DEV_FLOW_SUM_MAX";
    private static final String DEV_DROP_SUM_TABLE_MAX = "ATIC_DEV_FLOW_SUM_DROP_MAX";
    private static final String MIN_DEV_SUM_FOWWARD_MAX_TABLE = "ATIC_MIN_DEV_FLOW_SUM_FORWARD_MAX";
    private static final String DEV_SUM_FOWWARD_MAX_TABLE = "ATIC_DEV_FLOW_SUM_FORWARD_MAX";
    private static final String DEV_SUM_FOWWARD_MAX_H_TABLE = "ATIC_DEV_FLOW_SUM_FORWARD_MAX_H";

    @Override
    protected String getTableName(DevTotalFlowEvent o) {
        if (o.isIsDropFlow()) {
            if (o.isIsMinSumEvent()) {
                if (o.isIsMaxEvent()) {
                    return MIN_DEV_SUM_DROP_MAX_TABLE;
                }
                return MIN_DEV_SUM_DROP_TABLE;
            }
            if (o.isIsHourEvent()) {
                if (o.isIsMaxEvent()) {
                    return DEV_DROP_SUM_MAX_H_TABLE;
                }
                return DEV_DROP_SUM_H_TABLE;
            }
            if (o.isIsMaxEvent()) {
                return DEV_DROP_SUM_TABLE_MAX;
            }
            return DEV_DROP_SUM_TABLE;
        }
        if (o.isIsForwardFlow()) {
            if (o.isIsMinSumEvent()) {
                return MIN_DEV_SUM_FOWWARD_MAX_TABLE;
            }
            if (o.isIsHourEvent()) {
                return DEV_SUM_FOWWARD_MAX_H_TABLE;
            }
            return DEV_SUM_FOWWARD_MAX_TABLE;
        }
        if (o.isIsMinSumEvent()) {
            if (o.isIsMaxEvent()) {
                return MIN_DEV_SUM_MAX_TABLE;
            }
            return MIN_DEV_SUM_TABLE;
        }
        if (o.isIsHourEvent()) {
            if (o.isIsMaxEvent()) {
                return DEV_SUM_MAX_H_TABLE;
            }
            return DEV_SUM_H_TABLE;
        }
        if (o.isIsMaxEvent()) {
            return DEV_SUM_TABLE_MAX;
        }
        return DEV_SUM_TABLE;
    }

    @Override
    protected String getDbString(DevTotalFlowEvent event) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(event.getTotalPps());
        buffer.append(";");
        buffer.append(event.getTotalKbps());
        buffer.append(";");
        buffer.append(event.getTcpPps());
        buffer.append(";");
        buffer.append(event.getTcpKbps());
        buffer.append(";");
        buffer.append(event.getUdpPps());
        buffer.append(";");
        buffer.append(event.getUdpKbps());
        buffer.append(";");
        buffer.append(event.getIcmpPps());
        buffer.append(";");
        buffer.append(event.getIcmpKbps());
        buffer.append(";");
        buffer.append(event.getOtherPps());
        buffer.append(";");
        buffer.append(event.getOtherKbps());
        if (!event.isIsForwardFlow()) {
            if (event.isIsMaxEvent() && !event.isIsDropFlow()) {
                buffer.append(";");
                buffer.append(event.getTcpIncreaseCon());
                buffer.append(";");
                buffer.append(event.getTcpConcurCon());
            }
            if (event.isIsDropFlow()) {
                buffer.append(";");
                buffer.append(event.getAllReboundPps());
                buffer.append(";");
                buffer.append(event.getAllReboundKbps());
                buffer.append(";");
                buffer.append(event.getTcpReboundPps());
                buffer.append(";");
                buffer.append(event.getTcpReboundKbps());
                buffer.append(";");
                buffer.append(event.getUdpReboundPps());
                buffer.append(";");
                buffer.append(event.getUdpReboundKbps());
            }
        }
        return buffer.toString();
    }
}

