/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.event.DnsRequestType2Str;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.DnsStatisEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DnsStatisEventRepository
extends RepositoryAdaptor<DnsStatisEvent> {
    private static final String DNS_CACHE_INSERT_SQL = " (LOG_TIME, DEVICE_IP ,DEVICE_TYPE,ZONE_ID,BIZ_ID,DNS_ID,DNS_NAME,REQUEST_TYPE,REQUEST_PPS,REQUEST_KBPS) Values(?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_PREFIX = "INSERT INTO ";
    private static final String STATIC_CACHE_TABLE_NAME = "ATIC_STATIC_DNS_CACHE";
    private static final String STATIC_CACHE_TABLE_NAME_H = "ATIC_STATIC_DNS_CACHE_H";
    private List<DnsStatisEvent> dnsStatisList = new ArrayList<DnsStatisEvent>();
    private List<DnsStatisEvent> dnsStatisHourList = new ArrayList<DnsStatisEvent>();

    @Override
    public void createObjects(List<DnsStatisEvent> eventList) {
        this.dnsStatisList.clear();
        this.dnsStatisHourList.clear();
        this.dividEvents(eventList);
        if (!this.dnsStatisList.isEmpty()) {
            this.createDnsCacheBatch(this.dnsStatisList, STATIC_CACHE_TABLE_NAME);
        }
        if (!this.dnsStatisHourList.isEmpty()) {
            this.createDnsCacheBatch(this.dnsStatisHourList, STATIC_CACHE_TABLE_NAME_H);
        }
    }

    private void dividEvents(List<DnsStatisEvent> eventList) {
        if (!eventList.isEmpty()) {
            for (DnsStatisEvent each : eventList) {
                if (each.isIsHourEvent()) {
                    this.dnsStatisHourList.add(each);
                    continue;
                }
                this.dnsStatisList.add(each);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDnsCacheBatch(List<DnsStatisEvent> dnsCacheList, String tableName) {
        Connection con = null;
        PreparedStatement insert = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            insert = con.prepareStatement(INSERT_PREFIX + tableName + DNS_CACHE_INSERT_SQL);
            for (DnsStatisEvent each : dnsCacheList) {
                insert.setLong(1, each.getLogTime() / 1000L);
                insert.setString(2, each.getDeviceIp());
                insert.setInt(3, each.getDeviceType());
                insert.setLong(4, each.getZoneId());
                insert.setLong(5, each.getBizId());
                insert.setLong(6, each.getDnsId());
                insert.setString(7, each.getDnsName());
                insert.setString(8, DnsRequestType2Str.int2Str(each.getRequestType()));
                insert.setLong(9, each.getRequestPps());
                insert.setLong(10, each.getRequestKbps());
                insert.addBatch();
            }
            insert.executeBatch();
            con.commit();
            DnsStatisEventRepository.freeDbResource(con, insert);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"insert Dns Static cache to DB error", (Throwable)e);
        }
        finally {
            DnsStatisEventRepository.freeDbResource(con, insert);
        }
    }
}

