/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.DynamicBaseLineTask;
import com.hs.atic.collector.entity.log.DynamicBaseLineData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DynamicBaselineRepository
extends RepositoryAdaptor<DynamicBaseLineTask> {
    private static final String INSERATIC_ROW_INFO = " (START_TIME,END_TIME,TASK_ID,ZONE_ID,STATUS,TCP_PPS,TCP_FRAG_PPS,TCP_STREAMS,UDP_PPS,UDP_FRAG_PPS,ICMP_PPS,OTHER_PPS,SYN_PPS,SYN_ACK_PPS,ACK_PPS,FIN_RST_PPS,HTTPS,HTTP_GET,HTTP_POST,DNS_QUERY,DNS_REPLY,SIP,DST_URL,INCREASE_RATE,CURRENT_CONNECTIONS) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_ROW_INFO = "STATUS= ?,TCP_PPS= ?,TCP_FRAG_PPS= ?,TCP_STREAMS=?,UDP_PPS=?,UDP_FRAG_PPS=?,ICMP_PPS=?,OTHER_PPS=?,SYN_PPS=?,SYN_ACK_PPS=?,ACK_PPS=?,FIN_RST_PPS=?,HTTPS=?,HTTP_GET=?,HTTP_POST=?,DNS_QUERY=?,DNS_REPLY=?,SIP=?,DST_URL=?,INCREASE_RATE=?,CURRENT_CONNECTIONS=? where TASK_ID = ?";
    private static final String TABLE_NAME = "ATIC_BASELINE_DATA";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createObject(DynamicBaseLineTask task) {
        PreparedStatement insert = null;
        Connection con = null;
        try {
            con = this.getConnection();
            insert = con.prepareStatement("insert into ATIC_BASELINE_DATA (START_TIME,END_TIME,TASK_ID,ZONE_ID,STATUS,TCP_PPS,TCP_FRAG_PPS,TCP_STREAMS,UDP_PPS,UDP_FRAG_PPS,ICMP_PPS,OTHER_PPS,SYN_PPS,SYN_ACK_PPS,ACK_PPS,FIN_RST_PPS,HTTPS,HTTP_GET,HTTP_POST,DNS_QUERY,DNS_REPLY,SIP,DST_URL,INCREASE_RATE,CURRENT_CONNECTIONS) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            insert.setLong(1, task.getStartTime() / 1000L);
            insert.setLong(2, task.getEndTime() / 1000L);
            insert.setLong(3, task.getTaskId());
            insert.setLong(4, task.getZoneId());
            insert.setInt(5, task.isIsCancel() ? 0 : 1);
            insert.setLong(6, task.getData().getTcpPps());
            insert.setLong(7, task.getData().getTcpFragMpps());
            insert.setLong(8, task.getData().getTcpStream());
            insert.setLong(9, task.getData().getUdpMbps());
            insert.setLong(10, task.getData().getUdpFragMbps());
            insert.setLong(11, task.getData().getIcmpPps());
            insert.setLong(12, task.getData().getOtherPps());
            insert.setLong(13, task.getData().getSynPps());
            insert.setLong(14, task.getData().getSynAckPps());
            insert.setLong(15, task.getData().getAckPps());
            insert.setLong(16, task.getData().getFinRstPps());
            insert.setLong(17, task.getData().getHttps());
            insert.setLong(18, task.getData().getHttpGet());
            insert.setLong(19, task.getData().getHttpPost());
            insert.setLong(20, task.getData().getDnsQuery());
            insert.setLong(21, task.getData().getDnsReply());
            insert.setLong(22, task.getData().getSipInvite());
            insert.setLong(23, task.getData().getDstUrl());
            insert.setLong(24, task.getData().getCurrentConnections());
            insert.setLong(25, task.getData().getIncreaseRate());
            insert.execute();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)("create base line task to DB error,data is " + task), (Throwable)e);
            }
            catch (Throwable throwable) {
                DynamicBaselineRepository.freeDbResource(con, insert);
                throw throwable;
            }
            DynamicBaselineRepository.freeDbResource(con, insert);
        }
        DynamicBaselineRepository.freeDbResource(con, insert);
    }

    @Override
    public void createObjects(List<DynamicBaseLineTask> tasks) {
        for (DynamicBaseLineTask task : tasks) {
            this.createObject(task);
        }
    }

    @Override
    public void deleteObject(Condition condition) {
        this.deleteObjectByJdbc(condition, TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DynamicBaseLineTask> queryObject(Condition condition) {
        PreparedStatement query = null;
        Connection con = null;
        ResultSet result = null;
        ArrayList<DynamicBaseLineTask> baseLineList = new ArrayList<DynamicBaseLineTask>();
        try {
            con = this.getConnection();
            String sql = "select  *  from ATIC_BASELINE_DATA where " + condition.toSql();
            query = con.prepareStatement(sql);
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> list = conditionClause.getValueList();
                for (int i = 0; i < list.size(); ++i) {
                    query.setObject(i + 1, list.get(i));
                }
            }
            result = query.executeQuery();
            while (result.next()) {
                DynamicBaseLineData baseLineData = new DynamicBaseLineData();
                long taskId = result.getLong(1);
                long zoneId = result.getLong(4);
                baseLineData.setTaskId(taskId);
                baseLineData.setZoneId(zoneId);
                boolean isCancel = result.getInt(5) == 0;
                baseLineData.setTcpFragMpps(result.getLong(7));
                baseLineData.setTcpStream(result.getLong(8));
                baseLineData.setUdpMbps(result.getLong(9));
                baseLineData.setUdpFragKbps(result.getLong(10));
                baseLineData.setIcmpPps(result.getLong(11));
                baseLineData.setOtherPps(result.getLong(12));
                baseLineData.setSynPps(result.getLong(13));
                baseLineData.setSynAckPps(result.getLong(14));
                baseLineData.setAckPps(result.getLong(15));
                baseLineData.setFinRstPps(result.getLong(16));
                baseLineData.setHttps(result.getLong(17));
                baseLineData.setHttpGet(result.getLong(18));
                baseLineData.setHttpPost(result.getLong(19));
                baseLineData.setDnsQuery(result.getLong(20));
                baseLineData.setDnsReply(result.getLong(21));
                baseLineData.setSipInvite(result.getLong(22));
                baseLineData.setDstUrl(result.getInt(23));
                baseLineData.setIncreaseRate(result.getInt(24));
                baseLineData.setCurrentConnections(result.getInt(25));
                DynamicBaseLineTask baseLineTask = new DynamicBaseLineTask(taskId, zoneId);
                baseLineTask.setStartTime(result.getLong(2) * 1000L);
                baseLineTask.setEndTime(result.getLong(3) * 1000L);
                baseLineTask.setData(baseLineData);
                baseLineTask.setSaved(true);
                baseLineTask.setCancel(isCancel);
                baseLineList.add(baseLineTask);
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)("Query base line task  error, sql is " + condition), (Throwable)e);
            }
            catch (Throwable throwable) {
                DynamicBaselineRepository.freeDbResource(con, query, result);
                throw throwable;
            }
            DynamicBaselineRepository.freeDbResource(con, query, result);
        }
        DynamicBaselineRepository.freeDbResource(con, query, result);
        return baseLineList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(DynamicBaseLineTask task) {
        PreparedStatement update = null;
        Connection con = null;
        try {
            con = this.getConnection();
            update = con.prepareStatement("update ATIC_BASELINE_DATA set STATUS= ?,TCP_PPS= ?,TCP_FRAG_PPS= ?,TCP_STREAMS=?,UDP_PPS=?,UDP_FRAG_PPS=?,ICMP_PPS=?,OTHER_PPS=?,SYN_PPS=?,SYN_ACK_PPS=?,ACK_PPS=?,FIN_RST_PPS=?,HTTPS=?,HTTP_GET=?,HTTP_POST=?,DNS_QUERY=?,DNS_REPLY=?,SIP=?,DST_URL=?,INCREASE_RATE=?,CURRENT_CONNECTIONS=? where TASK_ID = ?");
            update.setInt(1, task.isIsCancel() ? 0 : 1);
            update.setLong(2, task.getData().getTcpPps());
            update.setLong(3, task.getData().getTcpFragMpps());
            update.setLong(4, task.getData().getTcpStream());
            update.setLong(5, task.getData().getUdpMbps());
            update.setLong(6, task.getData().getUdpFragMbps());
            update.setLong(7, task.getData().getIcmpPps());
            update.setLong(8, task.getData().getOtherPps());
            update.setLong(9, task.getData().getSynPps());
            update.setLong(10, task.getData().getSynAckPps());
            update.setLong(11, task.getData().getAckPps());
            update.setLong(12, task.getData().getFinRstPps());
            update.setLong(13, task.getData().getHttps());
            update.setLong(14, task.getData().getHttpGet());
            update.setLong(15, task.getData().getHttpPost());
            update.setLong(16, task.getData().getDnsQuery());
            update.setLong(17, task.getData().getDnsReply());
            update.setLong(18, task.getData().getSipInvite());
            update.setLong(19, task.getData().getDstUrl());
            update.setLong(20, task.getData().getIncreaseRate());
            update.setLong(21, task.getData().getCurrentConnections());
            update.setLong(22, task.getData().getTaskId());
            update.executeUpdate();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)("Update dynammic base line  error,data is " + task), (Throwable)e);
            }
            catch (Throwable throwable) {
                DynamicBaselineRepository.freeDbResource(con, update);
                throw throwable;
            }
            DynamicBaselineRepository.freeDbResource(con, update);
        }
        DynamicBaselineRepository.freeDbResource(con, update);
    }

    @Override
    public void updateObjects(List<DynamicBaseLineTask> tasks) {
        for (DynamicBaseLineTask task : tasks) {
            this.updateObject(task);
        }
    }
}

