/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.IpAttackEvent;
import com.hs.atic.collector.util.CommonUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class IpAttackRepository
extends RepositoryAdaptor<IpAttackEvent> {
    private static final String TABLE_NAME = "ATIC_IP_ATTACK_LOG";
    private static final String INSERATIC_ROW_INFO = "(DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID,ZONE_IP,START_TIME_ALERT,START_TIME_ATTACK,END_TIME,DURATION,ATTACK_TIMES,ATTACK_STATUS,DROP_BYTES,DROP_PACKETS,ALERT_TYPES,ATTACK_TYPES,SRC_IP,EXACT_LOG_ID,MAX_DROP_PPS,MAX_DROP_KBPS,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_ROW_INFO = "START_TIME_ATTACK= ?,END_TIME= ?,DURATION=?,ATTACK_TIMES=?,ATTACK_STATUS=?,DROP_BYTES=?,DROP_PACKETS=?,ALERT_TYPES=?,ATTACK_TYPES=?,SRC_IP=?,EXACT_LOG_ID=?,MAX_DROP_PPS=?,MAX_DROP_KBPS=?,IP_MAX_DROP_PPS=?,IP_MAX_DROP_KBPS=?,IP_MAX_IN_PPS=?,IP_MAX_IN_KBPS=?,IP_TCP_NEW_CONN=?,IP_TCP_CONCUR_CONN=? where PKID = ?";

    @Override
    public void createObjects(List<IpAttackEvent> objs) {
        this.createIpAttackEvents(objs);
    }

    @Override
    public List<IpAttackEvent> queryObject(Condition condition) {
        Calendar calendar = Calendar.getInstance();
        int yearNum = calendar.get(1);
        calendar.set(1, yearNum - 1);
        ArrayList<IpAttackEvent> events = new ArrayList<IpAttackEvent>();
        events.addAll(this.retreiveIpAttackEvents(condition));
        LOGGER.debug((Object)("after query , sql is " + condition.toSql() + " the result is " + events));
        return events;
    }

    @Override
    public void updateObjects(List<IpAttackEvent> objs) {
        if (null != objs && !objs.isEmpty()) {
            this.updateExceptionEvents(objs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIpAttackEvents(List<IpAttackEvent> events) {
        if (!events.isEmpty()) {
            PreparedStatement insert = null;
            Connection con = null;
            try {
                con = this.getConnection();
                insert = con.prepareStatement("insert into ATIC_IP_ATTACK_LOG(DEVICE_IP,DIRECTION,DEVICE_TYPE,ZONE_ID,BIZ_ID,ZONE_IP,START_TIME_ALERT,START_TIME_ATTACK,END_TIME,DURATION,ATTACK_TIMES,ATTACK_STATUS,DROP_BYTES,DROP_PACKETS,ALERT_TYPES,ATTACK_TYPES,SRC_IP,EXACT_LOG_ID,MAX_DROP_PPS,MAX_DROP_KBPS,IP_MAX_DROP_PPS,IP_MAX_DROP_KBPS,IP_MAX_IN_PPS,IP_MAX_IN_KBPS,IP_TCP_NEW_CONN,IP_TCP_CONCUR_CONN) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
                for (IpAttackEvent each : events) {
                    this.doInsertIpAttack(insert, each);
                }
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"create ipAttacks to DB error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IpAttackRepository.freeDbResource(con, insert);
                    throw throwable;
                }
                IpAttackRepository.freeDbResource(con, insert);
            }
            IpAttackRepository.freeDbResource(con, insert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsertIpAttack(PreparedStatement insert, IpAttackEvent each) {
        ResultSet result = null;
        try {
            insert.setString(1, each.getDeviceIp());
            insert.setInt(2, each.getDirection());
            insert.setLong(3, each.getDeviceType());
            insert.setLong(4, each.getZoneId());
            insert.setLong(5, each.getBizId());
            insert.setString(6, each.getZoneIp());
            insert.setLong(7, each.getAlertStartTime() / 1000L);
            insert.setLong(8, each.getAttackStartTime() / 1000L);
            insert.setLong(9, (each.getAlertEndTime() > each.getAttackEndTime() ? each.getAlertEndTime() : each.getAttackEndTime()) / 1000L);
            insert.setLong(10, each.getDuration());
            insert.setLong(11, each.getAttackCount());
            insert.setByte(12, (byte)each.getCurrentState());
            insert.setLong(13, each.getDropKbits());
            insert.setLong(14, each.getDropPkgs());
            insert.setString(15, this.getAttackTypeString(each.getAlertedTypes()));
            insert.setString(16, this.getAttackTypeString(each.getAttackedTypes()));
            insert.setString(17, CommonUtil.getIpString(each.getAttackers(), 5000));
            insert.setString(18, each.getExactLogIds());
            insert.setLong(19, each.getAttackPeakPpsOrQps());
            insert.setLong(20, each.getAttackPeakKbps());
            insert.setLong(21, each.getIpAttackPeakPps());
            insert.setLong(22, each.getIpAttackPeakKbps());
            insert.setLong(23, each.getIpInPeakPps());
            insert.setLong(24, each.getIpInPeakKbps());
            insert.setLong(25, each.getTcpNewConnNum());
            insert.setLong(26, each.getTcpCurConnNum());
            insert.execute();
            result = insert.getGeneratedKeys();
            while (result.next()) {
                each.setAbnormalPkId(result.getLong(1));
            }
            IpAttackRepository.freeDbResource(null, null, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"create IPAttackEvents  to DB error", (Throwable)e);
        }
        finally {
            IpAttackRepository.freeDbResource(null, null, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IpAttackEvent> queryEvents(Condition condition, boolean isFromClean) {
        ArrayList<IpAttackEvent> pkId2;
        ArrayList<IpAttackEvent> list = new ArrayList<IpAttackEvent>();
        PreparedStatement query = null;
        Connection con = null;
        ResultSet result = null;
        String sql = "select * from ATIC_IP_ATTACK_LOG where " + condition.toSql();
        try {
            con = this.getConnection();
            query = con.prepareStatement(sql);
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> conlist = conditionClause.getValueList();
                for (int i = 0; i < conlist.size(); ++i) {
                    query.setObject(i + 1, conlist.get(i));
                }
            }
            result = query.executeQuery();
            while (result.next()) {
                long pkId2 = result.getLong(1);
                String deviceIp = result.getString(2);
                long zoneId = result.getLong(3);
                String zoneIp = result.getString(4);
                long startTimeAlert = result.getLong(5) * 1000L;
                long startTimeAttack = result.getLong(6) * 1000L;
                long endTime = result.getLong(7) * 1000L;
                long attackCount = result.getInt(9);
                int attackStatus = result.getInt(10);
                long dropBytes = result.getLong(11);
                long dropPackgets = result.getInt(12);
                String alertTypes = result.getString(13);
                String attackTypes = result.getString(14);
                Set<String> attackers = CommonUtil.transIpString2Set(result.getString(15));
                EventIdentifier identifier = new EventIdentifier();
                IpAttackEvent event = new IpAttackEvent(identifier);
                identifier.setDeviceIp(deviceIp);
                identifier.setZoneIp(zoneIp);
                identifier.setZoneId(zoneId);
                identifier.setLogTime(startTimeAlert);
                event.setEverAlerted(true);
                if (isFromClean) {
                    identifier.setDeviceType(0);
                    if (attackCount > 0L) {
                        event.setEverAttacked(true);
                        event.setAttackStartTime(startTimeAttack);
                    }
                } else {
                    identifier.setDeviceType(1);
                }
                event.setAlertStartTime(startTimeAlert);
                event.setAlertEndTime(endTime);
                event.setAttackers(attackers);
                event.setCurrentState(attackStatus);
                event.setAttackCount(attackCount);
                event.setDropPkgs(dropPackgets);
                event.setDropKbits(dropBytes);
                event.setAbnormalPkId(pkId2);
                event.setAlertedTypes(this.getAttackTypesFromString(alertTypes));
                event.setAttackedTypes(this.getAttackTypesFromString(attackTypes));
                list.add(event);
            }
            pkId2 = list;
        }
        catch (SQLException e) {
            ArrayList<IpAttackEvent> arrayList;
            try {
                LOGGER.error((Object)("query ipAttacks to DB error,sql is " + sql), (Throwable)e);
                arrayList = new ArrayList<IpAttackEvent>();
            }
            catch (Throwable throwable) {
                IpAttackRepository.freeDbResource(con, query, result);
                throw throwable;
            }
            IpAttackRepository.freeDbResource(con, query, result);
            return arrayList;
        }
        IpAttackRepository.freeDbResource(con, query, result);
        return pkId2;
    }

    private Collection<IpAttackEvent> retreiveIpAttackEvents(Condition condition) {
        ArrayList<IpAttackEvent> events = new ArrayList<IpAttackEvent>();
        events.addAll(this.queryEvents(condition, true));
        events.addAll(this.queryEvents(condition, false));
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExceptionEvents(List<IpAttackEvent> events) {
        Connection con = null;
        PreparedStatement insert = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            insert = con.prepareStatement("update ATIC_IP_ATTACK_LOG set START_TIME_ATTACK= ?,END_TIME= ?,DURATION=?,ATTACK_TIMES=?,ATTACK_STATUS=?,DROP_BYTES=?,DROP_PACKETS=?,ALERT_TYPES=?,ATTACK_TYPES=?,SRC_IP=?,EXACT_LOG_ID=?,MAX_DROP_PPS=?,MAX_DROP_KBPS=?,IP_MAX_DROP_PPS=?,IP_MAX_DROP_KBPS=?,IP_MAX_IN_PPS=?,IP_MAX_IN_KBPS=?,IP_TCP_NEW_CONN=?,IP_TCP_CONCUR_CONN=? where PKID = ?");
            for (IpAttackEvent each : events) {
                insert.setLong(1, each.getAttackStartTime() / 1000L);
                insert.setLong(2, (each.getAlertEndTime() > each.getAttackEndTime() ? each.getAlertEndTime() : each.getAttackEndTime()) / 1000L);
                insert.setLong(3, each.getDuration());
                insert.setLong(4, each.getAttackCount());
                insert.setByte(5, (byte)each.getCurrentState());
                insert.setLong(6, each.getDropKbits());
                insert.setLong(7, each.getDropPkgs());
                insert.setString(8, this.getAttackTypeString(each.getAlertedTypes()));
                insert.setString(9, this.getAttackTypeString(each.getAttackedTypes()));
                insert.setString(10, CommonUtil.getIpString(each.getAttackers(), 5000));
                insert.setString(11, each.getExactLogIds());
                insert.setLong(12, each.getAttackPeakPpsOrQps());
                insert.setLong(13, each.getAttackPeakKbps());
                insert.setLong(14, each.getIpAttackPeakPps());
                insert.setLong(15, each.getIpAttackPeakKbps());
                insert.setLong(16, each.getIpInPeakPps());
                insert.setLong(17, each.getIpInPeakKbps());
                insert.setLong(18, each.getTcpNewConnNum());
                insert.setLong(19, each.getTcpCurConnNum());
                insert.setLong(20, each.getAbnormalPkId());
                insert.addBatch();
            }
            insert.executeBatch();
            con.commit();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"update IpAttackEvents  to DB error", (Throwable)e);
            }
            catch (Throwable throwable) {
                IpAttackRepository.freeDbResource(con, insert);
                throw throwable;
            }
            IpAttackRepository.freeDbResource(con, insert);
        }
        IpAttackRepository.freeDbResource(con, insert);
    }
}

