/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event;

import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ZoneBlackListEvent;
import com.hs.atic.collector.util.LogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ZoneBlackEventRepository
extends RepositoryAdaptor<ZoneBlackListEvent> {
    private static final String TABLE_NAME = "ATIC_ZONE_BLACKLIST";
    private static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final String INSERATIC_ROW_INFO = "INSERT INTO ATIC_ZONE_BLACKLIST(  DEVICE_IP,ZONE_ID,BIZ_ID,ZONE_IP,START_TIME,BLACK_IP,PROTOCOL,PORT,BLACK_TYPE,STATUS,ENABLE ) values(?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_ROW_INFO = "UPDATE ATIC_ZONE_BLACKLIST SET  STATUS= ?,ENABLE=?  where DEVICE_IP=? && ZONE_ID=? && BIZ_ID=? && BLACK_IP=? && PROTOCOL=? && PORT=? && BLACK_TYPE=? ";
    private static final String QUERY_INFO = "SELECT * FROM ATIC_ZONE_BLACKLIST WHERE ";
    private static final String DELETE_INFO = "DELETE  FROM ATIC_ZONE_BLACKLIST WHERE ";
    private static final String DELETE_LIST_INFO = "DELETE  FROM ATIC_ZONE_BLACKLIST WHERE ZONE_ID=? && BLACK_IP=? && PORT=? && PROTOCOL=? && DEVICE_IP=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObjects(List<ZoneBlackListEvent> objs) {
        if (!objs.isEmpty()) {
            PreparedStatement insert = null;
            Connection con = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                insert = con.prepareStatement(UPDATE_ROW_INFO);
                for (ZoneBlackListEvent each : objs) {
                    insert.setInt(1, each.getStatus());
                    insert.setInt(2, each.getEnable());
                    insert.setString(3, each.getDeviceIp());
                    insert.setLong(4, each.getZoneId());
                    insert.setLong(5, each.getBizId());
                    insert.setString(6, each.getBlackIp());
                    insert.setInt(7, each.getProtocol());
                    insert.setInt(8, each.getPort());
                    insert.setInt(9, each.getBlackListType());
                    insert.addBatch();
                }
                insert.executeBatch();
                con.commit();
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"create zoneBlackEvent to DB error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    ZoneBlackEventRepository.freeDbResource(con, insert);
                    throw throwable;
                }
                ZoneBlackEventRepository.freeDbResource(con, insert);
            }
            ZoneBlackEventRepository.freeDbResource(con, insert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ZoneBlackListEvent> queryObject(Condition condition) {
        PreparedStatement query = null;
        Connection con = null;
        ResultSet resultSet = null;
        ArrayList<ZoneBlackListEvent> result = new ArrayList<ZoneBlackListEvent>();
        try {
            con = this.getConnection();
            query = con.prepareStatement(QUERY_INFO + condition.toSql());
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> list = conditionClause.getValueList();
                for (int i = 0; i < list.size(); ++i) {
                    query.setObject(i + 1, list.get(i));
                }
            }
            resultSet = query.executeQuery();
            while (resultSet.next()) {
                EventIdentifier identifier = new EventIdentifier();
                identifier.setDeviceIp(resultSet.getString("DEVICE_IP"));
                identifier.setZoneId(resultSet.getLong("ZONE_ID"));
                identifier.setBizId(resultSet.getLong("BIZ_ID"));
                identifier.setZoneIp(resultSet.getString("ZONE_IP"));
                identifier.setLogTime(resultSet.getLong("START_TIME") * 1000L);
                identifier.setZoneType();
                ZoneBlackListEvent event = new ZoneBlackListEvent(identifier);
                event.setBlackIp(resultSet.getString("BLACK_IP"));
                event.setProtocol(resultSet.getInt("PROTOCOL"));
                event.setPort(resultSet.getInt("PORT"));
                event.setBlackListType(resultSet.getInt("BLACK_TYPE"));
                event.setStatus(resultSet.getInt("STATUS"));
                event.setEnable(resultSet.getInt("ENABLE"));
                result.add(event);
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)("qeuery DB error" + condition.toSql()), (Throwable)e);
            }
            catch (Throwable throwable) {
                ZoneBlackEventRepository.freeDbResource(con, query, resultSet);
                throw throwable;
            }
            ZoneBlackEventRepository.freeDbResource(con, query, resultSet);
        }
        ZoneBlackEventRepository.freeDbResource(con, query, resultSet);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObject(Condition condition) {
        PreparedStatement delete = null;
        Connection con = null;
        try {
            con = this.getConnection();
            LOGGER.info((Object)("Delete blacklist:" + condition.toSql()));
            delete = con.prepareStatement(DELETE_INFO + condition.toSql());
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> list = conditionClause.getValueList();
                for (int i = 0; i < list.size(); ++i) {
                    delete.setObject(i + 1, list.get(i));
                }
            }
            delete.execute();
            ZoneBlackEventRepository.freeDbResource(con, delete);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delete zoneBlackEvent to DB error", (Throwable)e);
        }
        finally {
            ZoneBlackEventRepository.freeDbResource(con, delete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjectList(List<Condition> conditionList) {
        if (null == conditionList || conditionList.isEmpty()) {
            LOGGER.error((Object)"input conditionList is empty to delete");
            return;
        }
        PreparedStatement delete = null;
        Connection con = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            LOGGER.info((Object)("Delete blacklist size=" + conditionList.size()));
            delete = con.prepareStatement(DELETE_LIST_INFO);
            for (Condition condition : conditionList) {
                if (!(condition instanceof ConditionClause)) continue;
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> list = conditionClause.getValueList();
                for (int i = 0; i < list.size(); ++i) {
                    delete.setObject(i + 1, list.get(i));
                }
                delete.addBatch();
            }
            delete.executeBatch();
            con.commit();
            ZoneBlackEventRepository.freeDbResource(con, delete);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delete zoneBlackEvent to DB error", (Throwable)e);
        }
        finally {
            ZoneBlackEventRepository.freeDbResource(con, delete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createObjects(List<ZoneBlackListEvent> objs) {
        if (!objs.isEmpty()) {
            LOGGER.info((Object)("create dyn blacklist begin, blacklists.size=" + objs.size()));
            PreparedStatement insert = null;
            Connection con = null;
            try {
                con = this.getConnection();
                con.setAutoCommit(false);
                insert = con.prepareStatement(INSERATIC_ROW_INFO);
                for (ZoneBlackListEvent each : objs) {
                    insert.setString(1, each.getDeviceIp());
                    insert.setLong(2, each.getZoneId());
                    insert.setLong(3, each.getBizId());
                    insert.setString(4, each.getZoneIp());
                    insert.setLong(5, each.getLogTime() / 1000L);
                    insert.setString(6, each.getBlackIp());
                    insert.setInt(7, each.getProtocol());
                    insert.setInt(8, each.getPort());
                    insert.setInt(9, each.getBlackListType());
                    insert.setInt(10, each.getStatus());
                    insert.setInt(11, each.getEnable());
                    insert.addBatch();
                }
                insert.executeBatch();
                con.commit();
                LOGGER.info((Object)("create dyn blacklist end, blacklists.size=" + objs.size()));
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)"create zoneBlackEvent to DB error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    ZoneBlackEventRepository.freeDbResource(con, insert);
                    throw throwable;
                }
                ZoneBlackEventRepository.freeDbResource(con, insert);
            }
            ZoneBlackEventRepository.freeDbResource(con, insert);
        }
    }
}

