/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.event.hcc;

import com.hs.atic.collector.entity.event.AbnormalEvent;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.ExceptionEvent;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.hcc.HccAttackDataEntity;
import com.hs.atic.rmi.hcc.HccAttackDataService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class HccAttackDataProcess {
    private static final Logger LOGGER = LogManager.getInstance().getRMILog();
    private static final String HCC_ATTACK_DATA_SERVICE = "HccAttackDataService";
    private static HccAttackDataProcess instance;
    private List<HccAttackDataEntity> notifyFailedDatas = new ArrayList<HccAttackDataEntity>();
    private HccAttackDataService hccService;
    private boolean hccEnable = false;

    private HccAttackDataProcess() {
        try {
            this.hccEnable = Boolean.valueOf(EventUtil.getEventConfigProperty("hccEnable"));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"Get hccEnable error");
            return;
        }
        LOGGER.debug((Object)("get hccEnable=" + this.hccEnable));
    }

    public static HccAttackDataProcess getInstance() {
        if (null == instance) {
            LOGGER.debug((Object)"init HccAttackDataProcess");
            instance = new HccAttackDataProcess();
        }
        return instance;
    }

    public void notifyAttackDatas(List<AbnormalEvent> attackedEvents) {
        if (!this.hccEnable) {
            return;
        }
        boolean notifySucess = true;
        if (null != attackedEvents && !attackedEvents.isEmpty()) {
            ArrayList<HccAttackDataEntity> currAttackDatas = new ArrayList<HccAttackDataEntity>();
            for (AbnormalEvent e : attackedEvents) {
                ExceptionEvent event = (ExceptionEvent)e;
                long attackStartTime = event.getAttackStartTime();
                long attackEndTime = event.getAttackEndTime();
                if (attackStartTime == 0L || attackEndTime == 0L) continue;
                currAttackDatas.add(this.transAttackDate(event));
            }
            if (!currAttackDatas.isEmpty()) {
                notifySucess = this.doNotifyAttackDatas(currAttackDatas);
            }
        }
        if (notifySucess && !this.notifyFailedDatas.isEmpty()) {
            List<HccAttackDataEntity> datas = this.notifyFailedDatas;
            this.notifyFailedDatas = new ArrayList<HccAttackDataEntity>();
            this.doNotifyAttackDatas(datas);
        }
    }

    private boolean doNotifyAttackDatas(List<HccAttackDataEntity> attackDatas) {
        if (null != this.getHccService()) {
            try {
                LOGGER.debug((Object)("Start to notify HccAttackDataEntity, the list size=" + attackDatas.size()));
                int i = 0;
                for (HccAttackDataEntity entity : attackDatas) {
                    LOGGER.debug((Object)("The " + i++ + " entiry:" + entity.toString()));
                }
                this.hccService.notifyAttackDatas(attackDatas);
                return true;
            }
            catch (RemoteException e) {
                this.notifyFailedDatas.addAll(attackDatas);
                LOGGER.error((Object)"notifyAttackDatas error", (Throwable)e);
                this.hccService = null;
            }
        } else {
            this.notifyFailedDatas.addAll(attackDatas);
            LOGGER.error((Object)("not notify for getHccService is null. the first attackData=" + attackDatas.get(0).toString()));
        }
        return false;
    }

    private HccAttackDataEntity transAttackDate(ExceptionEvent event) {
        HccAttackDataEntity attackData = new HccAttackDataEntity();
        attackData.setZoneId(event.getZoneId());
        attackData.setAttackIp(event.getZoneIp());
        attackData.setAvgBps(event.getDropKbits() / event.getDuration() * 1000L);
        attackData.setMaxBps(event.getMaxDropKbps() * 1000L);
        attackData.setStartTime(event.getAttackStartTime());
        attackData.setEndTime(event.getAttackEndTime());
        AttackType attackType = event.getAttackType();
        attackData.setAttackType(attackType.getTypeValue());
        int port = attackType.getPort();
        if (0 != port) {
            attackData.setAttackPort(String.valueOf(port));
        }
        return attackData;
    }

    private HccAttackDataService getHccService() {
        if (null == this.hccService) {
            try {
                this.hccService = (HccAttackDataService)CommonUtil.retreiveAticRmiService(HCC_ATTACK_DATA_SERVICE);
            }
            catch (Exception e) {
                LOGGER.error((Object)"get HccAttackDataService failed! ", (Throwable)e);
            }
        }
        return this.hccService;
    }
}

