/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.monitor;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.util.LogManager;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DBSysConf
implements Serializable {
    private static final long serialVersionUID = -6351032236045706644L;
    private static final Logger LOGGER = LogManager.getInstance().getMonitorLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(String sysVar, String sysValue) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        boolean flag = false;
        if (conn != null) {
            try {
                String str = "UPDATE ATIC_SYSTEM_CONF SET SYS_VALUE = ? WHERE SYS_VAR = ?";
                pstmt = conn.prepareStatement(str);
                pstmt.setString(1, sysValue);
                pstmt.setString(2, sysVar);
                pstmt.execute();
                flag = true;
            }
            catch (SQLException e) {
                LOGGER.error((Object)"When excute sql,some errors happened", (Throwable)e);
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"When close prepare statement,some errors happened");
                }
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"When close DB connection,some errors happened");
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String querySysValue(String sysVar) {
        String sysValue = null;
        Connection conn = DBConnPool.getConnection();
        PreparedStatement pstmt = null;
        ResultSet result = null;
        if (conn != null) {
            try {
                String str = "SELECT  SYS_VALUE  From ATIC_SYSTEM_CONF WHERE SYS_VAR  =?";
                pstmt = conn.prepareStatement(str);
                pstmt.setString(1, sysVar);
                result = pstmt.executeQuery();
                if (result.next()) {
                    sysValue = result.getString(1);
                }
                DBSysConf.freeDbResource(conn, pstmt, result);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"When excute sql,some errors happened", (Throwable)e);
            }
            finally {
                DBSysConf.freeDbResource(conn, pstmt, result);
            }
        }
        return sysValue;
    }

    public static void freeDbResource(Connection conn, PreparedStatement pstmt, ResultSet result) {
        try {
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close result,some errors happened");
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close prepare statement,some errors happened");
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            LOGGER.error((Object)"When close DB connection,some errors happened");
        }
    }
}

