/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.pcap;

import com.hs.atic.collector.biz.pcap.PcapIdentifier;
import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.db.pcap.PcapFileInfoRepository;
import com.hs.atic.collector.entity.pcap.CaptureTask;
import com.hs.atic.collector.entity.pcap.GlobalCaptureTask;
import com.hs.atic.collector.entity.pcap.ZoneCaptureTask;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CaptureTaskRepository
extends RepositoryAdaptor<CaptureTask> {
    private static final String PCAP_TABLE_NAME = "ATIC_CAPTURE_TASK";
    private static final String INSERT_INFO = "(PCAP_ID,DEVICE_IP,DEVICE_TYPE,FILE_NAME,PCAP_TYPE,ZONE_ID,REQUIRED_PCAP_NUMBER )values(?,?,?,?,?,?,?)";
    PcapFileInfoRepository pcapFileRepository = new PcapFileInfoRepository();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createObject(CaptureTask task) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("now create capture task to db,task is :" + task.getTaskId()));
        }
        PreparedStatement insert = null;
        Connection con = null;
        try {
            con = this.getConnection();
            String tableName = PCAP_TABLE_NAME;
            insert = con.prepareStatement("insert into " + tableName + INSERT_INFO);
            insert.setLong(1, task.getTaskId());
            insert.setString(2, task.getPcapIdentifier().getPcapDeviceIP());
            insert.setInt(3, task.getPcapIdentifier().getDeviceType());
            insert.setString(4, task.getBaseFileName());
            insert.setInt(5, task.getPcapIdentifier().getType());
            insert.setLong(6, task.getPcapIdentifier().getZoneId());
            insert.setInt(7, task.getRequiredCaptureNum());
            insert.execute();
            CaptureTaskRepository.freeDbResource(con, insert);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"create capture task file  to DB error", (Throwable)e);
        }
        finally {
            CaptureTaskRepository.freeDbResource(con, insert);
        }
    }

    @Override
    public void createObjects(List<CaptureTask> tasks) {
        for (CaptureTask task : tasks) {
            this.createObject(task);
        }
    }

    @Override
    public void deleteObject(Condition condition) {
        this.deleteObjectByJdbc(condition, PCAP_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CaptureTask> queryObject(Condition condition) {
        PreparedStatement query = null;
        Connection con = null;
        ResultSet result = null;
        ArrayList<CaptureTask> captureTaskList = new ArrayList<CaptureTask>();
        try {
            con = this.getConnection();
            String tableName = PCAP_TABLE_NAME;
            query = con.prepareStatement("select *  from " + tableName + " where " + condition.toSql());
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> list = conditionClause.getValueList();
                for (int i = 0; i < list.size(); ++i) {
                    query.setObject(i + 1, list.get(i));
                }
            }
            result = query.executeQuery();
            while (result.next()) {
                Long taskId = result.getLong("PCAP_ID");
                String strDeviceIp = result.getString("DEVICE_IP");
                int deviceType = result.getInt("DEVICE_TYPE");
                String fileName = result.getString("FILE_NAME");
                int pcapType = result.getInt("PCAP_TYPE");
                Long zoneId = result.getLong("ZONE_ID");
                int requiredPcapNum = result.getInt("REQUIRED_PCAP_NUMBER");
                PcapIdentifier pcapIdentifier = new PcapIdentifier(pcapType, strDeviceIp, zoneId);
                pcapIdentifier.setDeviceType(deviceType);
                CaptureTask captureTask = null;
                try {
                    captureTask = pcapIdentifier.isZoneType() ? new ZoneCaptureTask(pcapIdentifier, fileName, taskId) : new GlobalCaptureTask(pcapIdentifier, fileName, taskId);
                    captureTask.setRequiredCaptureNum(requiredPcapNum);
                    captureTask.setFinished(false);
                    captureTaskList.add(captureTask);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"when retrieve task ,error happend,e");
                }
            }
            CaptureTaskRepository.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query capture task file  error", (Throwable)e);
        }
        finally {
            CaptureTaskRepository.freeDbResource(con, query, result);
        }
        this.assembleTasks(captureTaskList);
        return captureTaskList;
    }

    private void assembleTasks(List<CaptureTask> captureTaskList) {
        LOGGER.info((Object)"assembleTasks start");
        if (captureTaskList.size() > 0) {
            this.pcapFileRepository.queryTaskMaxPcapFileIndex(captureTaskList);
        }
        LOGGER.info((Object)"assembleTasks end");
    }
}

