/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.pcap;

import com.hs.atic.collector.biz.pcap.PcapIdentifier;
import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.AttackTypeFactory;
import com.hs.atic.collector.entity.pcap.CaptureTask;
import com.hs.atic.collector.entity.pcap.PcapFileInfo;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class PcapFileInfoRepository
extends RepositoryAdaptor<PcapFileInfo> {
    protected static final String SEPARATOR = ",";
    private static final String PCAP_TABLE_NAME = "ATIC_PCAP_FILE";
    private static final String INSERT_INFO = "(PCAP_ID,DEVICE_IP,DEVICE_TYPE,FILE_NAME,PCAP_TYPE,ZONE_ID,ZONE_IP,STATUS,PCAP_NUMBER,FILE_SIZE,START_TIME,END_TIME,ATTACK_TYPE,PROTOCOL,PORT)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_INFO = "STATUS= ?,PCAP_NUMBER= ?,FILE_SIZE= ?,START_TIME=? ,END_TIME=?  where  FILE_NAME = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createObject(PcapFileInfo pcapFileInfo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("now create capture pcapFileInfo to db,pcapFileInfo is :" + pcapFileInfo.getTaskId()));
        }
        PreparedStatement insert = null;
        Connection con = null;
        ResultSet result = null;
        try {
            con = this.getConnection();
            String tableName = PCAP_TABLE_NAME;
            insert = con.prepareStatement("insert into " + tableName + INSERT_INFO, 1);
            insert.setLong(1, pcapFileInfo.getTaskId());
            insert.setString(2, pcapFileInfo.getIdentifier().getPcapDeviceIP());
            insert.setInt(3, pcapFileInfo.getIdentifier().getDeviceType());
            insert.setString(4, pcapFileInfo.getFileName());
            insert.setInt(5, pcapFileInfo.getIdentifier().getType());
            insert.setLong(6, pcapFileInfo.getIdentifier().getZoneId());
            insert.setString(7, pcapFileInfo.getIdentifier().getZoneIp() == null ? "" : pcapFileInfo.getIdentifier().getZoneIp());
            insert.setInt(8, pcapFileInfo.isIsCompleted() ? 0 : 1);
            insert.setInt(9, pcapFileInfo.getCaptureNumber());
            insert.setLong(10, pcapFileInfo.getFileSize() / 1024L);
            insert.setLong(11, pcapFileInfo.getBeginTime() / 1000L);
            insert.setLong(12, pcapFileInfo.getEndTime() / 1000L);
            AttackType attackType = pcapFileInfo.getAttackType();
            if (null != attackType) {
                insert.setInt(13, attackType.getTypeValue());
                insert.setInt(14, attackType.getProtocol());
                insert.setInt(15, attackType.getPort());
            } else {
                insert.setInt(13, 0);
                insert.setInt(14, 0);
                insert.setInt(15, 0);
            }
            insert.executeUpdate();
            result = insert.getGeneratedKeys();
            while (result.next()) {
                pcapFileInfo.setPcapFilePkId(result.getLong(1));
            }
            PcapFileInfoRepository.freeDbResource(con, insert, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"create capture pcapFileInfo file  to DB error", (Throwable)e);
        }
        finally {
            PcapFileInfoRepository.freeDbResource(con, insert, result);
        }
    }

    @Override
    public void createObjects(List<PcapFileInfo> tasks) {
        for (PcapFileInfo pcapFileInfo : tasks) {
            this.createObject(pcapFileInfo);
        }
    }

    @Override
    public void deleteObject(Condition condition) {
        this.deleteObjectByJdbc(condition, PCAP_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PcapFileInfo> queryObject(Condition condition) {
        PreparedStatement query = null;
        Connection con = null;
        ResultSet result = null;
        ArrayList<PcapFileInfo> fileList = new ArrayList<PcapFileInfo>();
        try {
            con = this.getConnection();
            String tableName = PCAP_TABLE_NAME;
            String sql = "select *  from " + tableName + " where " + condition.toSql();
            query = con.prepareStatement(sql);
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> list = conditionClause.getValueList();
                for (int i = 0; i < list.size(); ++i) {
                    query.setObject(i + 1, list.get(i));
                }
            }
            result = query.executeQuery();
            while (result.next()) {
                Long pkId = result.getLong("PKID");
                Long taskId = result.getLong("PCAP_ID");
                int deviceType = result.getInt("DEVICE_TYPE");
                String strDeviceIp = result.getString("DEVICE_IP");
                String fileName = result.getString("FILE_NAME");
                int pcapType = result.getInt("PCAP_TYPE");
                Long zoneId = result.getLong("ZONE_ID");
                int status = result.getInt("STATUS");
                int pcapNumber = result.getInt("PCAP_NUMBER");
                long fileSize = result.getLong("FILE_SIZE") * 1024L;
                long startTime = result.getLong("START_TIME") * 1000L;
                long endTime = result.getLong("END_TIME") * 1000L;
                int attackTypevalue = result.getInt("ATTACK_TYPE");
                int protocol = result.getInt("PROTOCOL");
                int port = result.getInt("PORT");
                String zoneIp = result.getString("ZONE_IP");
                PcapIdentifier pcapIdentifier = new PcapIdentifier(pcapType, strDeviceIp, zoneId);
                pcapIdentifier.setDeviceType(deviceType);
                pcapIdentifier.setZoneIp(zoneIp);
                try {
                    PcapFileInfo pcapFileInfo = new PcapFileInfo(pcapIdentifier, taskId, fileName);
                    pcapFileInfo.setBeginTime(startTime);
                    pcapFileInfo.setCaptureNumber(pcapNumber);
                    pcapFileInfo.setPcapFilePkId(pkId);
                    pcapFileInfo.setEndTime(endTime);
                    pcapFileInfo.setFileSize(fileSize);
                    pcapFileInfo.setCompleted(status == 0);
                    if (pcapIdentifier.isZoneType()) {
                        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(attackTypevalue, protocol, port);
                        pcapFileInfo.setAttackType(attackType);
                    }
                    fileList.add(pcapFileInfo);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"when retrieve pcapFileInfo ,error happend,e");
                }
            }
            PcapFileInfoRepository.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query capture pcapFileInfo file  error", (Throwable)e);
        }
        finally {
            PcapFileInfoRepository.freeDbResource(con, query, result);
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(PcapFileInfo pcapFileInfo) {
        LOGGER.info((Object)("before write to db ,pcapFileInfo is " + pcapFileInfo.getTaskId()));
        PreparedStatement update = null;
        Connection con = null;
        try {
            con = this.getConnection();
            String tableName = PCAP_TABLE_NAME;
            update = con.prepareStatement("update " + tableName + " set " + UPDATE_INFO);
            update.setInt(1, pcapFileInfo.isIsCompleted() ? 0 : 1);
            update.setInt(2, pcapFileInfo.getCaptureNumber());
            long fileSize = pcapFileInfo.getFileSize() / 1024L;
            update.setLong(3, fileSize > 0L ? fileSize : 1L);
            update.setLong(4, pcapFileInfo.getBeginTime() / 1000L);
            update.setLong(5, pcapFileInfo.getEndTime() / 1000L);
            update.setString(6, pcapFileInfo.getFileName());
            update.executeUpdate();
            LOGGER.info((Object)"update capture pcapFileInfo file  to DB success");
            PcapFileInfoRepository.freeDbResource(con, update);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"update capture pcapFileInfo file  to DB error", (Throwable)e);
        }
        finally {
            PcapFileInfoRepository.freeDbResource(con, update);
        }
    }

    @Override
    public void updateObjects(List<PcapFileInfo> tasks) {
        for (PcapFileInfo pcapFileInfo : tasks) {
            this.updateObject(pcapFileInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryTaskMaxPcapFileIndex(List<CaptureTask> captureTaskList) {
        PreparedStatement query = null;
        Connection con = null;
        ResultSet result = null;
        try {
            con = this.getConnection();
            int completeFlag = 1;
            String sql = "SELECT f.* FROM ATIC_PCAP_FILE f,(SELECT ATTACK_TYPE,DEVICE_IP,DEVICE_TYPE,MAX(START_TIME) START_TIME FROM ATIC_PCAP_FILE GROUP BY ATTACK_TYPE,DEVICE_IP,DEVICE_TYPE) d WHERE f.ATTACK_TYPE = d.ATTACK_TYPE AND f.DEVICE_IP = d.DEVICE_IP AND f.DEVICE_TYPE = d.DEVICE_TYPE AND f.start_time = d.START_TIME UNION SELECT * FROM ATIC_PCAP_FILE WHERE STATUS = ?";
            query = con.prepareStatement(sql);
            query.setInt(1, completeFlag);
            result = query.executeQuery();
            for (CaptureTask task : captureTaskList) {
                Long taskId = task.getTaskId();
                int taskDeviceType = task.getPcapIdentifier().getDeviceType();
                result.beforeFirst();
                ArrayList<PcapFileInfo> fileList = new ArrayList<PcapFileInfo>();
                while (result.next()) {
                    Long pkId = result.getLong("PKID");
                    Long pcapId = result.getLong("PCAP_ID");
                    int deviceType = result.getInt("DEVICE_TYPE");
                    if (taskId.longValue() != pcapId.longValue() || taskDeviceType != deviceType) continue;
                    String strDeviceIp = result.getString("DEVICE_IP");
                    String fileName = result.getString("FILE_NAME");
                    int pcapType = result.getInt("PCAP_TYPE");
                    Long zoneId = result.getLong("ZONE_ID");
                    int status = result.getInt("STATUS");
                    int pcapNumber = result.getInt("PCAP_NUMBER");
                    long fileSize = result.getLong("FILE_SIZE") * 1024L;
                    long startTime = result.getLong("START_TIME") * 1000L;
                    long endTime = result.getLong("END_TIME") * 1000L;
                    int attackTypevalue = result.getInt("ATTACK_TYPE");
                    int protocol = result.getInt("PROTOCOL");
                    int port = result.getInt("PORT");
                    String zoneIp = result.getString("ZONE_IP");
                    PcapIdentifier pcapIdentifier = new PcapIdentifier(pcapType, strDeviceIp, zoneId);
                    pcapIdentifier.setDeviceType(deviceType);
                    pcapIdentifier.setZoneIp(zoneIp);
                    try {
                        PcapFileInfo pcapFileInfo = new PcapFileInfo(pcapIdentifier, pcapId, fileName);
                        pcapFileInfo.setBeginTime(startTime);
                        pcapFileInfo.setCaptureNumber(pcapNumber);
                        pcapFileInfo.setPcapFilePkId(pkId);
                        pcapFileInfo.setEndTime(endTime);
                        pcapFileInfo.setFileSize(fileSize);
                        pcapFileInfo.setCompleted(status == 0);
                        if (pcapIdentifier.isZoneType()) {
                            AttackType attackType = AttackTypeFactory.getInstance().getAttackType(attackTypevalue, protocol, port);
                            pcapFileInfo.setAttackType(attackType);
                        }
                        fileList.add(pcapFileInfo);
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"when retrieve pcapFileInfo ,error happend,e");
                    }
                }
                if (fileList.isEmpty()) continue;
                task.init(fileList);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("after init capture task by pcap file " + fileList + " the task is :" + task.getTaskId()));
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"query capture pcapFileInfo file  error", (Throwable)e);
            }
            catch (Throwable throwable) {
                PcapFileInfoRepository.closeConn(query, con, result);
                throw throwable;
            }
            PcapFileInfoRepository.closeConn(query, con, result);
        }
        PcapFileInfoRepository.closeConn(query, con, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PcapFileInfo> queryMaxPcapFileIndex(long queryTaskId, int devType) {
        PreparedStatement query = null;
        Connection con = null;
        ResultSet result = null;
        ArrayList<PcapFileInfo> fileList = new ArrayList<PcapFileInfo>();
        try {
            con = this.getConnection();
            int completeFlag = 1;
            String sql = "SELECT f.* FROM ATIC_PCAP_FILE f,(SELECT ATTACK_TYPE,DEVICE_IP,DEVICE_TYPE,MAX(START_TIME) START_TIME FROM ATIC_PCAP_FILE WHERE pcap_id = ? AND DEVICE_TYPE = ? GROUP BY ATTACK_TYPE,DEVICE_IP,DEVICE_TYPE) d WHERE f.ATTACK_TYPE = d.ATTACK_TYPE AND f.DEVICE_IP = d.DEVICE_IP AND f.DEVICE_TYPE = d.DEVICE_TYPE AND f.start_time = d.START_TIME AND f.pcap_id = ? AND f.DEVICE_TYPE = ? UNION SELECT * FROM ATIC_PCAP_FILE WHERE pcap_id= ? AND STATUS = ? AND DEVICE_TYPE = ? ";
            query = con.prepareStatement(sql);
            query.setLong(1, queryTaskId);
            query.setInt(2, devType);
            query.setLong(3, queryTaskId);
            query.setInt(4, devType);
            query.setLong(5, queryTaskId);
            query.setInt(6, completeFlag);
            query.setInt(7, devType);
            result = query.executeQuery();
            while (result.next()) {
                Long pkId = result.getLong("PKID");
                Long taskId = result.getLong("PCAP_ID");
                int deviceType = result.getInt("DEVICE_TYPE");
                String strDeviceIp = result.getString("DEVICE_IP");
                String fileName = result.getString("FILE_NAME");
                int pcapType = result.getInt("PCAP_TYPE");
                Long zoneId = result.getLong("ZONE_ID");
                int status = result.getInt("STATUS");
                int pcapNumber = result.getInt("PCAP_NUMBER");
                long fileSize = result.getLong("FILE_SIZE") * 1024L;
                long startTime = result.getLong("START_TIME") * 1000L;
                long endTime = result.getLong("END_TIME") * 1000L;
                int attackTypevalue = result.getInt("ATTACK_TYPE");
                int protocol = result.getInt("PROTOCOL");
                int port = result.getInt("PORT");
                String zoneIp = result.getString("ZONE_IP");
                PcapIdentifier pcapIdentifier = new PcapIdentifier(pcapType, strDeviceIp, zoneId);
                pcapIdentifier.setDeviceType(deviceType);
                pcapIdentifier.setZoneIp(zoneIp);
                try {
                    PcapFileInfo pcapFileInfo = new PcapFileInfo(pcapIdentifier, taskId, fileName);
                    pcapFileInfo.setBeginTime(startTime);
                    pcapFileInfo.setCaptureNumber(pcapNumber);
                    pcapFileInfo.setPcapFilePkId(pkId);
                    pcapFileInfo.setEndTime(endTime);
                    pcapFileInfo.setFileSize(fileSize);
                    pcapFileInfo.setCompleted(status == 0);
                    if (pcapIdentifier.isZoneType()) {
                        AttackType attackType = AttackTypeFactory.getInstance().getAttackType(attackTypevalue, protocol, port);
                        pcapFileInfo.setAttackType(attackType);
                    }
                    fileList.add(pcapFileInfo);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"when retrieve pcapFileInfo ,error happend,e");
                }
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"query capture pcapFileInfo file  error", (Throwable)e);
            }
            catch (Throwable throwable) {
                PcapFileInfoRepository.closeConn(query, con, result);
                throw throwable;
            }
            PcapFileInfoRepository.closeConn(query, con, result);
        }
        PcapFileInfoRepository.closeConn(query, con, result);
        return fileList;
    }

    public static void closeConn(Statement pstmt, Connection conn, ResultSet result) {
        if (null != result) {
            try {
                result.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"result.close() is error SQLException");
            }
        }
        try {
            if (null != pstmt) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query.close() error", (Throwable)e);
        }
        try {
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"con.close() error", (Throwable)e);
        }
    }
}

