/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.protal;

import com.hs.atic.collector.biz.event.protal.ProtalServiceFactory;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.alarm.IpInfoKey;
import com.hs.atic.collector.entity.event.AbnormalEvent;
import com.hs.atic.collector.entity.event.IpAttackEvent;
import com.hs.atic.collector.entity.protal.ProtalAttackEvent;
import com.hs.atic.collector.entity.protal.ProtalAttackFlowEvent;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class ProtalAttackDbUtil
extends RepositoryAdaptor<IpAttackEvent> {
    private static final ProtalAttackDbUtil INSTANCE = new ProtalAttackDbUtil();
    private static final Map<IpInfoKey, Long> ATTACK_EVENT_ID_MAP = new HashMap<IpInfoKey, Long>();
    private static final Map<IpInfoKey, Long> END_ATTACK_LIST = new HashMap<IpInfoKey, Long>();
    private static final String PROTAL_ATTACK_EVNET_NAME = "com.hs.atic.collector.entity.protal.ProtalAttackEvent";
    private static final String PROATL_ATTACK_FLOW_NAME = "com.hs.atic.collector.entity.protal.ProtalAttackFlowEvent";
    private static final Repository PROTAL_ATTACK_EVENT_REPOSITORY = RepositoryFactory.getInstance().getRepository("com.hs.atic.collector.entity.protal.ProtalAttackEvent");
    private static final Repository PROTAL_ATTACK_FLOW_REPOSITORY = RepositoryFactory.getInstance().getRepository("com.hs.atic.collector.entity.protal.ProtalAttackFlowEvent");
    private Logger logger = LogManager.getInstance().getMssLogger();

    private ProtalAttackDbUtil() {
    }

    public static ProtalAttackDbUtil getInstance() {
        return INSTANCE;
    }

    public void createProtalAttackEvents(List<AbnormalEvent> events) {
        if (!ProtalServiceFactory.getInstance().isStartProtalProcess() || events.isEmpty()) {
            return;
        }
        LOGGER.info((Object)("createProtalAttackEvents start, events.size()" + events.size()));
        ArrayList<ProtalAttackEvent> protalCreateAttacks = new ArrayList<ProtalAttackEvent>();
        ArrayList<ProtalAttackEvent> protalUpdateAttacks = new ArrayList<ProtalAttackEvent>();
        ArrayList<ProtalAttackFlowEvent> attackFlowList = new ArrayList<ProtalAttackFlowEvent>();
        ProtalAttackFlowEvent attackFlow = null;
        ProtalAttackEvent createEvent = null;
        ProtalAttackEvent updateEvent = null;
        IpInfoKey ipInfoKey = null;
        IpAttackEvent attackEvent = null;
        for (AbnormalEvent event : events) {
            if (event instanceof IpAttackEvent && event.isFromCleanDevice()) {
                attackEvent = (IpAttackEvent)event;
                String attackTypes = this.getAttackType(attackEvent);
                if (!(attackTypes = this.getValidAttackTypes(attackTypes)).isEmpty()) {
                    createEvent = new ProtalAttackEvent(attackEvent);
                    createEvent.setAttakcType(attackTypes);
                    createEvent.setCreate(true);
                    protalCreateAttacks.add(createEvent);
                    if (attackEvent.isNormal()) {
                        updateEvent = new ProtalAttackEvent(attackEvent);
                        updateEvent.setAttakcType(attackTypes);
                        protalUpdateAttacks.add(updateEvent);
                    } else {
                        ipInfoKey = new IpInfoKey(event.getIdentifier());
                        ATTACK_EVENT_ID_MAP.put(ipInfoKey, event.getAbnormalPkId());
                    }
                    attackFlow = new ProtalAttackFlowEvent(attackEvent.getIdentifierCopy());
                    attackFlow.setEventId(attackEvent.getAbnormalPkId());
                    attackFlow.setAttackKbps(attackEvent.getDropKbits() / 64L);
                    attackFlow.setAttackPps(attackEvent.getDropPkgs() / 64L);
                    attackFlowList.add(attackFlow);
                    continue;
                }
                this.logger.error((Object)("createProtalAttackEvents drop a  event of attackTypes is empty:  event=" + event.toString()));
                continue;
            }
            this.logger.debug((Object)("createProtalAttackEvents drop a event for not from clean device or not a attackEvent.  device=" + event.getDeviceIp() + ", zoneIP=" + event.getZoneIp()));
        }
        PROTAL_ATTACK_EVENT_REPOSITORY.createObjects(protalCreateAttacks);
        PROTAL_ATTACK_FLOW_REPOSITORY.createObjects(attackFlowList);
        PROTAL_ATTACK_EVENT_REPOSITORY.createObjects(protalUpdateAttacks);
    }

    public void udpateProtalAttackEvents(List<AbnormalEvent> events) {
        if (!ProtalServiceFactory.getInstance().isStartProtalProcess() || events.isEmpty()) {
            return;
        }
        LOGGER.info((Object)("udpateProtalAttackEvents start, events.size()" + events.size()));
        ArrayList<ProtalAttackEvent> protalAttacks = new ArrayList<ProtalAttackEvent>();
        ProtalAttackEvent protalEvent = null;
        IpInfoKey ipInfoKey = null;
        for (AbnormalEvent event : events) {
            if (event instanceof IpAttackEvent && event.isFromCleanDevice()) {
                protalEvent = new ProtalAttackEvent((IpAttackEvent)event);
                protalEvent.setAttakcType(this.getAttackType((IpAttackEvent)event));
                protalAttacks.add(protalEvent);
                if (!event.isNormal()) continue;
                ipInfoKey = new IpInfoKey(event.getIdentifier());
                END_ATTACK_LIST.put(ipInfoKey, event.getAbnormalPkId());
                this.logger.debug((Object)("Add a end evnet to END_ATTACK_LIST, ipInfokey=" + ipInfoKey.toString() + ", protalEvent=" + protalEvent.toString()));
                continue;
            }
            this.logger.debug((Object)("udpateProtalAttackEvents drop a event for not from clean device or not attackEvent. deviceIp=" + event.getDeviceIp() + ", zoneIP=" + event.getZoneIp()));
        }
        PROTAL_ATTACK_EVENT_REPOSITORY.createObjects(protalAttacks);
    }

    private String getAttackType(IpAttackEvent event) {
        String attackTypes = this.getAttackTypeString(event.getAttackedTypes());
        if (null == attackTypes || attackTypes.trim().isEmpty()) {
            return this.getAttackTypeString(event.getAlertedTypes());
        }
        return attackTypes;
    }

    private String getValidAttackTypes(String attackTypes) {
        StringBuffer validAttackTypes = new StringBuffer();
        if (null == attackTypes || attackTypes.isEmpty()) {
            return "";
        }
        String[] attackTypeAry = attackTypes.split(",");
        int validNum = 0;
        for (int i = 0; i < attackTypeAry.length; ++i) {
            if (!this.isNumeric(attackTypeAry[i])) continue;
            if (validNum > 0) {
                validAttackTypes.append(",");
            }
            validAttackTypes.append(attackTypeAry[i]);
            ++validNum;
        }
        return validAttackTypes.toString();
    }

    private boolean isNumeric(String str) {
        if (null == str || str.isEmpty()) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public long getEventId(IpInfoKey ipInfoKey) {
        Long eventId = ATTACK_EVENT_ID_MAP.get(ipInfoKey);
        if (null == eventId) {
            this.logger.debug((Object)("get attackEventId null, ipInfoKey=" + ipInfoKey.toString() + "; ATTACK_EVENT_ID_MAP=" + ATTACK_EVENT_ID_MAP.toString()));
            return 0L;
        }
        if (END_ATTACK_LIST.containsKey(ipInfoKey)) {
            Long attackEventId = ATTACK_EVENT_ID_MAP.get(ipInfoKey);
            Long endEventId = END_ATTACK_LIST.get(ipInfoKey);
            if (endEventId.equals(attackEventId)) {
                ATTACK_EVENT_ID_MAP.remove(ipInfoKey);
                END_ATTACK_LIST.remove(ipInfoKey);
            } else {
                END_ATTACK_LIST.remove(ipInfoKey);
            }
        }
        return eventId;
    }
}

