/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.protal;

import com.hs.atic.collector.db.DbWriteTool;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.util.LogManager;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class ProtalFileRepository<T extends Event>
extends RepositoryAdaptor<T> {
    private static final Logger LOGGER = LogManager.getInstance().getMssLogger();
    private DbWriteTool writer = DbWriteTool.getInstance();

    @Override
    public void createObjects(List<T> objs) {
        List<T> events = this.filter(objs);
        if (!events.isEmpty()) {
            Event o = (Event)events.get(0);
            String tableName = this.getFlieName(o);
            try {
                String[] lines = new String[events.size()];
                int i = 0;
                for (Event each : events) {
                    lines[i] = this.getDbString(each) + LogManager.NEXT_LINE;
                    ++i;
                }
                this.writer.writeProtalEventToFile(tableName, lines);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)"writeToDb error");
            }
        }
    }

    protected List<T> filter(List<T> objs) {
        return objs;
    }

    protected abstract String getDbString(T var1);

    protected abstract String getFlieName(T var1);
}

