/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.protal;

import com.hs.atic.collector.db.protal.ProtalFileRepository;
import com.hs.atic.collector.entity.protal.ProtalFlowEvent;
import com.hs.atic.collector.util.CommonUtil;

public class ProtalFlowEventRepository
extends ProtalFileRepository<ProtalFlowEvent> {
    private static final String IP_FLOW_LOG = "ip_flow_log";
    private static final String IP_FLOW_HOUR_LOG = "ip_flow_hour_log";
    private static final String IP_FLOW_DROP_LOG = "ip_flow_drop_log";
    private static final String IP_FLOW_DROP_HOUR_LOG = "ip_flow_drop_hour_log";
    private static final String ZONE_FLOW_LOG = "zone_flow_log";
    private static final String ZONE_FLOW_HOUR_LOG = "zone_flow_hour_log";
    private static final String ZONE_FLOW_DROP_LOG = "zone_flow_drop_log";
    private static final String ZONE_FLOW_DROP_HOUR_LOG = "zone_flow_drop_hour_log";

    @Override
    protected String getDbString(ProtalFlowEvent event) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(CommonUtil.transferlong2String(event.getLogTime()));
        buffer.append(";");
        buffer.append(0);
        buffer.append(";");
        buffer.append(event.getZoneId());
        buffer.append(";");
        if (event.isZoneIp()) {
            buffer.append(event.getZoneIp());
            buffer.append(";");
            buffer.append(event.getIpLocation());
            buffer.append(";");
        }
        buffer.append(0);
        buffer.append(";");
        buffer.append(event.getDeviceIp());
        buffer.append(";");
        buffer.append(CommonUtil.transDeviceType(event.getDeviceType()));
        buffer.append(";");
        buffer.append(event.getAllPps());
        buffer.append(";");
        buffer.append(event.getAllKbps());
        buffer.append(";");
        buffer.append(0);
        buffer.append(";");
        buffer.append(0);
        buffer.append(";");
        buffer.append(event.getTcpPps());
        buffer.append(";");
        buffer.append(event.getTcpKbps());
        buffer.append(";");
        buffer.append(event.getUdpPps());
        buffer.append(";");
        buffer.append(event.getUdpKbps());
        buffer.append(";");
        buffer.append(event.getIcmpPps());
        buffer.append(";");
        buffer.append(event.getIcmpKbps());
        buffer.append(";");
        buffer.append(event.getOtherPps());
        buffer.append(";");
        buffer.append(event.getOtherKbps());
        buffer.append(";");
        buffer.append(event.getHttpPps());
        buffer.append(";");
        buffer.append(event.getHttpKbps());
        buffer.append(";");
        buffer.append(event.getHttpsPps());
        buffer.append(";");
        buffer.append(event.getHttpsKbps());
        buffer.append(";");
        buffer.append(0);
        buffer.append(";");
        buffer.append(0);
        buffer.append(";");
        buffer.append(event.getDnsUdpPps());
        buffer.append(";");
        buffer.append(event.getDnsUdpKbps());
        buffer.append(";");
        buffer.append(event.getSipInvitePps());
        buffer.append(";");
        buffer.append(event.getSipInviteKbps());
        return buffer.toString();
    }

    @Override
    protected String getFlieName(ProtalFlowEvent o) {
        if (o.isZoneIp()) {
            if (o.isIsDropFlow()) {
                if (o.isIsHourEvent()) {
                    return IP_FLOW_DROP_HOUR_LOG;
                }
                return IP_FLOW_DROP_LOG;
            }
            if (o.isIsHourEvent()) {
                return IP_FLOW_HOUR_LOG;
            }
            return IP_FLOW_LOG;
        }
        if (o.isZoneEvent()) {
            if (o.isIsDropFlow()) {
                if (o.isIsHourEvent()) {
                    return ZONE_FLOW_DROP_HOUR_LOG;
                }
                return ZONE_FLOW_DROP_LOG;
            }
            if (o.isIsHourEvent()) {
                return ZONE_FLOW_HOUR_LOG;
            }
            return ZONE_FLOW_LOG;
        }
        return IP_FLOW_LOG;
    }
}

