/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.protal;

import com.hs.atic.collector.biz.event.protal.ProtalServiceFactory;
import com.hs.atic.collector.entity.protal.ProtalServiceConfInfo;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.protal.ProtalConstants;
import com.hs.atic.collector.util.protal.ProtalUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public final class SftpImportTool
implements Runnable {
    private static final Logger LOGGER = LogManager.getInstance().getMssLogger();
    private static final int MAX_IMPORT_FILE_NUM = 100;
    private static SftpImportTool instance = new SftpImportTool();
    private static ChannelSftp sftp = null;
    private static List<String> improtSucessFileNames = new ArrayList<String>();
    private String hostKey = null;

    private SftpImportTool() {
    }

    public static SftpImportTool getInstance() {
        return instance;
    }

    @Override
    public void run() {
        File directory;
        if (ProtalServiceFactory.getInstance().isStartProtalProcess() && (directory = new File(ProtalConstants.PROTAL_EVENT_FILE_DIRECTORY)).exists()) {
            this.deleteOldFile();
            this.writeAndUploadRestartFile();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Thread.sleep error", (Throwable)e);
            }
        }
        while (true) {
            if (ProtalServiceFactory.getInstance().isStartProtalProcess()) {
                this.scanFilesAndImport();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)"Thread.sleep error", (Throwable)e);
                }
                continue;
            }
            try {
                Thread.sleep(30000L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Thread.sleep error", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void deleteOldFile() {
        try {
            File directory = new File(ProtalConstants.PROTAL_EVENT_FILE_DIRECTORY);
            File[] temp = directory.listFiles();
            if (temp != null) {
                for (File file : temp) {
                    if (file.delete()) continue;
                    LOGGER.error((Object)"delete file in error");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"deleteOldFile error:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndUploadRestartFile() {
        FileOutputStream outputStream = null;
        try {
            String fileName = ProtalConstants.PROTAL_EVENT_FILE_DIRECTORY + File.separator + "temp_" + "Atic_Collector_Restart_" + System.currentTimeMillis() + ".txt";
            File file = new File(fileName);
            outputStream = new FileOutputStream(file);
            String text = "Collector is restart ok.";
            outputStream.write(text.getBytes("utf-8"));
            outputStream.close();
            outputStream = null;
            this.scanFilesAndImport();
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"writeAndUploadRestartFile error:");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"writeAndUploadRestartFile error:", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"writeAndUploadRestartFile error:", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"writeRestartFile error:", (Throwable)e);
                }
            }
        }
    }

    private void scanFilesAndImport() {
        try {
            List<File> files = this.scanFile();
            if (!files.isEmpty()) {
                SftpImportTool.setSftp(this.getSftpConnect());
                if (sftp != null) {
                    this.doSftpImprot(sftp, files);
                } else {
                    LOGGER.error((Object)"Get sftp service null.");
                }
            }
            files.clear();
        }
        catch (Exception e) {
            LOGGER.error((Object)"SftpImportTool run errorProtalAttackMinSumHandler:", (Throwable)e);
        }
        finally {
            if (null != sftp) {
                try {
                    sftp.disconnect();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Thread.sleep error", (Throwable)e);
                }
                sftp = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSftpImprot(ChannelSftp newSftp, List<File> newFiles) {
        FileInputStream inputStream = null;
        boolean isBreak = false;
        for (File file : newFiles) {
            String fileName = file.getName();
            boolean improtSucess = false;
            try {
                inputStream = new FileInputStream(file);
                newSftp.put((InputStream)inputStream, fileName);
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)"Thread.sleep error", (Throwable)e);
                }
                newSftp.rename(fileName, fileName.substring("temp_".length()));
                improtSucess = true;
                LOGGER.info((Object)("improt success of " + fileName));
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)("Improt file error, fileName=" + fileName));
                isBreak = true;
            }
            catch (SftpException e) {
                LOGGER.error((Object)("Improt file error, fileName=" + fileName + "; "), (Throwable)e);
                isBreak = true;
            }
            finally {
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"instream.close() error,", (Throwable)e);
                    }
                }
            }
            if (improtSucess) {
                this.deleteSussFile(file);
            }
            if (!isBreak) continue;
            break;
        }
    }

    private void deleteSussFile(File file) {
        String fileName = file.getName();
        try {
            if (file.delete()) {
                LOGGER.info((Object)("delete success of import succeed file: " + fileName));
            } else {
                improtSucessFileNames.add(fileName);
                LOGGER.error((Object)("delete error of import succeed file: " + fileName + ", now improtSucessFileNames.size=" + improtSucessFileNames.size()));
            }
        }
        catch (RuntimeException e) {
            improtSucessFileNames.add(fileName);
            LOGGER.error((Object)("delete error of import succeed file: " + fileName + ", now improtSucessFileNames.size=" + improtSucessFileNames.size()));
        }
    }

    private ChannelSftp getSftpConnect() {
        ProtalServiceFactory.getInstance();
        ProtalServiceConfInfo serviceInfo = ProtalServiceFactory.getServiceInfo();
        LOGGER.debug((Object)("the serviceInfo=" + serviceInfo.toString()));
        ChannelSftp newSftp = null;
        try {
            newSftp = this.connectSftp(serviceInfo);
        }
        catch (JSchException e) {
            LOGGER.error((Object)("Get sftp service error, service=" + serviceInfo.toString() + ". " + e.getMessage()));
        }
        if (null == newSftp) {
            newSftp = this.reGetConnect();
        }
        return newSftp;
    }

    private ChannelSftp reGetConnect() {
        ChannelSftp newSftp = null;
        ProtalServiceConfInfo serviceInfo = null;
        try {
            serviceInfo = ProtalUtil.getInstance().getMssConfFromManger();
            if (serviceInfo == null) {
                LOGGER.error((Object)"serviceInfo is NULL");
            } else if (!CommonUtil.isNull(serviceInfo.getSftpServerIp()) && !"0".equals(serviceInfo.getSftpServerIp())) {
                ProtalUtil.getInstance().updateSftpConf(serviceInfo);
                newSftp = this.connectSftp(serviceInfo);
            }
        }
        catch (JSchException e) {
            LOGGER.error((Object)("Get sftp service error, service=" + serviceInfo + ". " + e.getMessage()));
            return null;
        }
        return newSftp;
    }

    public ChannelSftp connectSftp(ProtalServiceConfInfo serviceInfo) throws JSchException {
        String host = serviceInfo.getSftpServerIp();
        int port = serviceInfo.getSftpPort();
        String username = serviceInfo.getSftpUser();
        String psw = serviceInfo.getSftpPwd();
        ChannelSftp newSftp = null;
        try {
            Session session;
            JSch jsch = new JSch();
            if (null != this.hostKey && !"".equals(this.hostKey)) {
                LOGGER.info((Object)"hostKey will be validate");
                StringBuffer buffer = new StringBuffer();
                buffer.append(host);
                buffer.append(" ");
                buffer.append("ssh-rsa");
                buffer.append(" ");
                buffer.append(this.hostKey);
                ByteArrayInputStream in = new ByteArrayInputStream(buffer.toString().getBytes("UTF-8"));
                jsch.setKnownHosts((InputStream)in);
            }
            if ((session = jsch.getSession(username, host, port)) != null) {
                session.setConfig("cipher.c2s", "aes256-ctr");
                session.setConfig("mac.c2s", "hmac-sha2-256");
                session.setConfig("cipher.s2c", "aes256-ctr");
                session.setConfig("mac.s2c", "hmac-sha2-256");
                session.setConfig("CheckCiphers", "aes256-ctr");
                LOGGER.debug((Object)"get sshSession not null");
                session.setPassword(psw);
                session.setConfig("StrictHostKeyChecking", "no");
                session.connect(10000);
                Channel channel = session.openChannel("sftp");
                channel.connect(1000);
                newSftp = (ChannelSftp)channel;
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("get hostkey info error" + e.getMessage()));
        }
        catch (JSchException e) {
            LOGGER.error((Object)(host + "-The sftp server hostkey was not accepted by the verifier callback!"));
        }
        return newSftp;
    }

    private List<File> scanFile() {
        ArrayList<File> toImportFiles = new ArrayList<File>();
        File directory = new File(ProtalConstants.PROTAL_EVENT_FILE_DIRECTORY);
        File[] files = directory.listFiles(new FilenameFilterImpl());
        if (files != null && files.length != 0) {
            Collections.addAll(toImportFiles, files);
            LOGGER.info((Object)("toImportFiles size = " + toImportFiles.size()));
        }
        return toImportFiles;
    }

    public static ChannelSftp getSftp() {
        return sftp;
    }

    public static void setSftp(ChannelSftp sftp) {
        SftpImportTool.sftp = sftp;
    }

    public void setHostKey(String hostKey) {
        this.hostKey = hostKey;
    }

    private static class FilenameFilterImpl
    implements FilenameFilter {
        private int index = 0;

        private FilenameFilterImpl() {
        }

        @Override
        public boolean accept(File dir, String name) {
            ++this.index;
            return name.endsWith(".txt") && this.index <= 100 && !improtSucessFileNames.contains(name);
        }
    }
}

